/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.img.seal;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class SquareSeal {
    private int imageWidth = 100;
    private int imageHigth = 105;
    private String text;
    private Font textFont = new Font("\u5b8b\u4f53", 1, 40);
    private Color textColor = Color.red;
    private int border = 5;
    private float lineHeight = -1.0f;
    private float maxWidth = 500.0f;
    private int maxLine = 10;
    private boolean trim = false;
    private boolean lineIndent = false;
    private double angle = 0.0;
    private int alpha = 0;

    public byte[] squarePng() throws IOException {
        BufferedImage image = new BufferedImage(this.imageWidth, this.imageHigth, 1);
        Graphics2D g2D = (Graphics2D)image.getGraphics();
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2D.setColor(this.textColor);
        g2D.fillRect(0, 0, this.imageWidth, this.imageHigth);
        g2D.setColor(Color.white);
        g2D.fillRect(this.border, this.border, this.imageWidth - this.border * 2, this.imageHigth - this.border * 2);
        g2D.setColor(this.textColor);
        g2D.setFont(this.textFont);
        g2D.rotate(Math.toRadians(this.angle), this.imageWidth / 2, this.imageHigth / 2);
        if (this.text != null && !"".equals(this.text)) {
            FontMetrics fontMetrics = g2D.getFontMetrics(this.textFont);
            int lineWidth = fontMetrics.stringWidth(this.text);
            int height = fontMetrics.getHeight() - fontMetrics.getAscent() / 2;
            int width = this.imageWidth - 2 * this.border;
            if (this.text.indexOf("\n") >= 0 || this.text.indexOf("\r\n") >= 0) {
                this.drawString(g2D, this.text, this.lineHeight < 0.0f ? (float)fontMetrics.getHeight() : this.lineHeight, this.maxWidth, this.maxLine, this.border, 0.0f, this.trim, this.lineIndent);
            } else {
                this.drawString(g2D, this.text, this.lineHeight < 0.0f ? (float)fontMetrics.getHeight() : this.lineHeight, this.maxWidth, this.maxLine, this.border, (float)(this.imageHigth + height) / 2.0f, this.trim, this.lineIndent);
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.alpha < 0) {
            this.alpha = 0;
        } else if (this.alpha > 10) {
            this.alpha = 10;
        }
        int j1 = image.getMinY();
        while (j1 < image.getHeight()) {
            int j2 = image.getMinX();
            while (j2 < image.getWidth()) {
                int rgb = image.getRGB(j2, j1);
                rgb = this.alpha * 255 / 10 << 24 | rgb & 0xFFFFFF;
                image.setRGB(j2, j1, rgb);
                ++j2;
            }
            ++j1;
        }
        ImageIO.write((RenderedImage)image, "PNG", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void drawString(Graphics2D g, String text, float lineHeight, float maxWidth, int maxLine, float left, float top, boolean trim, boolean lineIndent) {
        if (text == null || text.length() == 0) {
            return;
        }
        if (trim) {
            text = text.replaceAll("\\n+", "\n").trim();
        }
        if (lineIndent) {
            text = "\u3000\u3000" + text.replaceAll("\\n", "\n\u3000\u3000");
        }
        this.drawString(g, text, lineHeight, maxWidth, maxLine, left, top);
    }

    private void drawString(Graphics2D g, String text, float lineHeight, float maxWidth, int maxLine, float left, float top) {
        if (text == null || text.length() == 0) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            sb.append(c);
            int stringWidth = fm.stringWidth(sb.toString());
            if (i == text.indexOf("\n") || i == text.indexOf("\r\n")) {
                if (i == text.indexOf("\n") || i == text.indexOf("\r\n")) {
                    ++i;
                }
                if (maxLine > 1) {
                    this.drawString(g, text.substring(0, i), (int)top);
                    this.drawString(g, text.substring(i), lineHeight, maxWidth, maxLine - 1, left, top + lineHeight);
                } else if (i > 0) {
                    g.drawString(String.valueOf(text.substring(0, i - 1)) + "\u2026", left, top);
                }
                return;
            }
            ++i;
        }
        this.drawString(g, text, -1);
    }

    private void drawString(Graphics2D g, String text, int offsetH) {
        FontMetrics fontMetrics = g.getFontMetrics(this.textFont);
        int lineWidth = fontMetrics.stringWidth(text);
        int height = fontMetrics.getHeight() - fontMetrics.getAscent() / 2;
        int width = this.imageWidth - 2 * this.border;
        if (lineWidth <= width) {
            int dis = width - lineWidth;
            int space = dis / (text.length() + 1);
            int start = this.border;
            int i = 0;
            while (i < text.length()) {
                String c = String.valueOf(text.charAt(i));
                int cWidth = fontMetrics.stringWidth(c);
                start += space;
                if (offsetH >= 0) {
                    g.drawString(c, (float)start, offsetH == 0 ? (float)(this.imageHigth - height) / 2.0f : (float)(this.imageHigth - height) / 2.0f + (float)offsetH);
                } else {
                    g.drawString(c, (float)start, (float)(this.imageHigth + height) / 2.0f);
                }
                start += cWidth;
                ++i;
            }
        } else {
            float dis = (float)width / (float)(text.length() + 1);
            int i = 0;
            while (i < text.length()) {
                String c = String.valueOf(text.charAt(i));
                int cWidth = fontMetrics.stringWidth(c);
                int start = (int)((float)this.border + dis * (float)(i + 1) - (float)(cWidth / 2));
                if (offsetH >= 0) {
                    g.drawString(c, (float)start, offsetH == 0 ? (float)(this.imageHigth - height) / 2.0f : (float)(this.imageHigth - height) / 2.0f + (float)offsetH);
                } else {
                    g.drawString(c, (float)start, (float)(this.imageHigth + height) / 2.0f);
                }
                ++i;
            }
        }
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHigth() {
        return this.imageHigth;
    }

    public void setImageHigth(int imageHigth) {
        this.imageHigth = imageHigth;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setText(String text, Font font) {
        this.text = text;
        this.textFont = font;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public float getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(float lineHeight) {
        this.lineHeight = lineHeight;
    }

    public float getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(float maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getMaxLine() {
        return this.maxLine;
    }

    public void setMaxLine(int maxLine) {
        this.maxLine = maxLine;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public boolean isLineIndent() {
        return this.lineIndent;
    }

    public void setLineIndent(boolean lineIndent) {
        this.lineIndent = lineIndent;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        SquareSeal square = new SquareSeal();
        square.setImageWidth(283);
        square.setImageHigth(113);
        square.setText("\u91d1\u683c\u79d1\u6280\u80a1\u4efd\u6709\u9650\u516c\u53f8", new Font("\u5b8b\u4f53", 1, 25));
        square.setTextColor(new Color(Integer.parseInt("FF0000", 16)));
        square.setBorder(3);
        square.setAngle(-45.0);
        square.setAlpha(2);
        byte[] bs = square.squarePng();
        FileOutputStream file = new FileOutputStream(new File("d:/tmp/square.png"));
        file.write(bs);
    }
}

