/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.img.seal;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class EllipseSeal {
    private static final int FONT_MIN_SIZE = 26;
    private int times = 2;
    private double scalex = 0.7f;
    private int width;
    private int height;
    private Font textFont;
    private int borderWidth;
    private BufferedImage bufferedImage;
    private Graphics2D g2;

    public EllipseSeal(int width, int height, int borderWidth) {
        this.width = width;
        this.height = height;
        this.borderWidth = borderWidth;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    public double getScalex() {
        return this.scalex;
    }

    public void setScalex(double scalex) {
        this.scalex = scalex;
    }

    public int getTimes() {
        return this.times;
    }

    public void setTimes(int times) {
        this.times = times;
    }

    public void init() {
        this.width *= this.times;
        this.height *= this.times;
        this.borderWidth *= this.times;
        if (this.textFont == null) {
            this.textFont = new Font("\u5b8b\u4f53", 1, 26);
        }
        if (26 > this.textFont.getSize()) {
            throw new IllegalArgumentException("\u6587\u672c\u5927\u5c0f\u4e0d\u80fd\u5c0f\u4e8e26");
        }
        this.bufferedImage = new BufferedImage(this.width, this.height, 1);
        this.g2 = (Graphics2D)this.bufferedImage.getGraphics();
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setColor(Color.white);
        this.g2.fillRect(0, 0, this.width, this.height);
        this.g2.setColor(Color.red);
        this.g2.setStroke(new BasicStroke(this.borderWidth));
        int dis = this.borderWidth / 2;
        int w = this.width - 2 * this.borderWidth + dis;
        int h = this.height - 2 * this.borderWidth + dis;
        Ellipse2D.Float ellipse = new Ellipse2D.Float(dis, dis, w, h);
        this.g2.draw(ellipse);
    }

    public void drawEllipseText(int totalArcAng, float minRat, String text) {
        Point center = new Point(this.width / 2, this.height / 2);
        int radiusX = this.width / 2 - this.textFont.getSize();
        int radiusY = this.height / 2 - this.textFont.getSize();
        this.drawEllipseText(this.g2, this.textFont, center, radiusX, radiusY, totalArcAng, minRat, true, text);
    }

    public void drawCenter(String text, Font font) {
        float x = (float)this.width / 2.0f;
        float y = (float)this.height / 2.0f;
        this.drawString(text, font, x, y);
    }

    public void drawText(String text, Font font, float percentx, float percenty) {
        float x = (float)this.width * percentx;
        float y = (float)this.height * percenty;
        this.drawString(text, font, x, y);
    }

    public void drawString(String text, Font font, float x, float y) {
        this.g2.setFont(font);
        FontMetrics fontMetrics = this.g2.getFontMetrics();
        int stringWidth = fontMetrics.stringWidth(text);
        int ascent = fontMetrics.getAscent();
        int leading = fontMetrics.getLeading();
        this.g2.drawString(text, x - (float)stringWidth / 2.0f, y + (float)ascent / 2.0f - (float)leading);
    }

    public void save(String formatName, OutputStream out) throws IOException {
        this.g2.dispose();
        ImageIO.write((RenderedImage)this.bufferedImage, formatName, out);
    }

    private void drawEllipseText(Graphics2D g2, Font font, Point center, int radiusX, int radiusY, int totalArcAng, float minRat, boolean top, String text) {
        double startAng = top ? -90.0f - (float)totalArcAng / 2.0f : 90.0f - (float)totalArcAng / 2.0f;
        int count = text.length();
        double step = 0.5;
        int alCount = (int)Math.ceil((double)totalArcAng / step) + 1;
        double[] angArr = new double[alCount];
        double[] arcLenArr = new double[alCount];
        int num = 0;
        double accArcLen = 0.0;
        angArr[num] = startAng;
        arcLenArr[num] = accArcLen;
        ++num;
        double angR = startAng * Math.PI / 180.0;
        double lastX = (double)radiusX * Math.cos(angR) + center.getX();
        double laxtY = (double)radiusY * Math.sin(angR) + center.getY();
        double i = startAng + step;
        while (num < alCount) {
            angR = i * Math.PI / 180.0;
            double x = (double)radiusX * Math.cos(angR) + center.getX();
            double y = (double)radiusY * Math.sin(angR) + center.getY();
            angArr[num] = i;
            arcLenArr[num] = accArcLen += Math.sqrt((lastX - x) * (lastX - x) + (laxtY - y) * (laxtY - y));
            lastX = x;
            laxtY = y;
            ++num;
            i += step;
        }
        g2.setFont(font);
        AffineTransform transform = AffineTransform.getScaleInstance(this.scalex, 1.0);
        Font f1 = font.deriveFont(transform);
        double arcPer = accArcLen / (double)count;
        int i2 = 0;
        while (i2 < count) {
            Font f2;
            AffineTransform transform1;
            double arcL = (double)i2 * arcPer + arcPer / 2.0;
            double ang = 0.0;
            int p = 0;
            while (p < arcLenArr.length - 1) {
                if (arcLenArr[p] <= arcL && arcL <= arcLenArr[p + 1]) {
                    ang = arcL >= (arcLenArr[p] + arcLenArr[p + 1]) / 2.0 ? angArr[p + 1] : angArr[p];
                    break;
                }
                ++p;
            }
            angR = ang * Math.PI / 180.0;
            double x = (double)((float)radiusX * (float)Math.cos(angR)) + center.getX();
            double y = (double)((float)radiusY * (float)Math.sin(angR)) + center.getY();
            double qxang = Math.atan2((double)radiusY * Math.cos(angR), (double)(-radiusX) * Math.sin(angR));
            double fxang = qxang + 1.5707963267948966;
            int index = top ? i2 : text.length() - 1 - i2;
            String c = text.substring(index, index + 1);
            g2.setFont(f1);
            FontMetrics fontMetrics = g2.getFontMetrics();
            int ascent = fontMetrics.getAscent();
            int leading = fontMetrics.getLeading();
            int w = fontMetrics.stringWidth(c);
            int h = ascent - leading;
            if (top) {
                x += (double)((float)h * minRat) * Math.cos(fxang);
                y += (double)((float)h * minRat) * Math.sin(fxang);
                x += (double)((float)(-w) / 2.0f) * Math.cos(qxang);
                y += (double)((float)(-w) / 2.0f) * Math.sin(qxang);
            } else {
                x += (double)((float)h * minRat + (float)h) * Math.cos(fxang);
                y += (double)((float)h * minRat + (float)h) * Math.sin(fxang);
                x += (double)((float)w / 2.0f) * Math.cos(qxang);
                y += (double)((float)w / 2.0f) * Math.sin(qxang);
            }
            if (top) {
                transform1 = AffineTransform.getRotateInstance(fxang -= 1.5707963267948966);
                transform1.scale(this.scalex, 1.0);
                f2 = font.deriveFont(transform1);
                g2.setFont(f2);
                g2.drawString(c, (float)x, (float)y);
            } else {
                transform1 = AffineTransform.getRotateInstance(fxang += 1.5707963267948966);
                transform1.scale(this.scalex, 1.0);
                f2 = font.deriveFont(transform1);
                g2.setFont(f2);
                g2.drawString(c, (float)x, (float)(y + (double)(3 * h / 2)));
            }
            ++i2;
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        EllipseSeal ellipse = new EllipseSeal(113, 42, 3);
        ellipse.setTextFont(new Font("\u5b8b\u4f53", 1, 25));
        ellipse.drawEllipseText(0, 0.0f, "\u4e07\u5148\u4e07");
        ellipse.save("png", new FileOutputStream(new File("d:/tmp/ellipse.png")));
    }
}

