/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.img;

import com.kgofd.ofd.img.KGTextInfo;
import com.kgofd.ofd.img.TextInfoPosType;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ImageUtils {
    private static BufferedImage _arrange(BufferedImage bi) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(bi.getWidth(), bi.getHeight(), 9);
        Graphics2D g2D = (Graphics2D)bufferedImage.getGraphics();
        g2D.drawImage((Image)bi, 0, 0, null);
        g2D.dispose();
        return bufferedImage;
    }

    private static boolean isNeedArrange(BufferedImage bi) {
        int rgb = bi.getRGB(1, 1);
        int R = (rgb & 0xFF0000) >> 16;
        int G = (rgb & 0xFF00) >> 8;
        int B = rgb & 0xFF;
        return rgb == -1 && R == 255 && G == 255 && B == 255 && 13 == bi.getType();
    }

    public static BufferedImage arrange(byte[] imgdata) throws IOException {
        BufferedImage bi = ImageIO.read(new ByteArrayInputStream(imgdata));
        if (ImageUtils.isNeedArrange(bi)) {
            bi = ImageUtils._arrange(bi);
        }
        return bi;
    }

    public static BufferedImage invalidImg(BufferedImage bi, double percent) {
        Graphics2D g = bi.createGraphics();
        g.setColor(new Color(128, 128, 128));
        double height = (float)(30.0 * percent);
        int start = (int)((double)(bi.getHeight() / 2) - height / 2.0);
        g.fillRect(0, start, bi.getWidth(), (int)(height / 3.0));
        g.fillRect(0, (int)((double)start + height / 3.0 * 2.0), bi.getWidth(), (int)(height / 3.0));
        g.dispose();
        return bi;
    }

    public static BufferedImage invalidImg(BufferedImage bi, double Xpercent, double Ypercent) {
        Graphics2D g = bi.createGraphics();
        g.setColor(new Color(128, 128, 128));
        double height = (float)(30.0 * Ypercent);
        double width = (float)(30.0 * Xpercent);
        int start = (int)((double)(bi.getHeight() / 2) - height / 2.0);
        g.fillRect(0, start, bi.getWidth(), (int)(width / 3.0));
        g.fillRect(0, (int)((double)start + height / 3.0 * 2.0), bi.getWidth(), (int)(height / 3.0));
        g.dispose();
        return bi;
    }

    public static BufferedImage resize(BufferedImage image, double scaleX, double scaleY) {
        AffineTransform transform = AffineTransform.getScaleInstance(scaleX, scaleY);
        AffineTransformOp op = new AffineTransformOp(transform, 1);
        return op.filter(image, null);
    }

    public static BufferedImage resize(BufferedImage image, double scale) {
        return ImageUtils.resize(image, scale, scale);
    }

    public static BufferedImage decrypt(BufferedImage bi) {
        int j1 = bi.getMinY();
        while (j1 < bi.getHeight()) {
            int j2 = bi.getMinX();
            while (j2 < bi.getWidth()) {
                int rgb = bi.getRGB(j2, j1);
                int R = (rgb & 0xFF0000) >> 16;
                int G = (rgb & 0xFF00) >> 8;
                int B = rgb & 0xFF;
                rgb = 255 - R < 30 && 255 - G < 30 && 255 - B < 30 || rgb == 0 ? -2894893 : -12434878;
                bi.setRGB(j2, j1, rgb);
                ++j2;
            }
            ++j1;
        }
        return bi;
    }

    public static BufferedImage alpha(BufferedImage bi) {
        ImageIcon imageIcon = new ImageIcon(bi);
        BufferedImage _bi = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 7);
        Graphics2D g2D = (Graphics2D)_bi.getGraphics();
        g2D.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
        int alpha = 0;
        int j1 = _bi.getMinY();
        while (j1 < _bi.getHeight()) {
            int j2 = _bi.getMinX();
            while (j2 < _bi.getWidth()) {
                int rgb = _bi.getRGB(j2, j1);
                int R = (rgb & 0xFF0000) >> 16;
                int G = (rgb & 0xFF00) >> 8;
                int B = rgb & 0xFF;
                if (255 - R < 30 && 255 - G < 30 && 255 - B < 30) {
                    rgb = alpha + 1 << 24 | rgb & 0xFFFFFF;
                }
                _bi.setRGB(j2, j1, rgb);
                ++j2;
            }
            ++j1;
        }
        return _bi;
    }

    public static BufferedImage addText(BufferedImage bi, List<KGTextInfo> textInfoList) {
        if (textInfoList == null || textInfoList.size() == 0) {
            return bi;
        }
        BufferedImage oldbi = bi;
        int oriWidth = oldbi.getWidth(null);
        int oriHeight = oldbi.getHeight(null);
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        ArrayList<KGTextInfo> outText = new ArrayList<KGTextInfo>();
        Graphics2D g2D = (Graphics2D)oldbi.getGraphics();
        int i = 0;
        while (i < textInfoList.size()) {
            KGTextInfo textInfo = textInfoList.get(i);
            Font font = new Font(textInfo.getFontName(), textInfo.getFontStyle(), textInfo.getFontSize());
            g2D.setFont(font);
            g2D.setColor(new Color(textInfo.getFontColor()));
            FontMetrics fontMetrics = g2D.getFontMetrics();
            int width = fontMetrics.stringWidth(textInfo.getSignText());
            int height = fontMetrics.getHeight();
            if (textInfo.getPosType() == TextInfoPosType.XY) {
                float x = textInfo.getX();
                float y = (float)oriHeight - textInfo.getY();
                if (textInfo.isCenter()) {
                    x -= (float)width / 2.0f;
                    y += (float)height / 2.0f;
                }
                g2D.drawString(textInfo.getSignText(), x, y);
            } else if (textInfo.getPosType() == TextInfoPosType.XYPERCENT) {
                float x = (float)oriWidth * textInfo.getXPercent();
                float y = (float)oriHeight - (float)oriHeight * textInfo.getYPercent();
                if (textInfo.isCenter()) {
                    x -= (float)width / 2.0f;
                    y += (float)height / 2.0f;
                }
                g2D.drawString(textInfo.getSignText(), x, y);
            } else if (!textInfo.getPosType().toString().startsWith("OUT_")) {
                int dis = height - font.getSize();
                int x = 0;
                int y = 0;
                switch (textInfo.getPosType()) {
                    case SOUTH_LEFT: {
                        g2D.drawString(textInfo.getSignText(), x, oriHeight - dis);
                        break;
                    }
                    case SOUTH_CENTER: {
                        x = oriWidth / 2;
                        g2D.drawString(textInfo.getSignText(), x - width / 2, oriHeight - dis);
                        break;
                    }
                    case SOUTH_RIGHT: {
                        g2D.drawString(textInfo.getSignText(), oriWidth - width, oriHeight - dis);
                        break;
                    }
                    case WEST_MIDDLE: {
                        y = oriHeight / 2;
                        g2D.drawString(textInfo.getSignText(), x, y + height / 2);
                        break;
                    }
                    case CENTER_MIDDLE: {
                        x = oriWidth / 2;
                        y = oriHeight / 2;
                        g2D.drawString(textInfo.getSignText(), x - width / 2, y + height / 2);
                        break;
                    }
                    case EAST_MIDDLE: {
                        y = oriHeight / 2;
                        g2D.drawString(textInfo.getSignText(), oriWidth - width, y + height / 2);
                        break;
                    }
                    case NORTH_LEFT: {
                        g2D.drawString(textInfo.getSignText(), x, height);
                        break;
                    }
                    case NORTH_CENTER: {
                        x = oriWidth / 2;
                        g2D.drawString(textInfo.getSignText(), x - width / 2, height);
                        break;
                    }
                    case NORTH_RIGHT: {
                        g2D.drawString(textInfo.getSignText(), oriWidth - width, height);
                        break;
                    }
                }
            } else {
                if (textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_LEFT || textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_MIDDLE || textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_RIGHT) {
                    if (bottom < height) {
                        bottom = height;
                    }
                } else if (textInfo.getPosType() == TextInfoPosType.OUT_NORTH_LEFT || textInfo.getPosType() == TextInfoPosType.OUT_NORTH_CENTER || textInfo.getPosType() == TextInfoPosType.OUT_NORTH_RIGHT) {
                    if (top < height) {
                        top = height;
                    }
                } else if (textInfo.getPosType() == TextInfoPosType.OUT_WEST_TOP || textInfo.getPosType() == TextInfoPosType.OUT_WEST_MIDDLE || textInfo.getPosType() == TextInfoPosType.OUT_WEST_BUTTOM) {
                    if (left < width) {
                        left = width;
                    }
                } else if (textInfo.getPosType() == TextInfoPosType.OUT_EAST_TOP || textInfo.getPosType() == TextInfoPosType.OUT_EAST_MIDDLE || textInfo.getPosType() == TextInfoPosType.OUT_EAST_BUTTOM) {
                    if (right < width) {
                        right = width;
                    }
                } else if (textInfo.getPosType() == TextInfoPosType.OUT_NORTH_WEST) {
                    if (top < height) {
                        top = height;
                    }
                    if (left < width) {
                        left = width;
                    }
                } else if (textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_WEST) {
                    if (bottom < height) {
                        bottom = height;
                    }
                    if (left < width) {
                        left = width;
                    }
                } else if (textInfo.getPosType() == TextInfoPosType.OUT_EAST_NORTH) {
                    if (top < height) {
                        top = height;
                    }
                    if (right < width) {
                        right = width;
                    }
                } else if (textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_EAST) {
                    if (bottom < height) {
                        bottom = height;
                    }
                    if (right < width) {
                        right = width;
                    }
                }
                outText.add(textInfo);
            }
            ++i;
        }
        g2D.dispose();
        if (outText.size() <= 0) {
            return oldbi;
        }
        BufferedImage newbuffimg = new BufferedImage(oriWidth + left + right, oriHeight + top + bottom, 6);
        g2D = newbuffimg.createGraphics();
        g2D.setBackground(Color.WHITE);
        g2D.fillRect(0, 0, oriWidth + left + right, oriHeight + top + bottom);
        g2D.drawImage((Image)oldbi, left, top, null);
        for (KGTextInfo textInfo : outText) {
            Font font = new Font(textInfo.getFontName(), textInfo.getFontStyle(), textInfo.getFontSize());
            g2D.setFont(font);
            g2D.setColor(new Color(textInfo.getFontColor()));
            FontMetrics fontMetrics = g2D.getFontMetrics();
            int width = fontMetrics.stringWidth(textInfo.getSignText());
            int height = fontMetrics.getHeight();
            int dis = height - font.getSize();
            int x = 0;
            int y = 0;
            if (textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_LEFT) {
                x = left + oriWidth / 6 - width / 2;
                y = top + oriHeight + bottom - dis;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_MIDDLE) {
                x = left + oriWidth / 2 - width / 2;
                y = top + oriHeight + bottom - dis;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_RIGHT) {
                x = left + (oriWidth - oriWidth / 6) - width / 2;
                y = top + oriHeight + bottom - dis;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_NORTH_LEFT) {
                x = left + oriWidth / 6 - width / 2;
                y = height;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_NORTH_CENTER) {
                x = left + oriWidth / 2 - width / 2;
                y = height;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_NORTH_RIGHT) {
                x = left + (oriWidth - oriWidth / 6) - width / 2;
                y = height;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_WEST_TOP) {
                y = top + height;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_WEST_MIDDLE) {
                y = top + oriHeight / 2 + height / 2;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_WEST_BUTTOM) {
                y = top + oriHeight - dis;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_EAST_TOP) {
                x = left + oriWidth;
                y = top + height;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_EAST_MIDDLE) {
                x = left + oriWidth;
                y = top + oriHeight / 2 + height / 2;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_EAST_BUTTOM) {
                x = left + oriWidth;
                y = top + oriHeight - dis;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_NORTH_WEST) {
                y = height;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_WEST) {
                y = top + oriHeight + bottom - dis;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_EAST_NORTH) {
                x = left + oriWidth;
                y = height;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_EAST) {
                x = left + oriWidth;
                y = top + oriHeight + bottom - dis;
            }
            g2D.drawString(textInfo.getSignText(), x, y);
        }
        g2D.dispose();
        return newbuffimg;
    }

    public static BufferedImage rotate(BufferedImage buffimg, int angle) {
        if (angle != 0) {
            int _angle = angle * 90;
            int w = buffimg.getWidth();
            int h = buffimg.getHeight();
            BufferedImage tempimg = null;
            Graphics2D graphics2d = null;
            int type = buffimg.getColorModel().getTransparency();
            if (_angle % 180 == 0) {
                tempimg = new BufferedImage(w, h, type);
                graphics2d = tempimg.createGraphics();
                graphics2d.rotate(Math.toRadians(_angle), w / 2, h / 2);
            } else if (_angle % 90 == 0) {
                tempimg = new BufferedImage(h, w, type);
                graphics2d = tempimg.createGraphics();
                if (_angle < 0) {
                    graphics2d.rotate(Math.toRadians(_angle), h / 2, h / 2);
                } else if (_angle == 90) {
                    graphics2d.rotate(Math.toRadians(_angle), h / 2, h / 2);
                } else {
                    graphics2d.rotate(Math.toRadians(_angle), w / 2, w / 2);
                }
            }
            graphics2d.drawImage((Image)buffimg, 0, 0, null);
            graphics2d.dispose();
            return tempimg;
        }
        return buffimg;
    }

    public static BufferedImage filler(BufferedImage bi, int newwidth, int newheight, int x, int y) {
        BufferedImage new_bi = new BufferedImage(newwidth, newheight, 7);
        Graphics2D g2D = (Graphics2D)new_bi.getGraphics();
        g2D.drawImage((Image)bi, x, y, null);
        g2D.dispose();
        return new_bi;
    }
}

