/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.executes.customize;

import com.kgofd.commons.KGCommonUtils;
import com.kgofd.encrypt.KGBase64;
import com.kgofd.ofd.utils.KGOfdUtils;
import com.kgofd.ofd.utils.ZipUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class OfdElectronicSeal4KGSaveSignDataToLocal {
    private byte[] signdata = null;
    private String path = "";
    private ZipFile zipFile = null;

    public OfdElectronicSeal4KGSaveSignDataToLocal(String data, String path) {
        KGBase64 base64 = new KGBase64();
        this.signdata = base64.decode(data);
        try {
            this.path = path;
            this.zipFile = new ZipFile(path);
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
    }

    public static int byteArrayToInt(byte[] b) {
        return b[3] & 0xFF | (b[2] & 0xFF) << 8 | (b[1] & 0xFF) << 16 | (b[0] & 0xFF) << 24;
    }

    public static File getFileFromBytes(byte[] b, String outputFile) {
        File file;
        block12: {
            FilterOutputStream stream = null;
            file = null;
            try {
                try {
                    file = new File(outputFile);
                    FileOutputStream fstream = new FileOutputStream(file);
                    stream = new BufferedOutputStream(fstream);
                    stream.write(b);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (stream == null) break block12;
                    try {
                        stream.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        return file;
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            return file.delete();
        }
        return false;
    }

    public boolean praseData(String entryPath) {
        try {
            ZipFile ofdFile = new ZipFile(OfdElectronicSeal4KGSaveSignDataToLocal.getFileFromBytes(this.signdata, "./temp.ofd"));
            ofdFile.extractFile("Seal.esl", "./");
            ZipUtil.addFileToZip(new File(this.path), new File("./Seal.esl"), entryPath);
            OfdElectronicSeal4KGSaveSignDataToLocal.deleteFile("./Seal.esl");
            ofdFile.extractFile("Signature.xml", "./");
            ZipUtil.addFileToZip(new File(this.path), new File("./Signature.xml"), entryPath);
            OfdElectronicSeal4KGSaveSignDataToLocal.deleteFile("./Signature.xml");
            ofdFile.extractFile("SignedValue.dat", "./");
            ZipUtil.addFileToZip(new File(this.path), new File("./SignedValue.dat"), entryPath);
            OfdElectronicSeal4KGSaveSignDataToLocal.deleteFile("./SignedValue.dat");
            OfdElectronicSeal4KGSaveSignDataToLocal.deleteFile("./temp.ofd");
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean saveData() throws ZipException, DocumentException {
        if (this.signdata != null && this.zipFile != null) {
            KGOfdUtils ofdUtils = new KGOfdUtils();
            String signDirPath = "";
            String signaturesPath = null;
            String maxSignId = "1";
            Document ofdDocument = KGOfdUtils.getDocument(this.zipFile, "OFD.xml");
            Element signaturesEle = (Element)ofdDocument.selectSingleNode("/ofd:OFD/ofd:DocBody/ofd:Signatures");
            if (signaturesEle == null) {
                signDirPath = "Doc_0/Signs/Sign_0";
                Element docBody = (Element)ofdDocument.selectSingleNode("/ofd:OFD/ofd:DocBody");
                if (docBody == null) {
                    return false;
                }
                Element ofdSign = docBody.addElement("ofd:Signatures");
                ofdSign.setText("Doc_0/Signatures.xml");
                KGOfdUtils.writeToZip(this.zipFile, "OFD.xml", ofdDocument);
                Document signatureDoc = DocumentHelper.createDocument();
                signatureDoc.setXMLEncoding("UTF-8");
                Element signatureBody = signatureDoc.addElement("ofd:Signatures");
                signatureBody.addNamespace("ofd", "http://www.ofdspec.org");
                Element maxId = signatureBody.addElement("ofd:MaxSignId");
                maxId.setText("1");
                Element signatures = signatureBody.addElement("ofd:Signature");
                signatures.addAttribute("ID", "1");
                signatures.addAttribute("Type", "Seal");
                signatures.addAttribute("BaseLoc", "Signs/Sign_0/Signature.xml");
                KGOfdUtils.writeToZip(this.zipFile, "Doc_0/Signatures.xml", signatureDoc);
            } else {
                signaturesPath = signaturesEle.getTextTrim();
                Document signaturesDocument = KGOfdUtils.getDocument(this.zipFile, signaturesPath = KGCommonUtils.converPath(signaturesPath, "Doc_0/"));
                Element maxSignIdEle = (Element)signaturesDocument.selectSingleNode("/ofd:Signatures/ofd:MaxSignId");
                if (maxSignIdEle != null) {
                    maxSignId = maxSignIdEle.getTextTrim();
                }
                signDirPath = "Doc_0/Signs/Sign_" + (Integer.parseInt(maxSignId) - 1);
                Element signatures = (Element)signaturesDocument.selectSingleNode("ofd:Signatures");
                if (signatures == null) {
                    return false;
                }
                Element signature = signatures.addElement("ofd:Signature");
                signature.addAttribute("ID", maxSignId);
                signature.addAttribute("Type", "Seal");
                String index = String.valueOf(Integer.parseInt(maxSignId) - 1);
                signature.addAttribute("BaseLoc", "Signs/Sign_" + index + "/Signature.xml");
                maxSignIdEle.setText(String.valueOf(Integer.parseInt(maxSignId) + 1));
                KGOfdUtils.writeToZip(this.zipFile, signaturesPath, signaturesDocument);
            }
            this.praseData(signDirPath);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        String data = "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";
        OfdElectronicSeal4KGSaveSignDataToLocal local = new OfdElectronicSeal4KGSaveSignDataToLocal(data, "E:\\relyman\\OFD_API\\\u56fd\u6cf0\u65b0\u70b9\\OFD\\OFD\u7b7e\u7ae0.ofd");
        try {
            local.saveData();
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }
}

