/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.executes;

import com.kgofd.commons.KGCommonUtils;
import com.kgofd.ofd.KGExecute;
import com.kgofd.ofd.utils.DocumentUtil;
import com.kgofd.ofd.utils.KGOfdUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class OfdPermission
extends KGExecute {
    private Object[] edit = new Object[]{"Edit", true};
    private Object[] annot = new Object[]{"Annot", true};
    private Object[] export = new Object[]{"Export", true};
    private Object[] signature = new Object[]{"Signature", true};
    private Object[] watermark = new Object[]{"Watermark", true};
    private Object[] printScreen = new Object[]{"PrintScreen", true};
    private Object[] printable = new Object[]{"Print", true};
    private int copics = -1;
    private Object[] validPeriod = new Object[]{"ValidPeriod", true};
    private String startDate = "2000-01-01";
    private String endDate = "2099-12-31";
    private String fontName = "\u5b8b\u4f53";
    private int maxID;
    private String fontID;

    public Object[] getEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit[1] = edit;
    }

    public Object[] getAnnot() {
        return this.annot;
    }

    public void setAnnot(boolean annot) {
        this.annot[1] = annot;
    }

    public Object[] getExport() {
        return this.export;
    }

    public void setExport(boolean export) {
        this.export[1] = export;
    }

    public Object[] getSignature() {
        return this.signature;
    }

    public void setSignature(boolean signature) {
        this.signature[1] = signature;
    }

    public Object[] getWatermark() {
        return this.watermark;
    }

    public void setWatermark(boolean watermark) {
        this.watermark[1] = watermark;
    }

    public Object[] getPrintScreen() {
        return this.printScreen;
    }

    public void setPrintScreen(boolean printScreen) {
        this.printScreen[1] = printScreen;
    }

    public Object[] getPrintable() {
        return this.printable;
    }

    public void setPrintable(boolean printable) {
        this.printable[1] = printable;
    }

    public int getCopics() {
        return this.copics;
    }

    public void setCopics(int copics) {
        this.printable[1] = true;
        this.copics = copics;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.validPeriod[1] = false;
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.validPeriod[1] = false;
        this.endDate = endDate;
    }

    public Object[] getValidPeriod() {
        return this.validPeriod;
    }

    public void setValidPeriod(boolean validPeriod) {
        this.validPeriod[1] = validPeriod;
    }

    @Override
    protected void execute(int[] pagens, ZipFile zipFile) throws DocumentException, IOException, ZipException, RuntimeException {
        this.checkdate();
        Document documentXmlDocument = this.getDocuemntXml(zipFile);
        Element maxUnitIDElement = (Element)documentXmlDocument.selectSingleNode("/ofd:Document/ofd:CommonData/ofd:MaxUnitID");
        this.maxID = Integer.parseInt(maxUnitIDElement.getText());
        Document publicResDocument = this.addPublicRes(zipFile, documentXmlDocument);
        ArrayList<Object[]> list = this.getPermission();
        if (list.size() != 0) {
            this.addPermissionNode(zipFile, documentXmlDocument);
            this.addPermission(zipFile, documentXmlDocument, list);
        }
        maxUnitIDElement.setText("" + this.maxID);
        KGOfdUtils.writeToZip(zipFile, "Doc_0/Document.xml", documentXmlDocument);
        KGOfdUtils.writeToZip(zipFile, "Doc_0/PublicRes.xml", publicResDocument);
    }

    private Document getDocuemntXml(ZipFile zipFile) throws ZipException, DocumentException {
        return KGOfdUtils.getDocument(zipFile, "Doc_0/Document.xml");
    }

    private Document addPublicRes(ZipFile zipFile, Document documentXmlDocument) throws ZipException, DocumentException {
        Node publicResNode = documentXmlDocument.selectSingleNode("/ofd:Document/ofd:CommonData/ofd:PublicRes");
        Element fontElement = null;
        Document publicResDocument = null;
        if (publicResNode == null) {
            Element commonDataElement = (Element)documentXmlDocument.selectSingleNode("/ofd:Document/ofd:CommonData");
            Element publicRes = commonDataElement.addElement("ofd:PublicRes");
            publicRes.addText("PublicRes.xml");
            publicResDocument = DocumentUtil.createDocument("ofd:Res");
            Element resElement = publicResDocument.getRootElement();
            resElement.addAttribute("BaseLoc", "Res");
            Element fontsElement = resElement.addElement("ofd:Fonts");
            fontElement = fontsElement.addElement("ofd:Font");
        } else {
            String publicResLoc = publicResNode.getText();
            publicResDocument = KGOfdUtils.getDocument(zipFile, publicResLoc = KGCommonUtils.converPath(publicResLoc, "Doc_0/Document.xml"));
            Element resElement = publicResDocument.getRootElement();
            Element fontsElement = (Element)resElement.selectSingleNode("ofd:Fonts");
            if (fontsElement == null) {
                fontsElement = resElement.addElement("ofd:Fonts");
                fontElement = fontsElement.addElement("ofd:Font");
            } else {
                Map<String, String> fontMap = DocumentUtil.getFontMap((Node)fontsElement);
                Set<Map.Entry<String, String>> entries = fontMap.entrySet();
                for (Map.Entry<String, String> entry : entries) {
                    if (!this.fontName.equals(entry.getValue())) continue;
                    this.fontID = entry.getKey();
                    break;
                }
                if (this.fontID == null) {
                    fontElement = fontsElement.addElement("ofd:Font");
                }
            }
        }
        if (fontElement != null) {
            this.fontID = "" + this.maxID++;
            fontElement.addAttribute("ID", this.fontID);
            fontElement.addAttribute("FontName", this.fontName);
        }
        return publicResDocument;
    }

    public ArrayList<Object[]> getPermission() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        list.add(this.edit);
        list.add(this.annot);
        list.add(this.export);
        list.add(this.signature);
        list.add(this.watermark);
        list.add(this.printScreen);
        list.add(this.printable);
        list.add(this.validPeriod);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object[] item = (Object[])iter.next();
            if (item[0].equals("Print") || !((Boolean)item[1]).booleanValue()) continue;
            iter.remove();
        }
        return list;
    }

    public void addPermissionNode(ZipFile zipFile, Document documentXmlDocument) throws ZipException, DocumentException {
        Node permissionNode = documentXmlDocument.selectSingleNode("/ofd:Document/ofd:Permissions");
        if (permissionNode == null) {
            Element documentElement = (Element)documentXmlDocument.selectSingleNode("/ofd:Document");
            documentElement.addElement("ofd:Permissions");
            KGOfdUtils.writeToZip(zipFile, "Doc_0/Document.xml", documentXmlDocument);
        }
    }

    public void addPermission(ZipFile zipFile, Document documentXmlDocument, ArrayList<Object[]> list) throws ZipException {
        Element permissionsElement = (Element)documentXmlDocument.selectSingleNode("/ofd:Document/ofd:Permissions");
        int i = 0;
        while (i < list.size()) {
            Object[] obj = list.get(i);
            Node childNode = documentXmlDocument.selectSingleNode("/ofd:Document/ofd:Permissions/ofd:" + obj[0]);
            if (childNode == null) {
                Element objElement;
                if (obj[0].equals("Print")) {
                    objElement = permissionsElement.addElement("ofd:" + obj[0]);
                    objElement.addAttribute("Printable", obj[1].toString());
                    objElement.addAttribute("Copics", String.valueOf(this.getCopics()));
                } else if (obj[0].equals("ValidPeriod")) {
                    objElement = permissionsElement.addElement("ofd:" + obj[0]);
                    if (this.getStartDate() != null && this.getStartDate() != "") {
                        objElement.addAttribute("StartDate", this.getStartDate());
                    }
                    if (this.getEndDate() != null && this.getEndDate() != "") {
                        objElement.addAttribute("EndDate", this.getEndDate());
                    }
                } else {
                    objElement = permissionsElement.addElement("ofd:" + obj[0]);
                    objElement.setText(obj[1].toString());
                }
            } else {
                Element childElement = (Element)documentXmlDocument.selectSingleNode("/ofd:Document/ofd:Permissions/ofd:" + obj[0]);
                if (obj[0].equals("Print")) {
                    Attribute copicsAttr = childElement.attribute("Copics");
                    Attribute printableAttr = childElement.attribute("Printable");
                    if (copicsAttr == null) {
                        childElement.addAttribute("Copics", String.valueOf(this.getCopics()));
                    } else {
                        copicsAttr.setValue(String.valueOf(this.getCopics()));
                    }
                    printableAttr.setValue(this.getPrintable()[1].toString());
                } else if (obj[0].equals("ValidPeriod")) {
                    Attribute startdateAttr = childElement.attribute("StartDate");
                    Attribute enddateAttr = childElement.attribute("EndDate");
                    if (startdateAttr == null) {
                        childElement.addAttribute("StartDate", this.getStartDate());
                    } else if (enddateAttr == null) {
                        childElement.addAttribute("EndDate", this.getEndDate());
                    } else {
                        startdateAttr.setValue(this.getStartDate());
                        enddateAttr.setValue(this.getEndDate());
                    }
                } else {
                    childNode.setText(obj[1].toString());
                }
            }
            ++i;
        }
        KGOfdUtils.writeToZip(zipFile, "Doc_0/Document.xml", documentXmlDocument);
    }

    public void checkdate() {
        long end;
        Matcher matcher1 = null;
        Matcher matcher2 = null;
        Pattern pattern1 = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
        matcher1 = pattern1.matcher(this.getStartDate());
        Pattern pattern2 = Pattern.compile("\\d{4}/\\d{2}/\\d{2}");
        matcher2 = pattern2.matcher(this.getStartDate());
        if (!matcher1.matches() && !matcher2.matches()) {
            throw new RuntimeException("\u65f6\u95f4\u9700\u6ee1\u8db3YYYY-MM-DD\u6216YYYY/MM/DD\u683c\u5f0f\uff01");
        }
        matcher1 = pattern1.matcher(this.getEndDate());
        matcher2 = pattern2.matcher(this.getEndDate());
        if (!matcher1.matches() && !matcher2.matches()) {
            throw new RuntimeException("\u65f6\u95f4\u9700\u6ee1\u8db3YYYY-MM-DD\u6216YYYY/MM/DD\u683c\u5f0f\uff01");
        }
        long start = Long.valueOf(this.getStartDate().replaceAll("[-\\s:\\s/]", ""));
        if (start > (end = Long.valueOf(this.getEndDate().replaceAll("[-\\s:\\s/]", "")).longValue())) {
            throw new RuntimeException("\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
        }
    }
}

