/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.executes;

import com.kgofd.kgcore.KGElectronicSeal;
import com.kgofd.kgcore.SealInformation;
import com.kgofd.kgcore.enmu.KGServerTypeEnum;
import com.kgofd.ofd.core.VerifyBeforeSign;
import com.kgofd.ofd.executes.OfdElectronicSeal;
import java.io.IOException;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1Integer;
import org.kg.bouncycastle.asn1.ASN1Sequence;

public class OfdElectronicSeal4KG
extends OfdElectronicSeal {
    public OfdElectronicSeal4KG() {
    }

    public OfdElectronicSeal4KG(String url, String keySN, String password, String signName) {
        this.kgElectronicSeal = new KGElectronicSeal(url, keySN, password, signName);
    }

    public OfdElectronicSeal4KG(String url, String keySN, String password, int index) {
        this.kgElectronicSeal = new KGElectronicSeal(url, keySN, password, index);
    }

    @Override
    public void before() throws IOException {
        SealInformation sealInfo = null;
        if (this.getSealMsg() == null) {
            sealInfo = this.getInter().getSeal();
            this.setSealMsg(sealInfo.getImgValue());
        }
        VerifyBeforeSign verifyBeforeSign = new VerifyBeforeSign(this.getInter());
        verifyBeforeSign.verifyCert();
        if (this.verifySeal) {
            verifyBeforeSign.verifySeal(this.getSealMsg());
        }
        ASN1InputStream asn1InputStream = new ASN1InputStream(this.getSealMsg());
        ASN1Sequence sequence = (ASN1Sequence)asn1InputStream.readObject();
        ASN1Sequence seq_0 = (ASN1Sequence)sequence.getObjectAt(0);
        ASN1Sequence seq_1 = (ASN1Sequence)seq_0.getObjectAt(3);
        float width = ((ASN1Integer)seq_1.getObjectAt(2)).getValue().floatValue();
        float height = ((ASN1Integer)seq_1.getObjectAt(3)).getValue().floatValue();
        asn1InputStream.close();
        this.setSealSize(width, height);
        if (sealInfo != null && this.logEntity != null) {
            this.logEntity.setLogType("00");
            this.logEntity.setLogSort("13");
            this.logEntity.setKeySN(sealInfo.getKeySN());
            this.logEntity.setSignSN(sealInfo.getSignSN());
        }
    }

    public void setType(KGServerTypeEnum type) {
        this.kgElectronicSeal.setType(type);
    }
}

