/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.executes;

import com.kgofd.commons.KGCommonUtils;
import com.kgofd.commons.KGDateUtils;
import com.kgofd.encrypt.KGBase64;
import com.kgofd.ofd.signinter.SignatureInter;
import com.kgofd.ofd.signinter.SignatureInterByKey;
import com.kgofd.ofd.utils.KGOfdUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HandleDocument {
    private String signatureDateTime;

    public String getSignDirPath(ZipFile zipFile, Document ofdDocument) throws ZipException, DocumentException {
        Element signaturesElement = this.getElement(ofdDocument, "/ofd:OFD/ofd:DocBody/ofd:Signatures");
        String signDirPath = null;
        if (signaturesElement == null) {
            signDirPath = "Doc_0/Signs/Sign_0";
        } else {
            String signaturesPath = signaturesElement.getTextTrim();
            Document signaturesDocument = KGOfdUtils.getDocument(zipFile, signaturesPath = KGCommonUtils.converPath(signaturesPath, ""));
            if (signaturesDocument == null) {
                signaturesElement.getParent().remove(signaturesElement);
                signDirPath = "Doc_0/Signs/Sign_0";
            } else {
                Element maxSignIdElement = this.getElement(signaturesDocument, "/ofd:Signatures/ofd:MaxSignId");
                String lastSignId = null;
                if (maxSignIdElement != null) {
                    String maxid = maxSignIdElement.getText();
                    lastSignId = String.valueOf(Integer.parseInt(maxid) - 1);
                } else {
                    List signaturesList = signaturesDocument.selectNodes("/ofd:Signatures/ofd:Signature");
                    Element signatureElement = (Element)signaturesList.get(signaturesList.size() - 1);
                    String baseLocValue = signatureElement.attributeValue("BaseLoc");
                    lastSignId = baseLocValue.substring(baseLocValue.lastIndexOf("/") - 1, baseLocValue.lastIndexOf("/"));
                }
                signDirPath = "Doc_0/Signs/Sign_" + (Integer.parseInt(lastSignId) + 1);
            }
        }
        return signDirPath;
    }

    public void addOrModifyModDateOfOfdXml(Document ofdDocument) {
        Element modDate = this.getElement(ofdDocument, "/ofd:OFD/ofd:DocBody/ofd:DocInfo/ofd:ModDate");
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = sdf.format(date);
        if (modDate == null) {
            Element docInfo = (Element)ofdDocument.selectSingleNode("/ofd:OFD/ofd:DocBody/ofd:DocInfo");
            modDate = docInfo.addElement("ofd:ModDate");
        }
        modDate.setText(dateString);
    }

    public Document createSignaturesNodeOfOfdXml(Document ofdDocument) throws ZipException {
        Element docBody = (Element)ofdDocument.selectSingleNode("/ofd:OFD/ofd:DocBody");
        Element signaturesElement = docBody.addElement("ofd:Signatures");
        signaturesElement.addText("/Doc_0/Signs/Signatures.xml");
        return ofdDocument;
    }

    public Document createSignaturesXml() throws ZipException {
        Document signaturesDocument = DocumentHelper.createDocument();
        signaturesDocument.setXMLEncoding("UTF-8");
        Element sigRoot = signaturesDocument.addElement("ofd:Signatures");
        sigRoot.addNamespace("ofd", "http://www.ofdspec.org/2016");
        Element maxSignIdEle = sigRoot.addElement("ofd:MaxSignId");
        maxSignIdEle.addText("1");
        return signaturesDocument;
    }

    public Document addSignatureNode(Document signaturesDocument, String signaturesPath, String maxSignId) {
        Element signaturesNode = this.getElement(signaturesDocument, "/ofd:Signatures");
        Element maxIdNode = this.getElement(signaturesDocument, "/ofd:Signatures/ofd:MaxSignId");
        Element signature = signaturesNode.addElement("ofd:Signature");
        int nextSignID = Integer.parseInt(maxSignId) + 1;
        signature.addAttribute("ID", String.valueOf(nextSignID));
        signature.addAttribute("Type", "Seal");
        String baseLog = "Signs/Sign_" + Integer.parseInt(maxSignId) + "/Signature.xml";
        if (signaturesPath.indexOf("Signs") != -1) {
            baseLog = "Sign_" + Integer.parseInt(maxSignId) + "/Signature.xml";
        }
        signature.addAttribute("BaseLoc", baseLog);
        maxIdNode.setText(String.valueOf(nextSignID));
        return signaturesDocument;
    }

    public Document createSignatureXml(ZipFile zipFile, SignatureInter inter, boolean isLockSign, boolean multiUserSign, boolean sealEslRequired, boolean isGMTTime, String signDirPath, Map<Integer, Element> pages, List<Object> hasFind, float width, float height) throws ZipException, IOException, DocumentException {
        Document signatureDocument = DocumentHelper.createDocument();
        signatureDocument.setXMLEncoding("UTF-8");
        Element signatureEle = signatureDocument.addElement("ofd:Signature");
        signatureEle.addNamespace("ofd", "http://www.ofdspec.org/2016");
        Element signedInfo = signatureEle.addElement("ofd:SignedInfo");
        Element provider = signedInfo.addElement("ofd:Provider");
        provider.addAttribute("ProviderName", inter.getProviderName());
        provider.addAttribute("Company", inter.getCompany());
        provider.addAttribute("Version", inter.getVersion());
        signedInfo.addElement("ofd:SignatureMethod").addText(inter.getSignMethod());
        String time = null;
        Date date = new Date();
        if (isGMTTime) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            time = simpleDateFormat.format(date);
        } else {
            time = KGDateUtils.format(date, "yyyyMMddHHmmss");
        }
        this.signatureDateTime = String.valueOf(time) + "Z";
        signedInfo.addElement("ofd:SignatureDateTime").addText(this.signatureDateTime);
        Element references = signedInfo.addElement("ofd:References").addAttribute("CheckMethod", inter.getDigestMethod());
        KGBase64 base64 = new KGBase64();
        List headers = zipFile.getFileHeaders();
        for (FileHeader fileHeader : headers) {
            String fileName = fileHeader.getFileName();
            if (fileName.endsWith("/") || !isLockSign && (fileName.contains("Signatures.xml") || fileName.contains("OFD.xml")) || multiUserSign && inter instanceof SignatureInterByKey && fileName.contains("SignedValue.dat")) continue;
            ZipInputStream zis = zipFile.getInputStream(fileHeader);
            Element reference = references.addElement("ofd:Reference").addAttribute("FileRef", "/" + fileName);
            reference.addElement("ofd:CheckValue").addText(base64.encode(inter.getDigestData(zis)));
        }
        if (pages == null) {
            pages = KGOfdUtils.converPage(zipFile);
        }
        int i = 0;
        while (i < hasFind.size()) {
            float[] arr = (float[])hasFind.get(i);
            int page = (int)arr[0];
            String pageRef = pages.get(page).attributeValue("ID");
            Element stampAnnot = signedInfo.addElement("ofd:StampAnnot");
            stampAnnot.addAttribute("PageRef", pageRef);
            stampAnnot.addAttribute("ID", String.valueOf(signDirPath.substring(signDirPath.length() - 1)) + 1);
            if (arr.length == 3 || (double)(arr[3] - arr[1]) <= 0.01) {
                stampAnnot.addAttribute("Boundary", String.valueOf(arr[1]) + " " + arr[2] + " " + width + " " + height);
            } else {
                stampAnnot.addAttribute("Boundary", String.valueOf(arr[1]) + " " + arr[2] + " " + width + " " + height);
                stampAnnot.addAttribute("Clip", String.valueOf(arr[3] - arr[1]) + " " + 0 + " " + (arr[3] - arr[1]) + " " + height);
            }
            ++i;
        }
        if (sealEslRequired) {
            Element seal = signedInfo.addElement("ofd:Seal");
            Element baseLoc = seal.addElement("ofd:BaseLoc");
            baseLoc.addText("/" + signDirPath + "/Seal.esl");
        }
        Element signedValue = signatureEle.addElement("ofd:SignedValue");
        signedValue.addText("/" + signDirPath + "/SignedValue.dat");
        return signatureDocument;
    }

    private float getPageWidth(ZipFile zipFile, Map<Integer, Element> pages, int i) throws ZipException, DocumentException {
        String baseLoc = pages.get(i).attributeValue("BaseLoc");
        Document contentDoc = KGOfdUtils.getDocument(zipFile, baseLoc = KGCommonUtils.converPath(baseLoc, "Doc_0/"));
        Element physicalBox = (Element)contentDoc.selectSingleNode("/ofd:Page/ofd:Area/ofd:PhysicalBox");
        if (physicalBox == null) {
            Document documentDoc = KGOfdUtils.getDocument(zipFile, "Doc_0/Document.xml");
            physicalBox = (Element)documentDoc.selectSingleNode("/ofd:Document/ofd:CommonData/ofd:PageArea/ofd:PhysicalBox");
        }
        String pageSize = physicalBox.getTextTrim();
        String[] s = pageSize.split(" ");
        return Float.parseFloat(s[2]);
    }

    public Element getElement(Document document, String nodePath) {
        return (Element)document.selectSingleNode(nodePath);
    }

    public String getSignatureDateTime() {
        return this.signatureDateTime;
    }
}

