/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.executes;

import com.kgofd.commons.KGCommonUtils;
import com.kgofd.ofd.KGExecute;
import com.kgofd.ofd.utils.KGOfdUtils;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class DeleteSignature
extends KGExecute {
    private boolean deleteLastOneSeal;

    public void setDeleteLastOneSeal(boolean deleteLastOneSeal) {
        this.deleteLastOneSeal = deleteLastOneSeal;
    }

    @Override
    protected void execute(int[] pagens, ZipFile zipFile) throws DocumentException, ZipException {
        KGOfdUtils ofdUtils = new KGOfdUtils();
        Document OFDXMLDocument = KGOfdUtils.getDocument(zipFile, "OFD.xml");
        Element signaturesElement = (Element)OFDXMLDocument.selectSingleNode("/ofd:OFD/ofd:DocBody/ofd:Signatures");
        String signaturesPath = KGCommonUtils.converPath(signaturesElement.getTextTrim(), "");
        if (this.deleteLastOneSeal) {
            Document signaturesDocument = KGOfdUtils.getDocument(zipFile, signaturesPath);
            List signatures = signaturesDocument.selectNodes("/ofd:Signatures/ofd:Signature");
            for (Element signatureNode : signatures) {
                if (signatureNode.attributeValue("Type") == null || "Sign".equals(signatureNode.attributeValue("Type"))) continue;
                Element signatureElement = (Element)signatures.get(signatures.size() - 1);
                String path = "Doc_0/";
                if (signaturesPath.indexOf("Signs") != -1) {
                    path = "Doc_0/Signs/";
                }
                String baseLoc = KGCommonUtils.converPath(signatureElement.attributeValue("BaseLoc"), path);
                baseLoc = baseLoc.substring(0, baseLoc.lastIndexOf("/"));
                this.deleteFileHeader(zipFile, String.valueOf(baseLoc) + "/Seal.esl");
                this.deleteFileHeader(zipFile, String.valueOf(baseLoc) + "/Signature.xml");
                this.deleteFileHeader(zipFile, String.valueOf(baseLoc) + "/SignedValue.dat");
                if (signatures.size() == 1) {
                    this.deleteFileHeader(zipFile, signaturesPath);
                    signaturesElement.getParent().remove(signaturesElement);
                    KGOfdUtils.writeToZip(zipFile, "OFD.xml", OFDXMLDocument);
                } else {
                    signatureElement.getParent().remove(signatureElement);
                    KGOfdUtils.writeToZip(zipFile, signaturesPath, signaturesDocument);
                }
                break;
            }
        } else {
            if (signaturesElement != null) {
                signaturesElement.getParent().remove(signaturesElement);
            }
            KGOfdUtils.writeToZip(zipFile, "OFD.xml", OFDXMLDocument);
            List headers = zipFile.getFileHeaders();
            String fileName = null;
            int i = 0;
            while (i < headers.size()) {
                fileName = ((FileHeader)headers.get(i)).getFileName();
                if (fileName.endsWith("Signatures.xml") || fileName.endsWith("Seal.esl") || fileName.endsWith("Signature.xml") || fileName.endsWith("SignedValue.dat")) {
                    this.deleteFileHeader(zipFile, fileName);
                    --i;
                }
                ++i;
            }
        }
    }

    private void deleteFileHeader(ZipFile zipFile, String fileHeader) throws ZipException {
        FileHeader header = zipFile.getFileHeader(fileHeader);
        if (header != null) {
            zipFile.removeFile(header);
        }
    }
}

