/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.executes;

import com.kgofd.commons.KGCommonUtils;
import com.kgofd.encrypt.KGBase64;
import com.kgofd.encrypt.SM3withZ;
import com.kgofd.kgcore.KGElectronicSeal;
import com.kgofd.kgcore.KGHttpUtils;
import com.kgofd.kgcore.LogEntity;
import com.kgofd.kgcore.SaveLogListener;
import com.kgofd.ofd.KGExecute;
import com.kgofd.ofd.core.KGTextFinder;
import com.kgofd.ofd.enmu.KGPoistionEnum;
import com.kgofd.ofd.enmu.KGQfzModeEnum;
import com.kgofd.ofd.enmu.XYType;
import com.kgofd.ofd.executes.HandleDocument;
import com.kgofd.ofd.executes.entity.Position;
import com.kgofd.ofd.executes.entity.QfzSealData;
import com.kgofd.ofd.seal.Seal;
import com.kgofd.ofd.seal.SealUtil;
import com.kgofd.ofd.signinter.SignatureInter;
import com.kgofd.ofd.signinter.SignatureInterByGB;
import com.kgofd.ofd.signinter.SignatureInterByKey;
import com.kgofd.ofd.utils.KGOfdUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public abstract class AbstractSign
extends KGExecute {
    private SignatureInter inter;
    public KGElectronicSeal kgElectronicSeal;
    protected KGPoistionEnum position = KGPoistionEnum.XY;
    private byte[] sealData;
    private String signDirPath;
    private byte[] toSignDataByte;
    private float x;
    private float y;
    private XYType xyType = XYType.TOP_LEFT;
    private boolean centerxy;
    private String semanticTree;
    private String text;
    private boolean onceFindReturn;
    private float offsetX;
    private float offsetY;
    private List<Object> hasFind = new ArrayList<Object>();
    private boolean isLockSign;
    protected boolean verifySeal = true;
    private boolean sealEslRequired = true;
    private boolean isGMTTime = true;
    private boolean enableUpdateModDate = true;
    private int number;
    private KGQfzModeEnum qfzMode;
    private int yDistanceOrigin;
    private Map<Integer, Integer> sealMap = null;
    private int step = 1;
    private int startPage = 1;
    private int nextPage = 1;
    private int increment = 1;
    private int startX = 0;
    private int clipx;
    private boolean clip = false;
    private Map<Integer, List<QfzSealData>> qfzSealMap;
    private boolean bilateralOff = false;
    private float width;
    private float height;
    private Map<Integer, Element> pages;
    private List<SaveLogListener> saveLogListeners = new ArrayList<SaveLogListener>();
    private ZipFile zipFile;
    protected LogEntity logEntity;

    public void setEnableUpdateModDate(boolean enableUpdateModDate) {
        this.enableUpdateModDate = enableUpdateModDate;
    }

    public void setGMTTime(boolean isGMTTime) {
        this.isGMTTime = isGMTTime;
    }

    public void setSealEslRequired(boolean sealEslRequired) {
        this.sealEslRequired = sealEslRequired;
    }

    public void setLockSign(boolean isLockSign) {
        this.isLockSign = isLockSign;
    }

    public void setVerifySeal(boolean verifySeal) {
        this.verifySeal = verifySeal;
    }

    public void setInfomation(SignatureInter inter) {
        this.inter = inter;
    }

    public byte[] getToSignDataByte() {
        return this.toSignDataByte;
    }

    public void setSealSize(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public float getSealWidth() {
        return this.width;
    }

    public float getSealHeight() {
        return this.height;
    }

    public void setSealMsg(byte[] sealData) {
        this.sealData = sealData;
    }

    public byte[] getSealMsg() {
        return this.sealData;
    }

    public SignatureInter getInter() {
        return this.inter;
    }

    public String getSignDirPath() {
        return this.signDirPath;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public List<Object> getHasFind() {
        return this.hasFind;
    }

    public Map<Integer, List<QfzSealData>> getQfzSealMap() {
        return this.qfzSealMap;
    }

    public void setQfzSealMap(Map<Integer, List<QfzSealData>> qfzSealMap) {
        this.qfzSealMap = qfzSealMap;
    }

    public void setStartPage(int startPage) {
        if (startPage < 1) {
            throw new IllegalArgumentException("startPage \u4e0d\u80fd\u5c0f\u4e8e1.");
        }
        this.nextPage = this.startPage = startPage;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(int nextPage) {
        this.nextPage = nextPage;
    }

    public void setCenterXYpx(XYType xyType, float x, float y) {
        this.centerxy = true;
        this.xyType = xyType;
        this.x = x / this.px2mm();
        this.y = y / this.px2mm();
    }

    public void setXY(float x, float y) {
        this.position = KGPoistionEnum.XY;
        this.x = x;
        this.y = y;
    }

    public void setXY(XYType xyType, float x, float y) {
        this.xyType = xyType;
        this.setXY(x, y);
    }

    public void setTree(String semanticTree) {
        this.setTree(semanticTree, false);
    }

    public void setTree(String semanticTree, boolean treeOnceFindReturn) {
        this.position = KGPoistionEnum.TREE;
        this.semanticTree = semanticTree;
        this.onceFindReturn = treeOnceFindReturn;
    }

    public void setText(String text) {
        this.setText(text, false);
    }

    public void setText(String text, boolean textOnceFindReturn) {
        this.position = KGPoistionEnum.TEXT;
        this.text = text;
        this.onceFindReturn = textOnceFindReturn;
    }

    public void setTextOffset(float offsetX, float offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public void qfz(int number, KGQfzModeEnum qfzMode, int yDistanceOrigin) {
        this.position = KGPoistionEnum.QFZ;
        this.number = number;
        this.qfzMode = qfzMode;
        this.yDistanceOrigin = yDistanceOrigin;
    }

    public void qfz(Map<Integer, List<QfzSealData>> qfzSealMap) {
        this.position = KGPoistionEnum.QFZ;
        this.qfzSealMap = qfzSealMap;
    }

    public void qfzBilateralOff(int yDistanceOrigin) {
        this.bilateralOff = true;
        this.qfz(-1, KGQfzModeEnum.ALLPAGE, yDistanceOrigin);
    }

    @Override
    public void execute(int[] pagens, ZipFile zipFile) throws DocumentException, IOException, ZipException {
        this.zipFile = zipFile;
        int pageSize = KGOfdUtils.getTotalPage(zipFile);
        if (pagens[pagens.length - 1] > pageSize || pagens[0] < 0) {
            throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u9875\u7801\u53c2\u6570\uff0c\u8bf7\u8bbe\u7f6e1~" + pageSize + "\u4e4b\u95f4\u7684\u9875\u7801\uff01");
        }
        if (this.position == KGPoistionEnum.XY) {
            this.xySign(pagens);
        } else if (this.position == KGPoistionEnum.TREE) {
            this.treeSign(pagens);
        } else if (this.position == KGPoistionEnum.TEXT) {
            this.textSign(pagens);
        } else if (this.position == KGPoistionEnum.QFZ) {
            this.qfzSign(pagens);
        } else {
            throw new RuntimeException("not suport this positon: " + this.position.name());
        }
    }

    @Override
    public void after() throws DocumentException {
        if (this.position == KGPoistionEnum.TREE && this.hasFind.size() == 0) {
            throw new DocumentException("Not find the semanticTree \uff1a" + this.semanticTree);
        }
        if (this.position == KGPoistionEnum.TEXT && this.hasFind.size() == 0) {
            throw new DocumentException("Not find the Text \uff1a" + this.text);
        }
        this.saveLog();
    }

    private void xySign(int[] pagens) throws DocumentException, IOException, ZipException {
        int i = 0;
        while (i < pagens.length) {
            if (pagens[i] >= this.startPage) {
                float x = this.x;
                float y = this.y;
                float[] size = KGOfdUtils.getPageSize(this.zipFile, pagens[i]);
                if (this.xyType == XYType.UPPER_RIGHT) {
                    x = size[0] - this.x;
                } else if (this.xyType == XYType.LOWER_LEFT) {
                    y = size[1] - this.y;
                } else if (this.xyType == XYType.LOWER_RIGHT) {
                    x = size[0] - this.x;
                    y = size[1] - this.y;
                }
                if (this.centerxy) {
                    x -= this.width / 2.0f;
                    y -= this.height / 2.0f;
                }
                float[] info = new float[]{pagens[i], x, y};
                this.hasFind.add(info);
            }
            ++i;
        }
        this.sign(pagens, this.hasFind);
    }

    private void treeSign(int[] pagens) throws DocumentException, IOException, ZipException {
        Document customTagXml;
        String documentPath;
        KGOfdUtils ofdUtils;
        block13: {
            SAXReader reader = new SAXReader();
            ofdUtils = new KGOfdUtils();
            Document ofdDocument = KGOfdUtils.getDocument(this.zipFile, "OFD.xml");
            if (this.pages == null) {
                this.pages = KGOfdUtils.converPage(this.zipFile);
            }
            Element documentEle = (Element)ofdDocument.selectSingleNode("/ofd:OFD/ofd:DocBody/ofd:DocRoot");
            documentPath = documentEle.getTextTrim();
            Document documentXml = KGOfdUtils.getDocument(this.zipFile, documentPath = KGCommonUtils.converPath(documentPath, "Doc_0/"));
            Element customTagsEle = (Element)documentXml.selectSingleNode("/ofd:Document/ofd:CustomTags");
            if (customTagsEle == null) {
                throw new RuntimeException("\u6587\u6863\u4e2d\u4e0d\u5b58\u5728\u8bed\u4e49\u6811");
            }
            String customTagsPath = customTagsEle.getTextTrim();
            customTagsPath = KGCommonUtils.converPath(customTagsPath, "Doc_0/");
            Document customTagsXml = KGOfdUtils.getDocument(this.zipFile, customTagsPath);
            Element fileLocEle = (Element)customTagsXml.selectSingleNode("/ofd:CustomTags/ofd:CustomTag/ofd:FileLoc");
            String customTagPath = fileLocEle.getTextTrim();
            customTagPath = KGCommonUtils.converPath(customTagPath, "Doc_0/");
            customTagXml = null;
            InputStream bis = null;
            try {
                try {
                    customTagXml = KGOfdUtils.getDocument(this.zipFile, customTagPath);
                }
                catch (DocumentException e1) {
                    bis = ofdUtils.insertXmlnsNode(this.zipFile, customTagPath);
                    customTagXml = reader.read(bis);
                    AbstractSign.close(bis);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                AbstractSign.close(bis);
                throw throwable;
            }
            AbstractSign.close(bis);
        }
        List<Element> semanticTrees = ofdUtils.getTreeNode(customTagXml, this.semanticTree);
        String typeID = customTagXml.getRootElement().getNamespacePrefix();
        String ObjectRef = null;
        if (typeID != null) {
            ObjectRef = String.valueOf(typeID) + ":ObjectRef";
        }
        int j = 0;
        while (j < pagens.length) {
            if (pagens[j] >= this.startPage) {
                String pagenID = this.pages.get(pagens[j]).attributeValue("ID");
                for (Element e : semanticTrees) {
                    String PageRef;
                    List objectRefEles = e.selectNodes(ObjectRef);
                    if (objectRefEles.size() == 1) {
                        PageRef = ((Element)objectRefEles.get(0)).attribute("PageRef").getValue();
                        if (!pagenID.equals(PageRef)) continue;
                        String boundary = this.getBoundary((Element)objectRefEles.get(0), PageRef, documentPath);
                        String[] str = boundary.split(" ");
                        float x = Float.parseFloat(str[0].trim());
                        float y = Float.parseFloat(str[1].trim());
                        float w = Float.parseFloat(str[2].trim());
                        float h = Float.parseFloat(str[3].trim());
                        this.x = x + w / 2.0f - this.width / 2.0f;
                        this.y = y + h / 2.0f - this.height / 2.0f;
                        float[] info = new float[]{pagens[j], this.x, this.y};
                        this.hasFind.add(info);
                        continue;
                    }
                    PageRef = ((Element)objectRefEles.get(0)).attribute("PageRef").getValue();
                    if (!pagenID.equals(PageRef)) continue;
                    String startBoundary = this.getBoundary((Element)objectRefEles.get(0), PageRef, documentPath);
                    String endBoundary = this.getBoundary((Element)objectRefEles.get(objectRefEles.size() - 1), PageRef, documentPath);
                    String[] sb = startBoundary.split(" ");
                    String[] nb = endBoundary.split(" ");
                    this.x = Float.parseFloat(sb[0]) + (Float.parseFloat(nb[0]) + Float.parseFloat(nb[2]) - Float.parseFloat(sb[0])) / 2.0f - this.width / 2.0f;
                    this.y = Float.parseFloat(sb[1]) + (Float.parseFloat(nb[1]) + Float.parseFloat(nb[3]) - Float.parseFloat(sb[1])) / 2.0f - this.height / 2.0f;
                    float[] info = new float[]{pagens[j], this.x, this.y};
                    this.hasFind.add(info);
                }
            }
            if (this.onceFindReturn) break;
            ++j;
        }
        if (this.hasFind != null) {
            this.sign(pagens, this.hasFind);
        }
    }

    public String getBoundary(Element objectRefEle, String pageRef, String documentPath) throws DocumentException, ZipException {
        String objectRefID = objectRefEle.getTextTrim();
        if (this.pages == null) {
            this.pages = KGOfdUtils.converPage(this.zipFile);
        }
        String boundary = null;
        int j = 0;
        while (j < this.pages.size()) {
            Element pageEle = this.pages.get(j + 1);
            if (pageEle.attribute("ID").getValue().equals(pageRef)) {
                String baseLoc = pageEle.attribute("BaseLoc").getValue();
                baseLoc = KGCommonUtils.converPath(baseLoc, documentPath);
                Document contentXml = KGOfdUtils.getDocument(this.zipFile, baseLoc);
                List layerNodes = contentXml.selectNodes("/ofd:Page/ofd:Content/ofd:Layer/ofd:TextObject");
                int k = 0;
                while (k < layerNodes.size()) {
                    Element textObjectEle = (Element)layerNodes.get(k);
                    if (textObjectEle.attribute("ID").getValue().equals(objectRefID)) {
                        boundary = textObjectEle.attributeValue("Boundary");
                    }
                    ++k;
                }
            }
            ++j;
        }
        return boundary;
    }

    private void qfzSign(int[] pagens) throws DocumentException, IOException, ZipException {
        if (this.pages == null) {
            this.pages = KGOfdUtils.converPage(this.zipFile);
        }
        if (this.qfzSealMap != null) {
            float cutWidth = 0.0f;
            for (Map.Entry<Integer, List<QfzSealData>> map : this.qfzSealMap.entrySet()) {
                List<QfzSealData> list = map.getValue();
                int i = 0;
                while (i < list.size()) {
                    QfzSealData qfzSealData = list.get(i);
                    this.height = qfzSealData.getHeight();
                    float pageWidth = this.getPageWidth(map.getKey());
                    float[] info = new float[]{map.getKey().intValue(), qfzSealData.getLeft() - cutWidth, qfzSealData.getTop(), pageWidth - qfzSealData.getWidth()};
                    cutWidth = cutWidth + qfzSealData.getWidth() >= this.width ? 0.0f : cutWidth + qfzSealData.getWidth();
                    this.hasFind.add(info);
                    ++i;
                }
            }
            this.sign(pagens, this.hasFind);
            return;
        }
        int i = 0;
        while (i < pagens.length) {
            if (pagens[i] >= this.startPage) {
                int pageNumber = KGOfdUtils.getTotalPage(this.zipFile) - this.startPage + 1;
                if (pageNumber < 2) {
                    throw new IllegalArgumentException("\u9a91\u7f1d\u7ae0\uff0cOFD\u6587\u6863\u81f3\u5c11\u9700\u8981\u4e24\u9875\u76d6\u7ae0\u9875\u3002\u5f53\u524d\u76d6\u7ae0\u9875\u6570\uff1a" + pageNumber);
                }
                float pageWidth = this.getPageWidth(pagens[i]);
                if (this.sealMap == null && !this.bilateralOff) {
                    if (this.qfzMode != KGQfzModeEnum.ALLPAGE) {
                        this.step = 2;
                        if (this.qfzMode == KGQfzModeEnum.ODDPAGE) {
                            int numb = pageNumber % 2;
                            pageNumber = numb == 1 ? pageNumber / 2 + 1 : pageNumber / 2;
                        } else {
                            pageNumber /= 2;
                            ++this.nextPage;
                        }
                    }
                    this.sealMap = this.getPerPagePercent(pageNumber, (int)this.width, this.number);
                }
                if (pagens[i] == this.nextPage) {
                    float[] info;
                    this.y = this.yDistanceOrigin;
                    if (!this.bilateralOff) {
                        int cutImgWidth = this.sealMap.get(this.increment);
                        this.clip = false;
                        if (this.startX != 0) {
                            this.clip = true;
                            this.clipx = (int)(pageWidth - (float)cutImgWidth);
                        }
                        this.startX += cutImgWidth;
                        this.x = pageWidth - (float)this.startX;
                        if (this.clip) {
                            info = new float[]{pagens[i], this.x, this.y, this.clipx};
                            this.hasFind.add(info);
                        } else {
                            info = new float[]{pagens[i], this.x, this.y};
                            this.hasFind.add(info);
                        }
                        if ((float)this.startX >= this.width) {
                            this.startX = 0;
                        }
                        ++this.increment;
                    } else {
                        int leftWidth = (int)this.width / 2;
                        if (pagens[i] == 1) {
                            this.x = pageWidth - (float)leftWidth;
                            info = new float[]{pagens[i], this.x, this.y};
                            this.hasFind.add(info);
                        } else if (pagens[i] == pageNumber) {
                            this.x = -leftWidth;
                            info = new float[]{pagens[i], this.x, this.y};
                            this.hasFind.add(info);
                        } else {
                            if (pagens[i] != this.startPage) {
                                this.x = -leftWidth;
                                info = new float[]{pagens[i], this.x, this.y};
                                this.hasFind.add(info);
                            }
                            this.x = pageWidth - (float)leftWidth;
                            info = new float[]{pagens[i], this.x, this.y};
                            this.hasFind.add(info);
                        }
                    }
                    this.nextPage += this.step;
                }
            }
            ++i;
        }
        if (this.hasFind != null) {
            this.sign(pagens, this.hasFind);
            this.hasFind = null;
        }
    }

    private float getPageWidth(int i) throws ZipException, DocumentException {
        String baseLoc = this.pages.get(i).attributeValue("BaseLoc");
        Document contentDoc = KGOfdUtils.getDocument(this.zipFile, baseLoc = KGCommonUtils.converPath(baseLoc, "Doc_0/"));
        Element physicalBox = (Element)contentDoc.selectSingleNode("/ofd:Page/ofd:Area/ofd:PhysicalBox");
        if (physicalBox == null) {
            Document documentDoc = KGOfdUtils.getDocument(this.zipFile, "Doc_0/Document.xml");
            physicalBox = (Element)documentDoc.selectSingleNode("/ofd:Document/ofd:CommonData/ofd:PageArea/ofd:PhysicalBox");
        }
        String pageSize = physicalBox.getTextTrim();
        String[] s = pageSize.split(" ");
        return Float.parseFloat(s[2]);
    }

    private void textSign(int[] pagens) throws DocumentException, IOException, ZipException {
        Map<Integer, Element> pages = KGOfdUtils.converPage(this.zipFile);
        int k = 0;
        while (k < pagens.length) {
            if (pagens[k] >= this.startPage) {
                Element pageEle = pages.get(pagens[k]);
                String baseLoc = pageEle.attributeValue("BaseLoc");
                baseLoc = KGCommonUtils.converPath(baseLoc, "Doc_0/");
                Document contentDoc = KGOfdUtils.getDocument(this.zipFile, baseLoc);
                KGTextFinder finder = new KGTextFinder(contentDoc);
                finder.setSeal((int)this.width, (int)this.height);
                finder.parseContentDoc();
                List<Position> positions = finder.TextFinder(this.text, this.onceFindReturn);
                for (Position position : positions) {
                    this.x = position.getX();
                    this.y = position.getY();
                    this.x += this.offsetX;
                    this.y += this.offsetY;
                    float[] info = new float[]{pagens[k], this.x, this.y};
                    this.hasFind.add(info);
                    if (this.onceFindReturn) break;
                }
            }
            ++k;
        }
        if (this.hasFind != null) {
            this.sign(pagens, this.hasFind);
        }
    }

    public String getToSignData(int[] pagens, List<Object> hasFind) throws DocumentException, IOException, ZipException {
        String signaturesPath;
        Document signaturesDocument;
        HandleDocument handleDocument = new HandleDocument();
        Document ofdDocument = KGOfdUtils.getDocument(this.zipFile, "OFD.xml");
        this.signDirPath = handleDocument.getSignDirPath(this.zipFile, ofdDocument);
        String maxSignId = this.signDirPath.substring(this.signDirPath.lastIndexOf("_") + 1);
        boolean modifyOfdXml = false;
        if ("0".equals(maxSignId)) {
            modifyOfdXml = true;
            ofdDocument = handleDocument.createSignaturesNodeOfOfdXml(ofdDocument);
            Document signaturesDocument2 = handleDocument.createSignaturesXml();
            KGOfdUtils.writeToZip(this.zipFile, "Doc_0/Signs/Signatures.xml", signaturesDocument2);
        }
        if (this.enableUpdateModDate) {
            modifyOfdXml = true;
            handleDocument.addOrModifyModDateOfOfdXml(ofdDocument);
        }
        if (modifyOfdXml) {
            KGOfdUtils.writeToZip(this.zipFile, "OFD.xml", ofdDocument);
        }
        if ((signaturesDocument = KGOfdUtils.getDocument(this.zipFile, signaturesPath = "Doc_0/Signs/Signatures.xml")) == null) {
            signaturesPath = "Doc_0/Signatures.xml";
            signaturesDocument = KGOfdUtils.getDocument(this.zipFile, signaturesPath);
        }
        signaturesDocument = handleDocument.addSignatureNode(signaturesDocument, signaturesPath, maxSignId);
        KGOfdUtils.writeToZip(this.zipFile, signaturesPath, signaturesDocument);
        if (this.sealEslRequired) {
            KGOfdUtils.writeToZip(this.zipFile, String.valueOf(this.signDirPath) + "/Seal.esl", this.sealData);
        }
        Document signatureDocument = handleDocument.createSignatureXml(this.zipFile, this.inter, this.isLockSign, this.multiUserSign, this.sealEslRequired, this.isGMTTime, this.signDirPath, this.pages, hasFind, this.width, this.height);
        KGOfdUtils.writeToZip(this.zipFile, String.valueOf(this.signDirPath) + "/Signature.xml", signatureDocument);
        Seal seal = SealUtil.getSeal(this.sealData);
        String sealtype = seal.getSealType();
        SignatureInter.localversion.set(seal.getHeaderVer());
        if (this.inter instanceof SignatureInterByKey) {
            this.inter = (SignatureInterByKey)this.inter;
            ((SignatureInterByKey)this.inter).setSealType(sealtype);
        }
        SignatureInter.local.set(this.sealData);
        this.toSignDataByte = this.inter.getToSignData(this.signDirPath, this.zipFile, handleDocument.getSignatureDateTime());
        KGOfdUtils.writeToZip(this.zipFile, String.valueOf(this.signDirPath) + "/SignedValue.dat", this.toSignDataByte);
        if (!(this.inter instanceof SignatureInterByKey) || this.inter instanceof SignatureInterByGB) {
            return null;
        }
        KGBase64 base64 = new KGBase64();
        String keyToSignData = null;
        if (this.inter.getDigestMethod().equals("1.2.156.10197.1.401")) {
            byte[] md = SM3withZ.sm3WithZ(this.inter.getCer(), this.toSignDataByte);
            keyToSignData = base64.encode(md);
        } else if (this.inter.getDigestMethod().equals("SHA1")) {
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            byte[] hash_data = messageDigest.digest(this.toSignDataByte);
            byte[] byArray = new byte[15];
            byArray[0] = 48;
            byArray[1] = 33;
            byArray[2] = 48;
            byArray[3] = 9;
            byArray[4] = 6;
            byArray[5] = 5;
            byArray[6] = 43;
            byArray[7] = 14;
            byArray[8] = 3;
            byArray[9] = 2;
            byArray[10] = 26;
            byArray[11] = 5;
            byArray[13] = 4;
            byArray[14] = 20;
            byte[] prefix = byArray;
            byte[] newHashData = new byte[hash_data.length + prefix.length];
            System.arraycopy(prefix, 0, newHashData, 0, prefix.length);
            System.arraycopy(hash_data, 0, newHashData, prefix.length, hash_data.length);
            keyToSignData = base64.encode(newHashData);
        }
        return keyToSignData;
    }

    public void addSignData(byte[] toSignData) throws IOException, ZipException {
        byte[] signData = this.inter.getSignData(toSignData);
        byte[] datFileData = this.inter.createDatFile(toSignData, signData, this.signDirPath);
        KGOfdUtils.writeToZip(this.zipFile, String.valueOf(this.signDirPath) + "/SignedValue.dat", datFileData);
    }

    protected abstract void sign(int[] var1, List<Object> var2) throws DocumentException, IOException, ZipException;

    protected Map<Integer, Integer> getPerPagePercent(int pagesOfNumber, int image_width, int numb) {
        if (pagesOfNumber < 2) {
            throw new IllegalArgumentException("\u9a91\u7f1d\u7ae0\uff0cOFD\u6587\u6863\u81f3\u5c11\u9700\u8981\u6709\u4e24\u4e2a\u76d6\u7ae0\u9875\u3002\u5f53\u524d\u76d6\u7ae0\u9875\u6570\uff1a" + pagesOfNumber);
        }
        if (numb < 2 || numb > 32) {
            throw new IllegalArgumentException("\u81f3\u5c112\u9875\u3001\u6700\u591a32\u9875\u5e73\u5747\u5206\u4e00\u4e2a\u7ae0.");
        }
        int cow = pagesOfNumber / numb;
        int mod = pagesOfNumber % numb;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(pagesOfNumber);
        int i = 1;
        int[] row_width = this.getRowWidth(image_width, numb);
        if (mod == 0) {
            i = 1;
            while (i <= pagesOfNumber) {
                map.put(i, row_width[i % numb]);
                ++i;
            }
        } else if (mod == 1) {
            i = 1;
            while (i <= (cow - 1) * numb) {
                map.put(i, row_width[i % numb]);
                ++i;
            }
            row_width = this.getRowWidth(image_width, numb + 1);
            int k = 1;
            while (k <= row_width.length && i <= pagesOfNumber) {
                map.put(i++, row_width[k % row_width.length]);
                ++k;
            }
        } else {
            i = 1;
            while (i <= cow * numb) {
                map.put(i, row_width[i % numb]);
                ++i;
            }
            row_width = this.getRowWidth(image_width, mod);
            int k = 1;
            while (k <= row_width.length && i <= pagesOfNumber) {
                map.put(i++, row_width[k % row_width.length]);
                ++k;
            }
        }
        return map;
    }

    private int[] getRowWidth(int width, int rowNumber) {
        int per_page_width = width / rowNumber;
        int mod_width = width % rowNumber;
        int[] row_width = new int[rowNumber];
        Arrays.fill(row_width, per_page_width);
        if (mod_width != 0) {
            row_width[0] = row_width[0] + 1;
            int i = rowNumber - 1;
            int j = mod_width - 1;
            while (j > 0) {
                int n = i--;
                row_width[n] = row_width[n] + 1;
                --j;
            }
        }
        return row_width;
    }

    private float px2mm() {
        return 2.8346457f;
    }

    public void forceValidatePwd() {
        if (this.kgElectronicSeal != null) {
            this.kgElectronicSeal.forceValidatePwd();
        }
    }

    protected void saveLog() {
        if (this.saveLogListeners.size() > 0 && this.logEntity != null) {
            for (SaveLogListener listener : this.saveLogListeners) {
                listener.saveLog(this.logEntity);
            }
            this.logEntity = null;
        } else if (this.kgElectronicSeal != null && this.kgElectronicSeal.isSealFromServer() && this.logEntity != null) {
            KGHttpUtils http = new KGHttpUtils();
            http.saveLog(this.kgElectronicSeal.getUrl(), this.logEntity);
            if (this.position == KGPoistionEnum.QFZ) {
                this.logEntity = null;
            }
        }
    }

    public void saveLog(String documentID, String documentName, String logMemo, String extparam1, String extparam2) {
        this.logEntity = new LogEntity();
        this.logEntity.setDocumentID(documentID);
        this.logEntity.setDocumentName(documentName);
        this.logEntity.setLogMemo(logMemo);
        this.logEntity.setExtparam1(extparam1);
        this.logEntity.setExtparam2(extparam2);
    }

    public void addSaveLogListener(SaveLogListener listener) {
        this.saveLogListeners.add(listener);
    }

    public void removeSaveLogListener(SaveLogListener listener) {
        this.saveLogListeners.remove(listener);
    }

    public static void close(Closeable ... closeableList) {
        try {
            Closeable[] closeableArray = closeableList;
            int n = closeableList.length;
            int n2 = 0;
            while (n2 < n) {
                Closeable closeable = closeableArray[n2];
                if (closeable != null) {
                    closeable.close();
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

