/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.core;

import com.kgofd.ofd.core.TbsSign;
import java.io.IOException;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1EncodableVector;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.DERBitString;
import org.kg.bouncycastle.asn1.DERGeneralizedTime;
import org.kg.bouncycastle.asn1.DERIA5String;
import org.kg.bouncycastle.asn1.DERInteger;
import org.kg.bouncycastle.asn1.DERObjectIdentifier;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DERSequence;
import org.kg.bouncycastle.asn1.DLSequence;

public class SesSignature {
    private static final String GM_SIGNATURE_ALGORITHM = "1.2.156.10197.1.501";
    private TbsSign toSign;
    private byte[] cert;
    private String signatureAlgID;
    private byte[] signature;
    private String timeStamp;

    public byte[] buildGbASN1() {
        ASN1EncodableVector ses_signature = new ASN1EncodableVector();
        try {
            ses_signature.add((ASN1Encodable)this.toSign.buildGbASN1Sequence());
            DEROctetString octetString = new DEROctetString(this.cert);
            ses_signature.add((ASN1Encodable)octetString);
            ses_signature.add((ASN1Encodable)new DERObjectIdentifier(GM_SIGNATURE_ALGORITHM));
            ses_signature.add((ASN1Encodable)new DERBitString(this.signature));
            DERSequence sequence = new DERSequence(ses_signature);
            return sequence.getEncoded();
        }
        catch (Exception e) {
            throw new RuntimeException("\u7ec4\u88c5\u56fd\u529e\u7b7e\u7ae0\u9519\u8bef");
        }
    }

    public byte[] buildGmASN1() {
        ASN1EncodableVector SES_Signature = new ASN1EncodableVector();
        try {
            SES_Signature.add((ASN1Encodable)this.toSign.buildGmASN1Sequence());
            SES_Signature.add((ASN1Encodable)new DERBitString(this.signature, 0));
            DERSequence sequence = new DERSequence(SES_Signature);
            return sequence.getEncoded();
        }
        catch (Exception e) {
            throw new RuntimeException("\u7ec4\u88c5\u56fd\u5bc6\u7b7e\u7ae0\u9519\u8bef");
        }
    }

    public static DERSequence getSesSignature(DLSequence toSign, byte[] cert, byte[] signature, byte[] timestamp) throws IOException {
        ASN1EncodableVector ses_signature = new ASN1EncodableVector();
        ses_signature.add((ASN1Encodable)toSign);
        DEROctetString octetString = new DEROctetString(cert);
        ses_signature.add((ASN1Encodable)octetString);
        ses_signature.add((ASN1Encodable)new DERObjectIdentifier(GM_SIGNATURE_ALGORITHM));
        ses_signature.add((ASN1Encodable)new DERBitString(signature));
        if (timestamp != null) {
            ses_signature.add((ASN1Encodable)new DERBitString(timestamp));
        }
        return new DERSequence(ses_signature);
    }

    public static DERSequence getToSignData(byte[] eseal, String date, byte[] dataHash, String propertyInfo) throws IOException {
        ASN1EncodableVector toSign = new ASN1EncodableVector();
        toSign.add((ASN1Encodable)new DERInteger(4L));
        ASN1InputStream inputStream = new ASN1InputStream(eseal);
        toSign.add((ASN1Encodable)inputStream.readObject());
        inputStream.close();
        toSign.add((ASN1Encodable)new DERGeneralizedTime(date));
        toSign.add((ASN1Encodable)new DERBitString(dataHash));
        toSign.add((ASN1Encodable)new DERIA5String(propertyInfo));
        return new DERSequence(toSign);
    }

    public TbsSign getToSign() {
        return this.toSign;
    }

    public void setToSign(TbsSign toSign) {
        this.toSign = toSign;
    }

    public byte[] getCert() {
        return this.cert;
    }

    public void setCert(byte[] cert) {
        this.cert = cert;
    }

    public String getSignatureAlgID() {
        return this.signatureAlgID;
    }

    public void setSignatureAlgID(String signatureAlgID) {
        this.signatureAlgID = signatureAlgID;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }
}

