/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.core;

import com.kgofd.ofd.core.CLibrary;
import com.kgofd.ofd.core.ProviderInfo;
import com.sun.jna.ptr.IntByReference;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class Jna {
    public ProviderInfo getProviderInfo() {
        ProviderInfo pi = new ProviderInfo();
        IntByReference piNameLen = new IntByReference();
        IntByReference piCompanyLen = new IntByReference();
        IntByReference piVersionLen = new IntByReference();
        IntByReference piExtendLen = new IntByReference();
        CLibrary.Instance.OES_GetProviderInfo(null, piNameLen, null, piCompanyLen, null, piVersionLen, null, piExtendLen);
        byte[] puchName = new byte[piNameLen.getValue()];
        byte[] puchCompany = new byte[piCompanyLen.getValue()];
        byte[] puchVersion = new byte[piCompanyLen.getValue()];
        byte[] puchExtend = new byte[piExtendLen.getValue()];
        CLibrary.Instance.OES_GetProviderInfo(puchName, piNameLen, puchCompany, piCompanyLen, puchVersion, piVersionLen, puchExtend, piExtendLen);
        pi.setName(new String(puchName));
        pi.setCompany(new String(puchCompany));
        pi.setVersion(new String(puchVersion));
        pi.setExtend(new String(puchExtend));
        return pi;
    }

    public String getSealList() {
        IntByReference piSealListDataLen = new IntByReference();
        CLibrary.Instance.OES_GetSealList(null, piSealListDataLen);
        byte[] puchSealListData = new byte[piSealListDataLen.getValue()];
        CLibrary.Instance.OES_GetSealList(puchSealListData, piSealListDataLen);
        String strSealList = null;
        try {
            strSealList = new String(puchSealListData, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return strSealList;
    }

    public byte[] getSeal(String sealId) {
        IntByReference piSealDataLen = new IntByReference();
        CLibrary.Instance.OES_GetSeal(sealId.getBytes(), sealId.length(), null, piSealDataLen);
        byte[] btSeal = new byte[piSealDataLen.getValue()];
        CLibrary.Instance.OES_GetSeal(sealId.getBytes(), sealId.length(), btSeal, piSealDataLen);
        return btSeal;
    }

    public String getDigestMethod() {
        IntByReference piDigestMethodLen = new IntByReference();
        CLibrary.Instance.OES_GetDigestMethod(null, piDigestMethodLen);
        byte[] btDigestMethod = new byte[piDigestMethodLen.getValue()];
        CLibrary.Instance.OES_GetDigestMethod(btDigestMethod, piDigestMethodLen);
        return new String(btDigestMethod);
    }

    public byte[] digest(InputStream data, String method) throws IOException {
        String strData = null;
        strData = Jna.convertStreamToString(data);
        IntByReference piDigestDataLen = new IntByReference();
        CLibrary.Instance.OES_Digest(strData.getBytes(), strData.length(), method.getBytes(), method.length(), null, piDigestDataLen);
        byte[] btDigestValue = new byte[piDigestDataLen.getValue()];
        CLibrary.Instance.OES_Digest(strData.getBytes(), strData.length(), method.getBytes(), method.length(), btDigestValue, piDigestDataLen);
        return btDigestValue;
    }

    public byte[] digest(byte[] data, String method) {
        IntByReference piDigestDataLen = new IntByReference();
        CLibrary.Instance.OES_Digest(data, data.length, method.getBytes(), method.length(), null, piDigestDataLen);
        byte[] btDigestValue = new byte[piDigestDataLen.getValue()];
        CLibrary.Instance.OES_Digest(data, data.length, method.getBytes(), method.length(), btDigestValue, piDigestDataLen);
        return btDigestValue;
    }

    public String getSignDateTime() {
        IntByReference piSignDateTimeLen = new IntByReference();
        CLibrary.Instance.OES_GetSignDateTime(null, piSignDateTimeLen);
        byte[] btSignDateTime = new byte[piSignDateTimeLen.getValue()];
        CLibrary.Instance.OES_GetSignDateTime(btSignDateTime, piSignDateTimeLen);
        return new String(btSignDateTime);
    }

    public String getSignMethod() {
        IntByReference piSignMethodLen = new IntByReference();
        CLibrary.Instance.OES_GetSignMethod(null, piSignMethodLen);
        byte[] btSignMethod = new byte[piSignMethodLen.getValue()];
        CLibrary.Instance.OES_GetSignMethod(btSignMethod, piSignMethodLen);
        return new String(btSignMethod);
    }

    public boolean verifyPin(String strPinCode) {
        int nRet = CLibrary.Instance.OES_Login(strPinCode.getBytes(), strPinCode.length());
        return nRet == 0;
    }

    public byte[] sign(String sealId, String docProperty, byte[] data, String method, String datetime) {
        IntByReference piSignValueLen = new IntByReference();
        CLibrary.Instance.OES_Sign(sealId.getBytes(), sealId.length(), docProperty.getBytes(), docProperty.length(), data, data.length, method.getBytes(), method.length(), datetime.getBytes(), datetime.length(), null, piSignValueLen);
        byte[] btSignValue = new byte[piSignValueLen.getValue()];
        CLibrary.Instance.OES_Sign(sealId.getBytes(), sealId.length(), docProperty.getBytes(), docProperty.length(), data, data.length, method.getBytes(), method.length(), datetime.getBytes(), datetime.length(), btSignValue, piSignValueLen);
        return btSignValue;
    }

    public static void createFile(String path, byte[] content) throws IOException {
        FileOutputStream fos = new FileOutputStream(path);
        fos.write(content);
        fos.close();
    }

    public static String convertStreamToString(InputStream in) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String s = null;
        int len = -1;
        byte[] buff = new byte[4096];
        try {
            while ((len = in.read(buff)) != -1) {
                byteArrayOutputStream.write(buff, 0, len);
            }
            s = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        }
        finally {
            byteArrayOutputStream.close();
        }
        return s;
    }
}

