/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.core;

import com.kgofd.ofd.enmu.KGHashType;
import java.io.IOException;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1EncodableVector;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.DERBitString;
import org.kg.bouncycastle.asn1.DERIA5String;
import org.kg.bouncycastle.asn1.DERInteger;
import org.kg.bouncycastle.asn1.DERObjectIdentifier;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DERSequence;
import org.kg.bouncycastle.asn1.DLSequence;

public class GMSesSignature {
    public static DERSequence getGMSesSignature(DLSequence toSign, byte[] signature) throws IOException {
        ASN1EncodableVector ses_signature = new ASN1EncodableVector();
        ses_signature.add((ASN1Encodable)toSign);
        ses_signature.add((ASN1Encodable)new DERBitString(signature));
        return new DERSequence(ses_signature);
    }

    public static DERSequence getGMToSignData(byte[] eseal, String date, byte[] dataHash, String propertyInfo, byte[] cert, KGHashType hashTypes) throws IOException {
        ASN1EncodableVector toSign = new ASN1EncodableVector();
        toSign.add((ASN1Encodable)new DERInteger(2L));
        ASN1InputStream inputStream = new ASN1InputStream(eseal);
        toSign.add((ASN1Encodable)inputStream.readObject());
        inputStream.close();
        toSign.add((ASN1Encodable)new DERBitString(date.getBytes()));
        toSign.add((ASN1Encodable)new DERBitString(dataHash));
        toSign.add((ASN1Encodable)new DERIA5String(propertyInfo));
        toSign.add((ASN1Encodable)new DEROctetString(cert));
        if (KGHashType.HASH_TYPE_SM3.equals((Object)hashTypes)) {
            toSign.add((ASN1Encodable)new DERObjectIdentifier("1.2.156.10197.1.501"));
        } else if (KGHashType.HASH_TYPE_SHA1.equals((Object)hashTypes)) {
            toSign.add((ASN1Encodable)new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        }
        return new DERSequence(toSign);
    }
}

