/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.core;

import com.kgofd.ofd.core.MyContentSigner;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.DERBitString;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.x500.X500Name;
import org.kg.bouncycastle.asn1.x500.X500NameBuilder;
import org.kg.bouncycastle.asn1.x500.style.BCStyle;
import org.kg.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.kg.bouncycastle.asn1.x509.BasicConstraints;
import org.kg.bouncycastle.asn1.x509.Extension;
import org.kg.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.kg.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.kg.bouncycastle.cert.X509CertificateHolder;
import org.kg.bouncycastle.cert.X509v3CertificateBuilder;
import org.kg.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.kg.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.kg.bouncycastle.operator.ContentSigner;
import org.kg.bouncycastle.util.encoders.Hex;

public class CertUtil {
    public static byte[] buildCert(AsymmetricCipherKeyPair keyPair) throws Exception {
        ECPublicKeyParameters publicKeyParameters = (ECPublicKeyParameters)keyPair.getPublic();
        byte[] publicKeyData = publicKeyParameters.getQ().getEncoded();
        X500NameBuilder x500NameBuilder = new X500NameBuilder();
        x500NameBuilder.addRDN(BCStyle.CN, "test");
        x500NameBuilder.addRDN(BCStyle.C, "CN");
        x500NameBuilder.addRDN(BCStyle.O, "\u91d1\u683c\u79d1\u6280");
        x500NameBuilder.addRDN(BCStyle.OU, "kinggrid");
        x500NameBuilder.addRDN(BCStyle.L, "jiangxi");
        X500Name x500Name = x500NameBuilder.build();
        BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
        Calendar nowTime = Calendar.getInstance();
        Date notBefore = nowTime.getTime();
        nowTime.add(1, 10);
        Date notAfter = nowTime.getTime();
        SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)new ASN1ObjectIdentifier("1.2.156.10197.1.301")), publicKeyData);
        X509v3CertificateBuilder x509v3CertificateBuilder = new X509v3CertificateBuilder(x500Name, serial, notBefore, notAfter, x500Name, publicKeyInfo);
        BasicConstraints basicConstraints = new BasicConstraints(0);
        x509v3CertificateBuilder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)basicConstraints);
        DERBitString keyUsage = new DERBitString(192);
        x509v3CertificateBuilder.addExtension(Extension.keyUsage, false, (ASN1Encodable)keyUsage);
        String str = "04C0";
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(Hex.decode((String)str));
        messageDigest.update(publicKeyInfo.getEncoded());
        byte[] digest = messageDigest.digest();
        DEROctetString subjectKeyIdentifier = new DEROctetString(digest);
        x509v3CertificateBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)subjectKeyIdentifier);
        MyContentSigner myContentSigner = new MyContentSigner(keyPair);
        X509CertificateHolder certificateHolder = x509v3CertificateBuilder.build((ContentSigner)myContentSigner);
        return certificateHolder.getEncoded();
    }
}

