/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.core;

import com.kgofd.encrypt.KGBase64;
import com.kgofd.encrypt.SM2;
import com.kgofd.ofd.core.CertUtil;
import com.kgofd.ofd.enmu.KGHashType;
import com.kgofd.ofd.utils.KGOfdUtils;
import com.kgofd.ofd.utils.ServerSignUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.UUID;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1EncodableVector;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERBitString;
import org.kg.bouncycastle.asn1.DERIA5String;
import org.kg.bouncycastle.asn1.DERInteger;
import org.kg.bouncycastle.asn1.DERObjectIdentifier;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DEROutputStream;
import org.kg.bouncycastle.asn1.DERSequence;
import org.kg.bouncycastle.asn1.DERUTCTime;
import org.kg.bouncycastle.asn1.DERUTF8String;
import org.kg.bouncycastle.crypto.AsymmetricCipherKeyPair;

public class BuildSealData {
    private static final String SEALHEADERID = "ES";
    private static final String SEALHEADERVID = "KingGrid";
    private String sealPropertyName;
    private byte[] sealPropertyCer;
    private String sealPropertyCreateDate;
    private String sealPropertyValidStart;
    private long sealPeriod;
    private String sealPicType;
    private byte[] sealPicData;
    private Float sealPicWidth;
    private Float sealPicHeight;
    private byte[] signCerData;
    private String signAlgoId = "1.2.156.10197.1.501";
    private AsymmetricCipherKeyPair keyPair;

    public BuildSealData(String sealPropertyName, byte[] sealPropertyCer, String sealPicType, byte[] sealPicData, Float sealPicWidth, Float sealPicHeight, String sealPropertyCreateDate, String sealPropertyValidStart, long sealPeriod) {
        this.sealPropertyName = sealPropertyName;
        this.sealPropertyCer = sealPropertyCer;
        this.sealPicType = sealPicType;
        this.sealPicData = sealPicData;
        this.sealPicWidth = sealPicWidth;
        this.sealPicHeight = sealPicHeight;
        this.sealPeriod = sealPeriod;
        this.signCerData = sealPropertyCer;
        this.sealPropertyCreateDate = sealPropertyCreateDate;
        this.sealPropertyValidStart = sealPropertyValidStart;
    }

    public byte[] getToSignData() {
        ByteArrayOutputStream outputStream;
        block12: {
            outputStream = null;
            DEROutputStream derOutputStream = null;
            try {
                try {
                    outputStream = new ByteArrayOutputStream();
                    derOutputStream = new DEROutputStream((OutputStream)outputStream);
                    ASN1EncodableVector SESeal = null;
                    SESeal = new ASN1EncodableVector();
                    ASN1EncodableVector sealInfo = null;
                    sealInfo = new ASN1EncodableVector();
                    ASN1EncodableVector header = null;
                    header = new ASN1EncodableVector();
                    header.add((ASN1Encodable)new DERIA5String(SEALHEADERID));
                    header.add((ASN1Encodable)new DERInteger(2L));
                    header.add((ASN1Encodable)new DERIA5String(SEALHEADERVID));
                    sealInfo.add((ASN1Encodable)new DERSequence(header));
                    sealInfo.add((ASN1Encodable)new DERIA5String(UUID.randomUUID().toString()));
                    ASN1EncodableVector propertyInfo = null;
                    propertyInfo = new ASN1EncodableVector();
                    propertyInfo.add((ASN1Encodable)new DERInteger(2L));
                    propertyInfo.add((ASN1Encodable)new DERUTF8String(this.sealPropertyName));
                    ASN1EncodableVector certList = null;
                    certList = new ASN1EncodableVector();
                    if (this.sealPropertyCer == null) {
                        SM2 sm2 = SM2.getInstance();
                        this.keyPair = sm2.ecc_key_pair_generator.generateKeyPair();
                        this.sealPropertyCer = CertUtil.buildCert(this.keyPair);
                        this.signCerData = this.sealPropertyCer;
                    }
                    certList.add((ASN1Encodable)new DEROctetString(this.sealPropertyCer));
                    propertyInfo.add((ASN1Encodable)new DERSequence(certList));
                    propertyInfo.add((ASN1Encodable)new DERUTCTime(this.sealPropertyCreateDate));
                    propertyInfo.add((ASN1Encodable)new DERUTCTime(this.sealPropertyValidStart));
                    propertyInfo.add((ASN1Encodable)new DERUTCTime(this.GetValidEnd()));
                    sealInfo.add((ASN1Encodable)new DERSequence(propertyInfo));
                    ASN1EncodableVector picInfo = null;
                    picInfo = new ASN1EncodableVector();
                    picInfo.add((ASN1Encodable)new DERIA5String(this.sealPicType));
                    picInfo.add((ASN1Encodable)new DEROctetString(this.sealPicData));
                    picInfo.add((ASN1Encodable)new DERInteger(this.sealPicWidth.longValue()));
                    picInfo.add((ASN1Encodable)new DERInteger(this.sealPicHeight.longValue()));
                    sealInfo.add((ASN1Encodable)new DERSequence(picInfo));
                    ASN1EncodableVector extData = null;
                    extData = new ASN1EncodableVector();
                    sealInfo.add((ASN1Encodable)new DERSequence(extData));
                    SESeal.add((ASN1Encodable)new DERSequence(sealInfo));
                    SESeal.add((ASN1Encodable)new DEROctetString(this.signCerData));
                    SESeal.add((ASN1Encodable)new DERObjectIdentifier(this.signAlgoId));
                    derOutputStream.writeObject((ASN1Encodable)new DERSequence(SESeal));
                    derOutputStream.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        derOutputStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    derOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                derOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return outputStream.toByteArray();
    }

    public byte[] getSealData(byte[] toSignData, byte[] signValue) throws IOException {
        ByteArrayOutputStream outputStream = null;
        DEROutputStream derOutputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            derOutputStream = new DEROutputStream((OutputStream)outputStream);
            ASN1InputStream asn1ToSignData = new ASN1InputStream(toSignData);
            ASN1Sequence toASN1SignData = (ASN1Sequence)asn1ToSignData.readObject();
            ASN1Sequence sealInfo = (ASN1Sequence)toASN1SignData.getObjectAt(0);
            ASN1EncodableVector signInfo = new ASN1EncodableVector();
            signInfo.add((ASN1Encodable)((DEROctetString)toASN1SignData.getObjectAt(1)));
            signInfo.add((ASN1Encodable)((DERObjectIdentifier)toASN1SignData.getObjectAt(2)));
            signInfo.add((ASN1Encodable)new DERBitString(signValue));
            ASN1EncodableVector SESeal = new ASN1EncodableVector();
            SESeal.add((ASN1Encodable)sealInfo);
            SESeal.add((ASN1Encodable)new DERSequence(signInfo));
            derOutputStream.writeObject((ASN1Encodable)new DERSequence(SESeal));
            derOutputStream.flush();
        }
        finally {
            derOutputStream.close();
        }
        return outputStream.toByteArray();
    }

    public String GetValidEnd() {
        Calendar cal = Calendar.getInstance();
        cal.add(1, (int)this.sealPeriod);
        DERUTCTime derUTCTime = new DERUTCTime(cal.getTime());
        return derUTCTime.toString();
    }

    public byte[] getSignData(byte[] toSignData, String url, String signsn, String keysn, KGHashType hashType) throws IOException {
        byte[] signature = null;
        if (url == null || "".equals(url)) {
            SM2 sm2 = SM2.getInstance();
            signature = sm2.sign(this.keyPair, toSignData);
        } else {
            KGBase64 base64 = new KGBase64();
            String toSignBase64 = base64.encode(toSignData);
            String signResult = null;
            signResult = keysn != null && !"".equals(keysn) ? ServerSignUtil.signByISignatureServerSM2(url, toSignBase64, keysn) : ServerSignUtil.signByZzkkServer(url, toSignBase64);
            signature = base64.decode(signResult);
        }
        return signature;
    }

    protected static byte[] dealSignData(byte[] sign) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(sign);
        ASN1InputStream asn1InputStream = new ASN1InputStream((InputStream)bis);
        byte[] signature = null;
        try {
            ASN1Sequence sequence = (ASN1Sequence)asn1InputStream.readObject();
            signature = new byte[64];
            byte[] temp1 = sequence.getObjectAt(0).toASN1Primitive().getEncoded();
            if (temp1.length == 35) {
                System.arraycopy(temp1, 3, signature, 0, 32);
            } else if (temp1.length == 34) {
                System.arraycopy(temp1, 2, signature, 0, 32);
            } else {
                System.arraycopy(temp1, 1, signature, 0, 32);
            }
            byte[] temp2 = sequence.getObjectAt(1).toASN1Primitive().getEncoded();
            if (temp2.length == 35) {
                System.arraycopy(temp2, 3, signature, 32, 32);
            } else if (temp2.length == 34) {
                System.arraycopy(temp2, 2, signature, 32, 32);
            } else {
                System.arraycopy(temp2, 1, signature, 32, 32);
            }
        }
        catch (Throwable throwable) {
            KGOfdUtils.close(new Closeable[]{asn1InputStream});
            throw throwable;
        }
        KGOfdUtils.close(new Closeable[]{asn1InputStream});
        return signature;
    }
}

