/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.annotation;

import com.kgofd.encrypt.KGBase64;
import com.kgofd.ofd.annotation.AnnoteType;
import com.kgofd.ofd.utils.KGOfdUtils;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Date;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class OfdAnnotations {
    private Document annotationsDocument;
    private String id = "0";

    public boolean addAnnotationByStr(String zipFile, String data) {
        Element MaxUnitIDElement;
        String[] datas = data.split("\\|");
        KGBase64 base64 = new KGBase64();
        try {
            Document docum = KGOfdUtils.getDocument(new ZipFile(zipFile), "Doc_0/Document.xml");
            if (docum != null) {
                MaxUnitIDElement = (Element)docum.selectSingleNode("/ofd:Document/ofd:CommonData/ofd:MaxUnitID");
                this.id = MaxUnitIDElement.getText();
                System.out.println("id=" + this.id);
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
            return false;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return false;
        }
        int i = 0;
        while (i < datas.length) {
            byte[] decodeData = base64.decode(datas[i]);
            String dataStr = new String(decodeData);
            String[] info = dataStr.split("\\|");
            System.out.println(dataStr);
            this.id = String.valueOf(Integer.parseInt(this.id) + 1);
            System.out.println("datas  id=" + this.id);
            try {
                int page = Integer.parseInt(info[1]) - 1;
                this.addAnnotations(new ZipFile(zipFile), page);
                if (AnnoteType.FreeText.ordinal() == Integer.parseInt(info[0])) {
                    Font font = new Font(info[7] == null ? "\u5b8b\u4f53" : info[7], info[9] == null ? 1 : Integer.parseInt(info[9]), info[8] == null ? 180 : Integer.parseInt(info[8]));
                    this.addAnnotation_Path(new ZipFile(zipFile), Integer.parseInt(info[1]) - 1, this.id, Double.parseDouble(info[2]), Double.parseDouble(info[3]), Double.parseDouble(info[4]), Double.parseDouble(info[5]), font, info[12], Double.parseDouble(info[8]), info[6], AnnoteType.FreeText, info[13], false, Integer.parseInt(info[9]) != 0, Integer.parseInt(info[10]) != 0);
                } else if (AnnoteType.Pencil.ordinal() == Integer.parseInt(info[0])) {
                    this.addAnnotation_Path(new ZipFile(zipFile), Integer.parseInt(info[1]) - 1, this.id, Double.parseDouble(info[2]), Double.parseDouble(info[3]), Double.parseDouble(info[4]), Double.parseDouble(info[5]), null, info[7], Double.parseDouble(info[6]), info[8], AnnoteType.Pencil, info[9], false, false, false);
                } else if (AnnoteType.Rectangle.ordinal() == Integer.parseInt(info[0])) {
                    this.addAnnotation_Path(new ZipFile(zipFile), Integer.parseInt(info[1]) - 1, this.id, Double.parseDouble(info[2]), Double.parseDouble(info[3]), Double.parseDouble(info[4]), Double.parseDouble(info[5]), null, info[7], Double.parseDouble(info[6]), "", AnnoteType.Rectangle, info[8], false, false, false);
                } else if (AnnoteType.Circle.ordinal() == Integer.parseInt(info[0])) {
                    this.addAnnotation_Path(new ZipFile(zipFile), Integer.parseInt(info[1]) - 1, this.id, Double.parseDouble(info[2]), Double.parseDouble(info[3]), Double.parseDouble(info[4]), Double.parseDouble(info[5]), null, info[7], Double.parseDouble(info[6]), "", AnnoteType.Circle, info[8], false, false, false);
                } else if (AnnoteType.Line.ordinal() == Integer.parseInt(info[0])) {
                    this.addAnnotation_Path(new ZipFile(zipFile), Integer.parseInt(info[1]) - 1, this.id, Double.parseDouble(info[2]), Double.parseDouble(info[3]), Double.parseDouble(info[4]), Double.parseDouble(info[5]), null, info[7], Double.parseDouble(info[6]), "", AnnoteType.Line, info[8], false, false, false);
                }
            }
            catch (ZipException e) {
                e.printStackTrace();
            }
            ++i;
        }
        try {
            Document docment = KGOfdUtils.getDocument(new ZipFile(zipFile), "Doc_0/Document.xml");
            MaxUnitIDElement = (Element)docment.selectSingleNode("/ofd:Document/ofd:CommonData/ofd:MaxUnitID");
            MaxUnitIDElement.setText(this.id);
            KGOfdUtils.writeToZip(new ZipFile(zipFile), "Doc_0/Document.xml", docment);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean addAnnotations(ZipFile zipFile, int page) {
        try {
            Element annotationBody = null;
            this.annotationsDocument = KGOfdUtils.getDocument(zipFile, "Doc_0/Annotations.xml");
            if (this.annotationsDocument == null) {
                this.annotationsDocument = DocumentHelper.createDocument();
                this.annotationsDocument.setXMLEncoding("UTF-8");
                annotationBody = this.annotationsDocument.addElement("ofd:Annotations");
                annotationBody.addNamespace("ofd", "http://www.ofdspec.org");
                Document docment = KGOfdUtils.getDocument(zipFile, "Doc_0/Document.xml");
                Element eleDocument = (Element)docment.selectSingleNode("ofd:Document");
                Element eleAnnotations = eleDocument.addElement("ofd:Annotations");
                eleAnnotations.setText("Annotations.xml");
                KGOfdUtils.writeToZip(zipFile, "Doc_0/Document.xml", docment);
            } else {
                annotationBody = (Element)this.annotationsDocument.selectSingleNode("ofd:Annotations");
            }
            List fileLocString = this.annotationsDocument.selectNodes("ofd:Annotations/ofd:Page/ofd:FileLoc");
            boolean addNode = true;
            for (Element fileLoc : fileLocString) {
                if (fileLoc.getTextTrim().indexOf("Page_" + page + "/Annotation.xml") == -1) continue;
                addNode = false;
                break;
            }
            if (addNode) {
                Document docment = KGOfdUtils.getDocument(zipFile, "Doc_0/Document.xml");
                List eles = docment.selectNodes("ofd:Document/ofd:Pages/ofd:Page");
                String id = ((Element)eles.get(page)).attributeValue("ID");
                Element elePage = annotationBody.addElement("ofd:Page");
                elePage.setAttributeValue("PageID", id);
                elePage.addElement("ofd:FileLoc").setText("Pages/Page_" + page + "/Annotation.xml");
            }
            KGOfdUtils.writeToZip(zipFile, "Doc_0/Annotations.xml", this.annotationsDocument);
        }
        catch (ZipException e) {
            e.printStackTrace();
            return false;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean addAnnotation_Path(ZipFile zipFile, int pageNum, String ids, double startX, double startY, double endX, double endY, Font textFont, String color, double lengthOrLineWidth, String data, AnnoteType subtype, String creator, boolean isReadOnly, boolean isItalic, boolean isBold) {
        String strAnnotation = "Doc_0/Pages/Page_";
        strAnnotation = String.valueOf(strAnnotation) + pageNum;
        strAnnotation = String.valueOf(strAnnotation) + "/Annotation.xml";
        Color colors = new Color(Integer.parseInt(color.substring(3), 16));
        try {
            String strContent = "Doc_0/Pages/Page_";
            strContent = String.valueOf(strContent) + pageNum;
            strContent = String.valueOf(strContent) + "/Content.xml";
            Document contentDoc = KGOfdUtils.getDocument(zipFile, strContent);
            Element physicalBox = (Element)contentDoc.selectSingleNode("/ofd:Page/ofd:Area/ofd:PhysicalBox");
            String boundary = physicalBox.getText();
            Element annotationBody = null;
            this.annotationsDocument = KGOfdUtils.getDocument(zipFile, strAnnotation);
            if (this.annotationsDocument == null) {
                this.annotationsDocument = DocumentHelper.createDocument();
                this.annotationsDocument.setXMLEncoding("UTF-8");
                annotationBody = this.annotationsDocument.addElement("ofd:PageAnnot");
                annotationBody.addNamespace("ofd", "http://www.ofdspec.org");
            } else {
                annotationBody = (Element)this.annotationsDocument.selectSingleNode("ofd:PageAnnot");
            }
            Element eleAnnot = annotationBody.addElement("ofd:Annot");
            eleAnnot.addAttribute("Type", "Path");
            this.id = String.valueOf(Integer.parseInt(this.id) + 1);
            System.out.println("addAnnotation_Path  id = " + this.id);
            eleAnnot.addAttribute("ID", this.id);
            eleAnnot.addAttribute("Creator", creator);
            eleAnnot.addAttribute("LastModDate", new Date().toLocaleString());
            eleAnnot.addAttribute("ReadOnly", isReadOnly ? "true" : "false");
            eleAnnot.addAttribute("Subtype", subtype.name());
            Element eleAppearance = eleAnnot.addElement("ofd:Appearance");
            this.id = String.valueOf(Integer.parseInt(this.id) + 1);
            eleAppearance.addAttribute("Boundary", boundary);
            eleAppearance.addAttribute("ID", this.id);
            this.id = String.valueOf(Integer.parseInt(this.id) + 1);
            if (subtype.equals((Object)AnnoteType.FreeText)) {
                Document publicRes = KGOfdUtils.getDocument(zipFile, "Doc_0/PublicRes.xml");
                String font = "";
                if (publicRes != null) {
                    List nodes = publicRes.selectNodes("/ofd:Res/ofd:Fonts/ofd:Font");
                    int i = 0;
                    while (i < nodes.size()) {
                        Element element = (Element)nodes.get(i);
                        if (textFont.getFontName().equals(element.attributeValue("FontName"))) {
                            font = element.attributeValue("ID");
                            break;
                        }
                        ++i;
                    }
                    if ("".equals(font)) {
                        Element node = (Element)publicRes.selectSingleNode("/ofd:Res/ofd:Fonts");
                        Element elementFont = node.addElement("ofd:Font");
                        elementFont.addAttribute("FontName", textFont.getFontName());
                        elementFont.addAttribute("ID", this.id);
                        font = this.id;
                        this.id = String.valueOf(Integer.parseInt(this.id) + 1);
                        KGOfdUtils.writeToZip(zipFile, "Doc_0/PublicRes.xml", publicRes);
                    }
                }
                Element eleTextObject = eleAppearance.addElement("ofd:TextObject");
                String strBoundary = String.valueOf(startX);
                strBoundary = String.valueOf(strBoundary) + " ";
                strBoundary = String.valueOf(strBoundary) + startY;
                strBoundary = String.valueOf(strBoundary) + " ";
                strBoundary = String.valueOf(strBoundary) + endX;
                strBoundary = String.valueOf(strBoundary) + " ";
                strBoundary = String.valueOf(strBoundary) + endY;
                eleTextObject.addAttribute("Boundary", strBoundary);
                eleTextObject.addAttribute("Font", font);
                eleTextObject.addAttribute("Size", String.valueOf(lengthOrLineWidth));
                eleTextObject.addAttribute("Italic", isItalic ? "true" : "false");
                eleTextObject.addAttribute("Weight", isBold ? "700" : "0");
                eleTextObject.addAttribute("ID", this.id);
                Element eleStrokeColor = eleTextObject.addElement("ofd:FillColor");
                eleStrokeColor.addAttribute("Value", String.valueOf(colors.getRed()) + " " + colors.getGreen() + " " + colors.getBlue());
                eleStrokeColor.addAttribute("Alpha", "255");
                Element eleTextCode = eleTextObject.addElement("ofd:TextCode");
                eleTextCode.addAttribute("X", "0");
                eleTextCode.addAttribute("Y", String.valueOf(textFont.getSize()));
                String[] datas = data.split("");
                String deltaX = "";
                double fontSize = textFont.getSize();
                int i = 0;
                while (i < datas.length - 1) {
                    deltaX = datas[i].matches("^[a-zA-Z]*") || datas[i].matches("\\s*") ? String.valueOf(deltaX) + fontSize / 2.0 + " " : String.valueOf(deltaX) + fontSize + " ";
                    ++i;
                }
                eleTextCode.addAttribute("DeltaX", deltaX.substring(0, deltaX.length()));
                eleTextCode.addText(data);
            } else {
                Element elePathObject = eleAppearance.addElement("ofd:PathObject");
                elePathObject.addAttribute("Boundary", boundary);
                elePathObject.addAttribute("LineWidth", String.valueOf(lengthOrLineWidth));
                elePathObject.addAttribute("ID", this.id);
                Element eleStrokeColor = elePathObject.addElement("ofd:StrokeColor");
                eleStrokeColor.addAttribute("Value", String.valueOf(colors.getRed()) + " " + colors.getGreen() + " " + colors.getBlue());
                eleStrokeColor.addAttribute("Alpha", "255");
                Element eleAbbreviatedData = elePathObject.addElement("ofd:AbbreviatedData");
                if (subtype.equals((Object)AnnoteType.Pencil)) {
                    eleAbbreviatedData.addText(data);
                } else if (subtype.equals((Object)AnnoteType.Rectangle)) {
                    String text = "M " + startX + " " + startY + " L " + endX + " " + startY + " L " + endX + " " + endY + " L " + startX + " " + endY + " C";
                    eleAbbreviatedData.addText(text);
                } else if (subtype.equals((Object)AnnoteType.Circle)) {
                    eleAbbreviatedData.addText(this.circleData(startX, startY, endX, endY));
                } else if (subtype.equals((Object)AnnoteType.Line)) {
                    String text = "M " + startX + " " + startY + " L " + endX + " " + endY;
                    eleAbbreviatedData.addText(text);
                }
            }
            KGOfdUtils.writeToZip(zipFile, strAnnotation, this.annotationsDocument);
        }
        catch (ZipException e) {
            e.printStackTrace();
            return false;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String circleData(double x2, double y2, double x1, double y1) {
        double k = 0.5522848;
        double a = (x1 - x2) / 2.0;
        double b = (y1 - y2) / 2.0;
        double x = x2 + a;
        double y = y2 + b;
        double ox = a * k;
        double oy = b * k;
        String ret = "M ";
        ret = String.valueOf(ret) + (x - a);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + y;
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + "B ";
        ret = String.valueOf(ret) + (x - a);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + (y - oy);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + (x - ox);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + (y - b);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + x;
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + (y - b);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + "B ";
        ret = String.valueOf(ret) + (x + ox);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + (y - b);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + (x + a);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + (y - oy);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + (x + a);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + y;
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + "B ";
        ret = String.valueOf(ret) + (x + a);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + (y + oy);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + (x + ox);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + (y + b);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + x;
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + (y + b);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + "B ";
        ret = String.valueOf(ret) + (x - ox);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + (y + b);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + (x - a);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + (y + oy);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + (x - a);
        ret = String.valueOf(ret) + " ";
        ret = String.valueOf(ret) + y;
        return ret;
    }

    public boolean addAnnotation_WaterMark(ZipFile zipFile, int pageNum, String id, double startX, double startY, double endX, double endY, String alpha, String resourceID, String creator, boolean isReadOnly) {
        String strAnnotation = "Doc_0/Pages/Page_";
        strAnnotation = String.valueOf(strAnnotation) + pageNum;
        strAnnotation = String.valueOf(strAnnotation) + "/Annotation.xml";
        try {
            Element annotationBody = null;
            this.annotationsDocument = KGOfdUtils.getDocument(zipFile, strAnnotation);
            if (this.annotationsDocument == null) {
                this.annotationsDocument = DocumentHelper.createDocument();
                this.annotationsDocument.setXMLEncoding("UTF-8");
                annotationBody = this.annotationsDocument.addElement("ofd:PageAnnot");
                annotationBody.addNamespace("ofd", "http://www.ofdspec.org");
            } else {
                annotationBody = (Element)this.annotationsDocument.selectSingleNode("ofd:PageAnnot");
            }
            Element eleAnnot = annotationBody.addElement("ofd:Annot");
            eleAnnot.addAttribute("Type", "Watermark");
            eleAnnot.addAttribute("ID", id);
            eleAnnot.addAttribute("Creator", creator);
            eleAnnot.addAttribute("LastModDate", new Date().toLocaleString());
            eleAnnot.addAttribute("ReadOnly", isReadOnly ? "true" : "false");
            Element eleAppearance = eleAnnot.addElement("ofd:Appearance");
            String strBoundary = String.valueOf(startX);
            strBoundary = String.valueOf(strBoundary) + " ";
            strBoundary = String.valueOf(strBoundary) + startY;
            strBoundary = String.valueOf(strBoundary) + " ";
            strBoundary = String.valueOf(strBoundary) + endX;
            strBoundary = String.valueOf(strBoundary) + " ";
            strBoundary = String.valueOf(strBoundary) + endY;
            eleAppearance.addAttribute("Boundary", strBoundary);
            eleAppearance.addAttribute("ID", String.valueOf(Integer.valueOf(id) + 1));
            Element eleImageObject = eleAppearance.addElement("ofd:ImageObject");
            eleImageObject.addAttribute("ID", String.valueOf(Integer.valueOf(id) + 2));
            eleImageObject.addAttribute("Boundary", strBoundary);
            eleImageObject.addAttribute("Alpha", alpha);
            eleImageObject.addAttribute("ResourceID", resourceID);
            eleImageObject.addAttribute("CTM", "");
        }
        catch (ZipException e) {
            e.printStackTrace();
            return false;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String txt2String(File file) {
        StringBuilder result = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String s = null;
            while ((s = br.readLine()) != null) {
                result.append(s);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public static String colorFormat(String colorStr) {
        String R = colorStr.substring(3, 5);
        String G = colorStr.substring(5, 7);
        String B = colorStr.substring(7, 9);
        int RInt = Integer.parseInt(R, 16);
        int GInt = Integer.parseInt(G, 16);
        int BInt = Integer.parseInt(B, 16);
        return String.valueOf(RInt) + " " + GInt + " " + BInt;
    }
}

