/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd;

import com.kgofd.authorization.KGLicense;
import com.kgofd.ofd.utils.KGOfdUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.dom4j.DocumentException;

public abstract class KGExecute {
    private static final int PAGEN_TYPE_ARRAY = 1;
    private static final int PAGEN_TYPE_DEFAULT = -1;
    private int pagenType = -1;
    private int pagen;
    protected int[] pagens;
    protected boolean multiUserSign;

    protected abstract void execute(int[] var1, ZipFile var2) throws DocumentException, IOException, ZipException;

    protected void before() throws IOException {
    }

    protected void after() throws DocumentException {
    }

    protected void doExecute(ZipFile zipFile, boolean multiUserSign) throws ZipException, DocumentException, IOException {
        this.multiUserSign = multiUserSign;
        Class<?> clazz = this.getClass();
        String clazzName = clazz.getName();
        KGLicense.authorization(clazzName, "doExecute");
        if (this.pagenType == -1) {
            if (this.pagen == 0) {
                int pageSize = KGOfdUtils.getTotalPage(zipFile);
                this.pagens = new int[pageSize];
                int i = 0;
                while (i < this.pagens.length) {
                    this.pagens[i] = i + 1;
                    ++i;
                }
            } else {
                this.pagens = new int[]{this.pagen};
            }
        }
        this.execute(this.pagens, zipFile);
    }

    public void setPagen(int pagen) {
        this.pagenType = -1;
        this.pagen = pagen;
    }

    public void setPagen(int[] pagens) {
        this.pagenType = 1;
        if (pagens == null || pagens.length == 0) {
            throw new IllegalArgumentException("pagens\u7684\u53c2\u6570\u5f02\u5e38\uff0c\u4e3a" + Arrays.toString(pagens));
        }
        Arrays.sort(pagens);
        this.pagens = pagens;
    }

    public void setPagen(String pagenExp) {
        this.pagenType = 1;
        if (pagenExp != null) {
            String[] parts;
            Pattern pattern = Pattern.compile("[[\\d\\-\\d,]*[\\d,]*[\\d\\-\\d,]*[\\d,]*]*[\\d\\-\\d]*[\\d]+");
            Matcher matcher = pattern.matcher(pagenExp);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("\u8bbe\u7f6e\u9875\u7801\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e\uff1a" + pagenExp);
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            String[] stringArray = parts = pagenExp.split(",");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String sub = stringArray[n2];
                int index = -1;
                index = sub.indexOf(45);
                if (index == -1) {
                    int page = Integer.parseInt(sub);
                    list.add(page);
                } else {
                    int end;
                    int start = Integer.parseInt(sub.substring(0, index));
                    if (start > (end = Integer.parseInt(sub.substring(index + 1)))) {
                        int tmp = start;
                        start = end;
                        end = tmp;
                    }
                    int i = start;
                    while (i <= end) {
                        list.add(i);
                        ++i;
                    }
                }
                ++n2;
            }
            this.pagens = new int[list.size()];
            int i = 0;
            while (i < list.size()) {
                this.pagens[i] = (Integer)list.get(i);
                ++i;
            }
        } else {
            throw new IllegalArgumentException("pagenExp\u53c2\u6570\u5f02\u5e38\uff0c\u4e3anull");
        }
        Arrays.sort(this.pagens);
    }
}

