/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.kgcore;

import com.kgofd.encrypt.KGBase64;
import com.kgofd.encrypt.MD5;
import com.kgofd.exception.KGErrorPwdException;
import com.kgofd.kgcore.SealInformation;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class ParserKeySealData {
    public static final String DEFAULT_KEYSN = "2307534354093643";
    private static final String CHARSET = "GBK";
    private List<SealInformation> seals;

    public void parserKeyFileData(String keyfile) throws IOException {
        File file = new File(keyfile);
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException(".key\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u6587\u4ef6\uff1a" + keyfile);
        }
        BufferedReader bufferedReader = null;
        BufferedInputStream bufferedInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        KGBase64 bas64 = new KGBase64();
        this.seals = new ArrayList<SealInformation>();
        try {
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                byteArrayOutputStream = new ByteArrayOutputStream();
                this.copy(bufferedInputStream, byteArrayOutputStream);
                String pattern = new String(bas64.decode("bGl1a2luZ2dyaWRwZW5nXg=="), CHARSET);
                SecretKeySpec key = new SecretKeySpec(pattern.getBytes(), "AES");
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(2, key);
                byte[] buffer = cipher.doFinal(byteArrayOutputStream.toByteArray());
                bufferedReader = new BufferedReader(new StringReader(new String(buffer, CHARSET)));
                String line = null;
                int index = -1;
                String tableBase64 = null;
                String unitName = null;
                while ((line = bufferedReader.readLine()) != null) {
                    index = line.indexOf("=");
                    if ("UNITINFO".equalsIgnoreCase(line.substring(0, index))) {
                        line = line.substring(index + 1);
                        index = line.indexOf("=");
                        tableBase64 = line.substring(0, 65);
                        unitName = this.decode(line.substring(65), tableBase64);
                        continue;
                    }
                    line = line.substring(index + 1);
                    index = line.lastIndexOf(";");
                    String tmp = line.substring(0, index + 1);
                    String[] str = tmp.split(";");
                    SealInformation sealInformation = new SealInformation();
                    sealInformation.setImgPosition(str[0]);
                    sealInformation.setImgTableBase64(str[1]);
                    tableBase64 = str[1];
                    sealInformation.setSignSN(tableBase64);
                    sealInformation.setImgUserName(this.decode(str[2], tableBase64));
                    sealInformation.setImgSignName(this.decode(str[3], tableBase64));
                    sealInformation.setImgSignPass(MD5.stringToMD5(this.decode(str[4], tableBase64), CHARSET));
                    sealInformation.setKeyPwd(MD5.stringToMD5(this.decode(str[4], tableBase64), CHARSET));
                    sealInformation.setImgFileExt(this.decode(str[5], tableBase64));
                    sealInformation.setImgWidth(this.decode(str[6], tableBase64));
                    sealInformation.setImgHeight(this.decode(str[7], tableBase64));
                    sealInformation.setImgUnitName(unitName);
                    sealInformation.setKeySN(DEFAULT_KEYSN);
                    tmp = line.substring(index + 1);
                    bas64.setBase64Table(tableBase64);
                    byte[] image = bas64.decode(tmp);
                    sealInformation.setImgValue(image);
                    this.seals.add(sealInformation);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            this.close(bufferedReader);
            this.close(bufferedInputStream);
            throw throwable;
        }
        this.close(bufferedReader);
        this.close(bufferedInputStream);
    }

    public List<SealInformation> getAllSeals() {
        return this.seals;
    }

    public SealInformation getSealByIndex(int sealIndex, String sealPwd) {
        if (this.seals.isEmpty()) {
            throw new IllegalArgumentException(".key\u6587\u4ef6\u4e0d\u5b58\u5728\u7b7e\u7ae0.");
        }
        if (sealIndex <= -1 || sealIndex >= this.seals.size()) {
            throw new IllegalArgumentException("sealNumb\u53d6\u503c\u8303\u56f40~" + (this.seals.size() - 1) + " : " + sealIndex);
        }
        SealInformation sealInformation = this.seals.get(sealIndex);
        String md5 = MD5.stringToMD5(sealPwd, CHARSET);
        if (!md5.equals(sealInformation.getImgSignPass())) {
            throw new KGErrorPwdException("\u5bc6\u7801\u4e0d\u6b63\u786e,\u5370\u7ae0\u5e8f\u53f7:" + sealIndex);
        }
        return sealInformation;
    }

    private String decode(String str, String tableBase64) throws UnsupportedEncodingException {
        KGBase64 bas64 = new KGBase64();
        bas64.setBase64Table(tableBase64);
        return new String(bas64.decode(str), CHARSET);
    }

    private void copy(InputStream in, OutputStream os) throws IOException {
        int len = -1;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) != -1) {
            os.write(buf, 0, len);
        }
        os.flush();
    }

    private void close(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

