/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.kgcore;

import com.kgofd.encrypt.MD5;
import com.kgofd.exception.KGErrorPwdException;
import com.kgofd.kgcore.KGHttpUtils;
import com.kgofd.kgcore.SealInformation;
import com.kgofd.kgcore.enmu.KGSealSourceEnum;
import com.kgofd.kgcore.enmu.KGServerTypeEnum;
import java.io.IOException;
import java.util.List;

public class KGElectronicSeal {
    private KGSealSourceEnum sealSourceEnum;
    private String url;
    private String keySN;
    private KGServerTypeEnum type = KGServerTypeEnum.AUTO;
    private String password;
    private boolean forceValidatePwd = false;
    private String signName;
    private int index = -1;

    public KGElectronicSeal(String url, String keySN, String password, String signName) {
        this.url = url;
        this.keySN = keySN;
        this.password = password;
        this.signName = signName;
        this.index = -1;
        this.sealSourceEnum = KGSealSourceEnum.SERVER;
    }

    public KGElectronicSeal(String url, String keySN, String password, int index) {
        if (index < 0) {
            throw new RuntimeException("\u5370\u7ae0\u5e8f\u53f7\u4e0d\u80fd\u5c0f\u4e8e0\uff1aindex=" + index);
        }
        this.url = url;
        this.keySN = keySN;
        this.password = password;
        this.index = index;
        this.sealSourceEnum = KGSealSourceEnum.SERVER;
    }

    public SealInformation getSeal() throws IOException {
        return this.getSealfromServer();
    }

    private SealInformation getSealfromServer() {
        KGHttpUtils http = new KGHttpUtils();
        List<SealInformation> seals = http.getServerSeal(this.url, this.type, this.keySN, null);
        if (seals == null || seals.size() == 0) {
            throw new RuntimeException("\u8be5\u7528\u6237\u3010keySN=\uff1a" + this.keySN + "\u3011\u65e0\u5370\u7ae0");
        }
        if (this.index > -1) {
            if (this.index >= seals.size()) {
                throw new RuntimeException("\u8be5\u7528\u6237\u3010keySN=" + this.keySN + "\u3011\u53ea\u6709" + seals.size() + "\u4e2a\u5370\u7ae0\uff0c\u5f53\u524d\u5e8f\u53f7\uff08index\uff09\u503c\uff1a" + this.index);
            }
            SealInformation seal = seals.get(this.index);
            this.validatePwd(seal);
            return seal;
        }
        if (seals != null && seals.size() > 0) {
            for (SealInformation seal : seals) {
                String imgSignName = seal.getImgSignName();
                if (imgSignName == null || !imgSignName.equals(this.signName)) continue;
                this.validatePwd(seal);
                return seal;
            }
            throw new IllegalArgumentException(String.valueOf(this.keySN) + "\u7528\u6237\u6ca1\u6709\u540d\u79f0\u4e3a\u3010" + this.signName + "\u3011\u7684\u5370\u7ae0.");
        }
        throw new IllegalArgumentException(String.valueOf(this.keySN) + "\u7528\u6237\u6ca1\u6709\u53ef\u7528\u7684\u5370\u7ae0.");
    }

    private void validatePwd(SealInformation seal) {
        if (this.type == KGServerTypeEnum.CA0 || this.forceValidatePwd) {
            String pwd = MD5.stringToMD5(this.password, "UTF-8");
            if (!seal.getKeyPwd().equals(pwd)) {
                throw new KGErrorPwdException("\u7528\u6237\u3010" + this.keySN + "\u3011\u5bc6\u7801\u4e0d\u6b63\u786e.");
            }
        }
    }

    public boolean isSealFromServer() {
        return this.sealSourceEnum == KGSealSourceEnum.SERVER;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isForceValidatePwd() {
        return this.forceValidatePwd;
    }

    public void forceValidatePwd() {
        this.forceValidatePwd = true;
    }

    public KGServerTypeEnum getType() {
        return this.type;
    }

    public void setType(KGServerTypeEnum type) {
        this.type = type;
    }
}

