/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.encrypt;

import com.kgofd.commons.KGDateUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import org.kg.bouncycastle.jce.provider.BouncyCastleProvider;

public class KGSignature {
    public static final String SHA1WITHRSA = "SHA1withRSA";
    private PrivateKey privateKey;
    private Certificate[] chain;
    private Signature signature;

    public KGSignature(PrivateKey privateKey, Certificate[] chain) {
        this.privateKey = privateKey;
        this.chain = chain;
    }

    public KGSignature(InputStream cert, String keystorePwd, String pwd) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore ks = KeyStore.getInstance("PKCS12", "KGBC");
        ks.load(cert, keystorePwd.toCharArray());
        Enumeration<String> enumeration = ks.aliases();
        String alias = null;
        while (this.privateKey == null) {
            if (!enumeration.hasMoreElements()) continue;
            alias = enumeration.nextElement();
            this.privateKey = (PrivateKey)ks.getKey(alias, pwd.toCharArray());
        }
        this.chain = ks.getCertificateChain(alias);
    }

    public boolean verifyCertificateIsExpired() {
        Boolean status = true;
        if (this.chain != null && this.chain.length > 0) {
            X509Certificate x509Certificate = (X509Certificate)this.chain[0];
            Date start_date = x509Certificate.getNotBefore();
            Date expire_date = x509Certificate.getNotAfter();
            status = KGDateUtils.compareDate(new Date(), start_date) >= 0 && KGDateUtils.compareDate(new Date(), expire_date) <= 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return status;
    }

    public void initSign(String algorithm) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException {
        this.signature = Signature.getInstance(algorithm, "KGBC");
        this.signature.initSign(this.privateKey);
    }

    public void update(byte[] data) throws SignatureException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException {
        if (this.signature == null) {
            this.initSign(SHA1WITHRSA);
        }
        this.signature.update(data);
    }

    public byte[] sign() throws SignatureException {
        return this.signature.sign();
    }

    public static boolean verify(Certificate certificate, byte[] signedData, byte[] original, String algorithm) {
        PublicKey publicKey = certificate.getPublicKey();
        try {
            Signature signature = Signature.getInstance(algorithm, (Provider)new BouncyCastleProvider());
            signature.initVerify(publicKey);
            signature.update(original);
            return signature.verify(signedData);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public Certificate[] getChain() {
        return this.chain;
    }

    public void setChain(Certificate[] chain) {
        this.chain = chain;
    }
}

