/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.commons;

import com.kgofd.ofd.img.seal.SquareSeal;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;

public class Utils {
    public static BufferedImage invalidImg(BufferedImage bi, double percent) {
        Graphics2D g = bi.createGraphics();
        g.setColor(new Color(128, 128, 128));
        double height = (float)(30.0 * percent);
        int start = (int)((double)(bi.getHeight() / 2) - height / 2.0);
        g.fillRect(0, start, bi.getWidth(), (int)(height / 3.0));
        g.fillRect(0, (int)((double)start + height / 3.0 * 2.0), bi.getWidth(), (int)(height / 3.0));
        g.dispose();
        return bi;
    }

    public static BufferedImage alpha(BufferedImage bi) {
        boolean bottom;
        int height = bi.getHeight();
        int width = bi.getWidth();
        boolean left = bi.getRGB(0, 0) >> 24 == 0;
        boolean top = bi.getRGB(0, height - 1) >> 24 == 0;
        boolean right = bi.getRGB(width - 1, 0) >> 24 == 0;
        boolean bl = bottom = bi.getRGB(width - 1, height - 1) >> 24 == 0;
        if (left || top || right || bottom) {
            return bi;
        }
        return Utils.needAlpha(bi);
    }

    private static BufferedImage needAlpha(BufferedImage bi) {
        ImageIcon imageIcon = new ImageIcon(bi);
        BufferedImage _bi = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 7);
        Graphics2D g2D = (Graphics2D)_bi.getGraphics();
        g2D.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
        int alpha = 0;
        int j1 = _bi.getMinY();
        while (j1 < _bi.getHeight()) {
            int j2 = _bi.getMinX();
            while (j2 < _bi.getWidth()) {
                int rgb = _bi.getRGB(j2, j1);
                int R = (rgb & 0xFF0000) >> 16;
                int G = (rgb & 0xFF00) >> 8;
                int B = rgb & 0xFF;
                if (255 - R < 30 && 255 - G < 30 && 255 - B < 30) {
                    rgb = alpha + 1 << 24 | rgb & 0xFFFFFF;
                }
                _bi.setRGB(j2, j1, rgb);
                ++j2;
            }
            ++j1;
        }
        return _bi;
    }

    public static String file2String(File file) {
        try {
            String temp;
            BufferedReader buffer = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder();
            while ((temp = buffer.readLine()) != null) {
                sb.append(temp);
            }
            return sb.toString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] file2Byte(String filePath) {
        ByteArrayOutputStream bos = null;
        BufferedInputStream in = null;
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                throw new FileNotFoundException("file not exists");
            }
            bos = new ByteArrayOutputStream((int)file.length());
            in = new BufferedInputStream(new FileInputStream(file));
            int buf_size = 1024;
            byte[] buffer = new byte[buf_size];
            int len = 0;
            while (-1 != (len = in.read(buffer, 0, buf_size))) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static byte[] TextToSignImg(String text, Float imgWidth, Float imgHeight, Font textFont, String color, double angle, int nBorder, String outPath) {
        SquareSeal square = new SquareSeal();
        square.setImageWidth((int)(28.346457f * imgWidth.floatValue()));
        square.setImageHigth((int)(28.346457f * imgHeight.floatValue()));
        square.setText(text, textFont);
        square.setAngle(angle);
        square.setTextColor(new Color(Integer.parseInt(color, 16)));
        square.setBorder(nBorder);
        try {
            byte[] bs = square.squarePng();
            FileOutputStream file = new FileOutputStream(new File(outPath));
            file.write(bs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Utils.file2Byte(outPath);
    }

    public static void delFile(String filepath) {
        File file = new File(filepath);
        if (file.exists() && file.isFile()) {
            file.delete();
        }
    }

    public static byte[] readToByte(String fileName) throws IOException {
        FileInputStream in = new FileInputStream(fileName);
        byte[] data = Utils.toByteArray(in);
        ((InputStream)in).close();
        return data;
    }

    private static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while ((n = in.read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
        return out.toByteArray();
    }
}

