/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.commons;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class KGDateUtils {
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";

    public static String format(Date date, String pattren) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattren);
        return simpleDateFormat.format(date);
    }

    public static String date(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(YYYY_MM_DD);
        return simpleDateFormat.format(date);
    }

    public static String dateTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        return simpleDateFormat.format(date);
    }

    public static Date parse2Date(String date, String pattren) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattren);
        try {
            return simpleDateFormat.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3a\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    public static Date parseUTC2Date(String date, String pattren) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattren);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        try {
            return simpleDateFormat.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3a\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    public static int compareDate(Date frist, Date second) {
        Calendar calendarFrist = Calendar.getInstance();
        Calendar calendarSecond = Calendar.getInstance();
        calendarFrist.setTime(frist);
        calendarSecond.setTime(second);
        return calendarFrist.compareTo(calendarSecond);
    }

    public static Date parseUTCTime(String UTCTime) {
        String time = "20" + UTCTime;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date date = null;
        try {
            date = sdf.parse(time);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }

    public static String formatUTCTime(String UTCTime) {
        Date date = KGDateUtils.parseUTCTime(UTCTime);
        return KGDateUtils.dateTime(date);
    }

    public static String getDate(String timestamp) {
        String year = timestamp.substring(0, 4);
        String month = timestamp.substring(4, 6);
        String day = timestamp.substring(6, 8);
        String hour = timestamp.substring(8, 10);
        String mi = timestamp.substring(10, 12);
        String sec = timestamp.substring(12, 14);
        String date = String.valueOf(year) + "-" + month + "-" + day + " " + hour + ":" + mi + ":" + sec;
        return date;
    }

    public static String dealHour(String time, String flag, int num) {
        SimpleDateFormat format = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        Date date = KGDateUtils.parse2Date(time, YYYY_MM_DD_HH_MM_SS);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (flag.equals("add")) {
            cal.set(11, cal.get(11) + num);
        } else {
            cal.set(11, cal.get(11) - num);
        }
        String finaltime = format.format(cal.getTime());
        return finaltime;
    }

    public static String toTimeStamp(String time) {
        String year = time.substring(0, 4);
        String month = time.substring(5, 7);
        String day = time.substring(8, 10);
        String hour = time.substring(11, 13);
        String mi = time.substring(14, 16);
        String sec = time.substring(17, 19);
        String finaltime = String.valueOf(year) + month + day + hour + mi + sec;
        return finaltime;
    }
}

