/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtils {
    public static int DEFAULT_BUFFER_SIZE = 4096;

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = IOUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copyLarge(input, output, new byte[DEFAULT_BUFFER_SIZE]);
    }

    public static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void closeQuietly(InputStream in) throws IOException {
        if (in != null) {
            in.close();
        }
    }

    public static void closeQuietly(OutputStream os) throws IOException {
        if (os != null) {
            os.close();
        }
    }
}

