/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.utils;

import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.exception.KGElecDigitalSigVerifyException;
import com.kinggrid.exception.KGErrorSm2VerifyException;
import com.kinggrid.kgcore.gm.SM2;
import com.kinggrid.kgcore.gm.SealGM;
import com.kinggrid.kgcore.gm.SealUtil;
import com.kinggrid.pdf.executes.entity.SignSealInfo;
import com.kinggrid.pdf.signinter.TimeStampValidInter;
import com.kinggrid.pdf.utils.Asn1Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1EncodableVector;
import org.kg.bouncycastle.asn1.ASN1GeneralizedTime;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1Integer;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.ASN1Primitive;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.ASN1String;
import org.kg.bouncycastle.asn1.ASN1UTCTime;
import org.kg.bouncycastle.asn1.DERBitString;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DERSequence;
import org.kg.bouncycastle.asn1.DLSequence;
import org.kg.bouncycastle.asn1.x509.Certificate;
import org.kg.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.kg.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.kg.bouncycastle.asn1.x509.X509CertificateStructure;
import org.kg.bouncycastle.jce.provider.BouncyCastleProvider;

public class VerifySealUtil {
    private boolean Sm2 = true;
    private int version;
    private SignSealInfo sealinfo;
    private byte[] newDigest;
    private TimeStampValidInter timeStampValidInter;
    private int errorCode = 0;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public SignSealInfo getSealinfo() {
        return this.sealinfo;
    }

    public void setSealinfo(SignSealInfo sealinfo) {
        this.sealinfo = sealinfo;
    }

    public TimeStampValidInter getTimeStampValidInter() {
        return this.timeStampValidInter;
    }

    public void setTimeStampValidInter(TimeStampValidInter timeStampValidInter) {
        this.timeStampValidInter = timeStampValidInter;
    }

    public void verifySignatureStructure(SignSealInfo sealinfo, byte[] newDigest) throws IOException {
        this.sealinfo = sealinfo;
        this.newDigest = newDigest;
        this.version = Integer.valueOf(sealinfo.getHeaderVer());
        if (this.version == 4) {
            this.verifyV4();
        } else {
            this.verifyV2();
        }
    }

    private void verifyV4() throws IOException {
        byte[] signdata = this.sealinfo.getSignData();
        byte[] cert = this.sealinfo.getCert();
        byte[] tosigndata = this.sealinfo.getTosignData();
        byte[] hash = this.sealinfo.getHash();
        byte[] sealdata = this.sealinfo.getSesSignature();
        ASN1Sequence sequence = DERSequence.getInstance((Object)sealdata);
        if (signdata.length != 64) {
            signdata = Asn1Utils.sigDataAns1To64bit(signdata);
        }
        if (!this.asn1Complete(sequence)) {
            throw new KGElecDigitalSigVerifyException("\u9a8c\u8bc1\u7b7e\u7ae0\u7ed3\u6784\u4f53\u5b8c\u6574\u6027\u5931\u8d25\uff01errorCode:" + this.errorCode);
        }
        if (!this.sm2Verify(tosigndata, cert, signdata)) {
            throw new KGErrorSm2VerifyException("\u9a8c\u8bc1\u7b7e\u540d\u503c\u5931\u8d25\uff01");
        }
        if (!this.certMatchValid()) {
            throw new KGErrorSm2VerifyException("\u7b7e\u7ae0\u8005\u8bc1\u4e66\u4e0e\u7535\u5b50\u5370\u7ae0\u4e0d\u5339\u914d\uff01");
        }
        this.verifySeal(this.sealinfo.getEseal());
        if (!this.cerValid()) {
            throw new KGErrorSm2VerifyException("\u7b7e\u7ae0\u65f6\u95f4\u4e0d\u5728\u8bc1\u4e66\u6709\u6548\u671f\u5185\uff01");
        }
        if (!Arrays.equals(hash, this.newDigest)) {
            throw new KGErrorSm2VerifyException("\u9a8c\u8bc1\u5931\u8d25\uff0c\u6587\u6863\u5df2\u88ab\u7be1\u6539\uff01");
        }
        String timestamp = this.sealinfo.getTimeStamp();
        byte[] bresp = this.sealinfo.getTimeData();
        byte[] sign = this.sealinfo.getSignData();
        String signdate = this.sealinfo.getSignDate();
        if (!(this.timeStampValidInter == null || bresp == null || this.timeStampValidInter.valid(bresp, sign) && this.validsigndate(timestamp, signdate))) {
            throw new KGErrorSm2VerifyException("\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u5931\u8d25\uff0c\u9a8c\u8bc1\u65f6\u95f4\u6233\u5931\u8d25\uff01");
        }
    }

    private void verifyV2() throws IOException {
        byte[] signdata = this.sealinfo.getSignData();
        byte[] cert = this.sealinfo.getCert();
        byte[] tosigndata = this.sealinfo.getTosignData();
        byte[] hash = this.sealinfo.getHash();
        byte[] sealdata = this.sealinfo.getSesSignature();
        ASN1Sequence sequence = DERSequence.getInstance((Object)sealdata);
        if (signdata.length != 64) {
            signdata = Asn1Utils.sigDataAns1To64bit(signdata);
        }
        if (!this.asn1Complete(sequence)) {
            throw new KGElecDigitalSigVerifyException("\u9a8c\u8bc1\u7b7e\u7ae0\u7ed3\u6784\u4f53\u5b8c\u6574\u6027\u5931\u8d25\uff01errorCode:" + this.errorCode);
        }
        if (!this.sm2Verify(tosigndata, cert, signdata)) {
            throw new KGErrorSm2VerifyException("\u9a8c\u8bc1\u7b7e\u540d\u503c\u5931\u8d25\uff01");
        }
        this.verifySeal(this.sealinfo.getEseal());
        if (!this.cerValid()) {
            throw new KGErrorSm2VerifyException("\u7b7e\u7ae0\u65f6\u95f4\u4e0d\u5728\u8bc1\u4e66\u6709\u6548\u671f\u5185\uff01");
        }
        if (!Arrays.equals(hash, this.newDigest)) {
            throw new KGErrorSm2VerifyException("\u9a8c\u8bc1\u5931\u8d25\uff0c\u6587\u6863\u5df2\u88ab\u7be1\u6539\uff01");
        }
    }

    private boolean sm2Verify(byte[] msg, byte[] cert, byte[] signedData) throws IOException {
        TBSCertificateStructure tbsCert = VerifySealUtil.getTbsCert(cert);
        byte[] pk = VerifySealUtil.getPubkey(tbsCert);
        SM2 sm2 = new SM2(true);
        return sm2.Verify(msg, signedData, pk);
    }

    private static TBSCertificateStructure getTbsCert(byte[] cert) throws IOException {
        ASN1Sequence certSeq = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])cert);
        return TBSCertificateStructure.getInstance((Object)certSeq.getObjectAt(0));
    }

    private static byte[] getPubkey(TBSCertificateStructure tbsCert) {
        SubjectPublicKeyInfo subPublicKeyInfo = tbsCert.getSubjectPublicKeyInfo();
        byte[] pubkey = subPublicKeyInfo.getPublicKeyData().getBytes();
        byte[] pk = new byte[64];
        System.arraycopy(pubkey, 1, pk, 0, 64);
        return pk;
    }

    private boolean certMatchValid() {
        String certtype = this.sealinfo.getCertType();
        byte[] cert = this.sealinfo.getCert();
        DLSequence sequence = this.sealinfo.getCertList();
        int num = sequence.size();
        boolean flag = false;
        if (certtype.equals("1")) {
            byte[] cert_list = null;
            int i = 0;
            while (i < num) {
                cert_list = ((DEROctetString)sequence.getObjectAt(i)).getOctets();
                flag = Arrays.equals(cert, cert_list);
                if (flag) break;
                ++i;
            }
        }
        return flag;
    }

    public boolean cerValid() throws IOException {
        byte[] cert = this.sealinfo.getCert();
        ASN1Sequence seq = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])cert);
        Certificate certificate = Certificate.getInstance((Object)seq);
        String certSta = certificate.getStartDate().getTime();
        String certend = certificate.getEndDate().getTime();
        String signdate = this.sealinfo.getSignDate();
        if (this.version == 2) {
            signdate = "20" + signdate;
            signdate = signdate.substring(0, 14);
        } else {
            signdate = signdate.substring(0, 14);
        }
        long signDate = Long.parseLong(signdate);
        long startDate = Long.parseLong(certSta.substring(0, 14));
        long endDate = Long.parseLong(certend.substring(0, 14));
        return startDate <= signDate && endDate >= signDate;
    }

    public boolean validsigndate(String time, String signdate) {
        String signtime = signdate.substring(0, 14);
        String timestamp = time.substring(0, 14);
        Long newtimestamp = Long.parseLong(timestamp);
        Long newsigntime = Long.parseLong(signtime);
        return newsigntime <= newtimestamp;
    }

    public void verifySeal(byte[] sealData) throws IOException {
        ASN1Sequence signInfo = null;
        DEROctetString certString = null;
        DERBitString signDataString = null;
        byte[] toSignData = null;
        ASN1InputStream asn1InputStream = new ASN1InputStream(sealData);
        ASN1Sequence sequence = (ASN1Sequence)asn1InputStream.readObject();
        ASN1Sequence esealInfoSequence = (ASN1Sequence)sequence.getObjectAt(0);
        ASN1Sequence headerSequence = (ASN1Sequence)esealInfoSequence.getObjectAt(0);
        String sealID = ((ASN1String)headerSequence.getObjectAt(0)).toString();
        if (!sealID.equals("ES")) {
            throw new KGErrorSm2VerifyException("\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u5931\u8d25\uff1a\u5934\u6807\u8bc6\u9519\u8bef\uff01");
        }
        ASN1Integer version = (ASN1Integer)headerSequence.getObjectAt(1);
        this.version = version.getValue().intValue();
        if (this.version == 4) {
            certString = (DEROctetString)sequence.getObjectAt(1);
            signDataString = (DERBitString)sequence.getObjectAt(3);
            toSignData = esealInfoSequence.getEncoded();
        } else if (this.version == 2) {
            signInfo = (ASN1Sequence)sequence.getObjectAt(1);
            certString = (DEROctetString)signInfo.getObjectAt(0);
            signDataString = (DERBitString)signInfo.getObjectAt(2);
            ASN1EncodableVector toSign = new ASN1EncodableVector();
            toSign.add((ASN1Encodable)esealInfoSequence);
            toSign.add((ASN1Encodable)certString);
            toSign.add((ASN1Encodable)((ASN1ObjectIdentifier)signInfo.getObjectAt(1)));
            DERSequence toSignSequence = new DERSequence(toSign);
            toSignData = toSignSequence.getEncoded();
        } else {
            throw new KGErrorSm2VerifyException("\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u5931\u8d25\uff1a\u5370\u7ae0\u7248\u672c\u53f7\u9519\u8bef\uff01");
        }
        SealGM seal = SealUtil.getSealInfo(sealData);
        String algorithm = seal.getSignatureAlgorithm();
        this.checkAlgorithm(algorithm);
        byte[] certBytes = seal.getCert();
        ASN1InputStream certStream = new ASN1InputStream(certBytes);
        X509CertificateStructure cert = new X509CertificateStructure((ASN1Sequence)certStream.readObject());
        this.checkSigndata(cert, toSignData, seal.getSignData(), certBytes);
        this.checkCert(cert, seal.getCreateDate());
        this.checkStamp(esealInfoSequence);
    }

    private void checkSigndata(X509CertificateStructure cert, byte[] toSignData, byte[] signData, byte[] certByte) throws IOException {
        if (signData.length != 64) {
            signData = Asn1Utils.sigDataAns1To64bit(signData);
        }
        boolean result = false;
        if (this.Sm2) {
            byte[] byPuk = cert.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
            byte[] pk = new byte[64];
            System.arraycopy(byPuk, 1, pk, 0, 64);
            SM2 sm2 = new SM2(true);
            result = sm2.Verify(toSignData, signData, pk);
        } else {
            try {
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                X509Certificate certificate = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certByte));
                PublicKey publicKey = certificate.getPublicKey();
                Signature signature = Signature.getInstance("SHA1withRSA", (Provider)new BouncyCastleProvider());
                signature.initVerify(publicKey);
                signature.update(toSignData);
                result = signature.verify(signData);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException(e);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        if (!result) {
            throw new KGErrorSm2VerifyException("\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u5931\u8d25\uff1a\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u7b7e\u540d\u503c\u5931\u8d25\uff01");
        }
    }

    private void checkCert(X509CertificateStructure cert, Date date) {
        long startDate = Long.parseLong(cert.getStartDate().getTime().substring(2, 14));
        long endDate = Long.parseLong(cert.getEndDate().getTime().substring(2, 14));
        String format = KGDateUtils.format(date, "yyMMddHHmmss");
        long longDate = Long.parseLong(format);
        if (startDate > longDate || endDate < longDate) {
            throw new KGErrorSm2VerifyException("\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u5931\u8d25\uff1a\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u5236\u7ae0\u4eba\u8bc1\u4e66\u6709\u6548\u671f\u5931\u8d25, \u5236\u7ae0\u65f6\u95f4\u4e0d\u5728\u5236\u7ae0\u4eba\u8bc1\u4e66\u6709\u6548\u671f\u5185\uff01");
        }
    }

    private void checkStamp(ASN1Sequence esealInfoSequence) {
        String validStart = "";
        String validEnd = "";
        ASN1Sequence propertySequence = (ASN1Sequence)esealInfoSequence.getObjectAt(2);
        validStart = this.version == 4 ? ((ASN1GeneralizedTime)propertySequence.getObjectAt(5)).getTimeString() : ((ASN1UTCTime)propertySequence.getObjectAt(4)).toString();
        Long validStartLong = Long.parseLong(validStart.substring(0, validStart.length() - 1));
        validEnd = this.version == 4 ? ((ASN1GeneralizedTime)propertySequence.getObjectAt(6)).getTimeString() : ((ASN1UTCTime)propertySequence.getObjectAt(5)).toString();
        Long validEndLong = Long.parseLong(validEnd.substring(0, validEnd.length() - 1));
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmdd");
        if (validEnd.length() == 15) {
            sdf = new SimpleDateFormat("yyyyMMddHHmmdd");
        }
        long date = Long.parseLong(sdf.format(new Date()));
        date = Long.parseLong(sdf.format(new Date()));
        if (validStartLong > date || validEndLong < date) {
            throw new KGErrorSm2VerifyException("\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u5931\u8d25\uff1a\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u7684\u6709\u6548\u671f\u5931\u8d25\uff01");
        }
    }

    private void checkAlgorithm(String algorithm) throws IOException {
        this.Sm2 = algorithm.equals("1.2.156.10197.1.501") || algorithm.equals("1.2.156.10197.1.301");
    }

    public boolean asn1SealComplete(ASN1Sequence sequence) {
        int num = 0;
        String oid = "";
        ASN1Sequence esealInfoSequence = (ASN1Sequence)sequence.getObjectAt(0);
        ASN1Sequence sequencechild = (ASN1Sequence)esealInfoSequence.getObjectAt(0);
        ASN1Integer version = (ASN1Integer)sequencechild.getObjectAt(1);
        this.version = version.getValue().intValue();
        if (this.version == 4) {
            num = sequence.size();
            if (num != 4) {
                this.errorCode = 4;
                return false;
            }
            oid = ((ASN1ObjectIdentifier)sequence.getObjectAt(2)).toString();
            if (!oid.equals("1.2.156.10197.1.501")) {
                this.errorCode = 9;
                return false;
            }
            num = (sequence = (ASN1Sequence)sequence.getObjectAt(0)).size();
            if (num < 4 || num > 5) {
                this.errorCode = 5;
                return false;
            }
            sequencechild = (ASN1Sequence)sequence.getObjectAt(0);
            num = sequencechild.size();
            if (num != 3) {
                this.errorCode = 6;
                return false;
            }
            sequencechild = (ASN1Sequence)sequence.getObjectAt(2);
            num = sequencechild.size();
            if (num != 7) {
                this.errorCode = 7;
                return false;
            }
            sequencechild = (ASN1Sequence)sequence.getObjectAt(3);
            num = sequencechild.size();
            if (num != 4) {
                this.errorCode = 8;
                return false;
            }
        } else if (this.version == 2) {
            sequencechild = (ASN1Sequence)sequence.getObjectAt(1);
            oid = ((ASN1ObjectIdentifier)sequencechild.getObjectAt(1)).toString();
            if (!oid.equals("1.2.156.10197.1.501")) {
                this.errorCode = 9;
                return false;
            }
            ASN1Sequence sequenceseal = (ASN1Sequence)sequence.getObjectAt(0);
            num = sequenceseal.size();
            if (num != 5) {
                this.errorCode = 5;
                return false;
            }
            sequencechild = (ASN1Sequence)sequenceseal.getObjectAt(0);
            num = sequencechild.size();
            if (num != 3) {
                this.errorCode = 6;
                return false;
            }
            sequencechild = (ASN1Sequence)sequenceseal.getObjectAt(2);
            num = sequencechild.size();
            if (num != 6) {
                this.errorCode = 7;
                return false;
            }
            sequencechild = (ASN1Sequence)sequenceseal.getObjectAt(3);
            num = sequencechild.size();
            if (num != 4) {
                this.errorCode = 8;
                return false;
            }
        }
        return true;
    }

    public boolean asn1Complete(ASN1Sequence sequence) {
        String oid = "";
        int num = 0;
        if (!this.sealinfo.getHeaderVer().equals(this.sealinfo.getVersion())) {
            this.errorCode = 10;
            return false;
        }
        if (this.version == 4) {
            oid = ((ASN1ObjectIdentifier)sequence.getObjectAt(2)).toString();
            if (!oid.equals("1.2.156.10197.1.501")) {
                this.errorCode = 1;
                return false;
            }
            num = sequence.size();
            if (num < 4 || num > 5) {
                this.errorCode = 2;
                return false;
            }
            num = (sequence = (ASN1Sequence)sequence.getObjectAt(0)).size();
            if (num != 5) {
                this.errorCode = 3;
                return false;
            }
            sequence = (ASN1Sequence)sequence.getObjectAt(1);
            this.asn1SealComplete(sequence);
        } else if (this.version == 2) {
            num = sequence.size();
            if (num != 2) {
                this.errorCode = 2;
                return false;
            }
            oid = ((ASN1ObjectIdentifier)(sequence = (ASN1Sequence)sequence.getObjectAt(0)).getObjectAt(6)).toString();
            if (!oid.equals("1.2.156.10197.1.501")) {
                this.errorCode = 1;
                return false;
            }
            sequence = (ASN1Sequence)sequence.getObjectAt(1);
            this.asn1SealComplete(sequence);
        }
        return true;
    }
}

