/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.utils;

import com.KGitextpdf.text.pdf.PRIndirectReference;
import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfBoolean;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfString;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.executes.electronicseal.KGDefaultMessageDigest;
import com.kinggrid.pdf.executes.electronicseal.KGMessageDigest;
import com.kinggrid.pdf.utils.HashPDFDoc10;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.kg.bouncycastle.util.encoders.Hex;

public class KGPdfUtils {
    public static byte[] calculatePdfHash4Elec(PdfReader reader) {
        return KGPdfUtils.calculatePdfHash4Elec(reader, new KGDefaultMessageDigest());
    }

    public static byte[] calculatePdfHash4Elec(PdfReader reader, KGMessageDigest messageDigest) {
        try {
            String createTime = null;
            int k = 1;
            while (k <= reader.getNumberOfPages()) {
                PdfArray annots;
                PdfDictionary pdfDictionary = reader.getPageN(k);
                PdfObject pdfObject = pdfDictionary.get(PdfName.CONTENTS);
                byte[] content = null;
                if (pdfObject instanceof PdfArray) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    PdfArray arrays = (PdfArray)pdfObject;
                    int i = 0;
                    while (i < arrays.size()) {
                        byte[] cont = PdfReader.getStreamBytesRaw((PRStream)arrays.getAsStream(i));
                        if (cont != null) {
                            out.write(cont);
                        }
                        ++i;
                    }
                    content = out.toByteArray();
                } else {
                    content = PdfReader.getStreamBytesRaw((PRStream)pdfDictionary.getAsStream(PdfName.CONTENTS));
                }
                if (content != null) {
                    messageDigest.update(content);
                }
                if ((annots = reader.getPageN(k).getAsArray(PdfName.ANNOTS)) != null) {
                    int j = 0;
                    while (j < annots.size()) {
                        PdfName subtype;
                        PdfName ft;
                        PdfDictionary annot = annots.getAsDict(j);
                        if (!(annot == null || (ft = annot.getAsName(PdfName.FT)) != null && ft.equals(PdfName.SIG) || (subtype = annot.getAsName(PdfName.SUBTYPE)) != null && KGElectronicSealName.SEAL.equals(subtype))) {
                            String s1;
                            PdfString modifTime = annot.getAsString(PdfName.M);
                            if (modifTime != null) {
                                createTime = modifTime.toString();
                            }
                            if (createTime != null) {
                                Integer y = Integer.valueOf(createTime.substring(2, 6));
                                Integer m = Integer.valueOf(createTime.substring(6, 8));
                                Integer h = Integer.valueOf(createTime.substring(10, 12));
                                Integer nin = Integer.valueOf(createTime.substring(12, 14));
                                Integer sec = Integer.valueOf(createTime.substring(14, 16));
                                s1 = String.valueOf(y.toString()) + "-" + m.toString() + "-0 " + h.toString() + ":" + nin.toString() + ":" + sec.toString() + ":0\r\n";
                            } else {
                                s1 = "Error\r\n";
                            }
                            messageDigest.update(s1.getBytes("GBK"));
                        }
                        ++j;
                    }
                }
                ++k;
            }
            return messageDigest.digest();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static String calc10NewHash(PdfDictionary annot, String strMd5, KGMessageDigest messageDigest) throws IOException {
        return KGPdfUtils.calc10NewHash(null, annot, strMd5, messageDigest, false, null);
    }

    public static String calc10NewHash(PdfReader reader, PdfDictionary annot, String strMd5, KGMessageDigest messageDigest, boolean digestStream, LinkedHashMap<Integer, PdfIndirectReference> refsMap) throws IOException {
        messageDigest.update(strMd5.getBytes());
        if (digestStream) {
            for (Map.Entry<Integer, PdfIndirectReference> entry : refsMap.entrySet()) {
                PdfIndirectReference ref = entry.getValue();
                PdfObject refObj = PdfReader.getPdfObject(ref);
                HashPDFDoc10.hashObject(refObj, 2, false, reader, messageDigest, digestStream, null);
            }
        }
        KGPdfUtils.calcAnnotHash(annot, messageDigest, digestStream);
        PdfArray childlist = annot.getAsArray(KGElectronicSealName.CHILDLIST);
        if (childlist != null) {
            int i = 1;
            while (i < childlist.size()) {
                PRIndirectReference annotRef = (PRIndirectReference)childlist.getAsIndirectObject(i);
                PdfDictionary annotDic = (PdfDictionary)PdfReader.getPdfObject(annotRef);
                KGPdfUtils.calcAnnotHash(annotDic, messageDigest, digestStream);
                i += 2;
            }
        }
        PdfDictionary info = annot.getAsDict(PdfName.INFO);
        PRStream baseInfo = (PRStream)info.getAsStream(KGElectronicSealName.BASEINFO);
        byte[] baseInfob = PdfReader.getStreamBytes(baseInfo);
        messageDigest.update(baseInfob);
        return new String(Hex.encode((byte[])messageDigest.digest()));
    }

    private static void calcAnnotHash(PdfDictionary annot, KGMessageDigest messageDigest, boolean digestStream) throws IOException {
        PdfDictionary xobject;
        byte[] img0Bytes;
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        PdfArray rect = annot.getAsArray(PdfName.RECT);
        String annotRect = String.valueOf(decimalFormat.format(rect.getAsNumber(0).floatValue())) + " " + decimalFormat.format(rect.getAsNumber(1).floatValue()) + " " + decimalFormat.format(rect.getAsNumber(2).floatValue()) + " " + decimalFormat.format(rect.getAsNumber(3).floatValue());
        messageDigest.update(annotRect.getBytes());
        PdfStream n = annot.getAsDict(PdfName.AP).getAsStream(PdfName.N);
        PdfArray bboxArray = n.getAsArray(PdfName.BBOX);
        String bbox = String.valueOf(decimalFormat.format(bboxArray.getAsNumber(0).floatValue())) + " " + decimalFormat.format(bboxArray.getAsNumber(1).floatValue()) + " " + decimalFormat.format(bboxArray.getAsNumber(2).floatValue()) + " " + decimalFormat.format(bboxArray.getAsNumber(3).floatValue());
        messageDigest.update(bbox.getBytes());
        PdfArray matrixArray = n.getAsArray(PdfName.MATRIX);
        String matrix = String.valueOf(matrixArray.getAsNumber(0).intValue()) + " " + matrixArray.getAsNumber(1).intValue() + " " + matrixArray.getAsNumber(2).intValue() + " " + matrixArray.getAsNumber(3).intValue() + " " + matrixArray.getAsNumber(4).intValue() + " " + matrixArray.getAsNumber(5).intValue();
        messageDigest.update(matrix.getBytes());
        if (digestStream) {
            PRStream stream = (PRStream)PdfReader.getPdfObject(n.getIndRef());
            messageDigest.update(PdfReader.getStreamBytesRaw(stream));
        }
        if ((img0Bytes = KGPdfUtils.getImageData(xobject = n.getAsDict(PdfName.RESOURCES).getAsDict(PdfName.XOBJECT))) == null) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u5370\u7ae0\u6570\u636e");
        }
        messageDigest.update(img0Bytes);
    }

    private static byte[] getImageData(PdfDictionary xobject) throws IOException {
        Set<Map.Entry<PdfName, PdfObject>> set = xobject.getKeyValSet();
        Iterator<Map.Entry<PdfName, PdfObject>> iterator = set.iterator();
        byte[] imageData = null;
        while (iterator.hasNext()) {
            Map.Entry<PdfName, PdfObject> entry = iterator.next();
            PRIndirectReference indirect = (PRIndirectReference)entry.getValue();
            PRStream val = (PRStream)PdfReader.getPdfObject(indirect);
            PdfName subtype = val.getAsName(PdfName.SUBTYPE);
            if (subtype != null && "/Image".equals(subtype.toString())) {
                imageData = PdfReader.getStreamBytesRaw(val);
                break;
            }
            PdfDictionary _xobject = val.getAsDict(PdfName.RESOURCES).getAsDict(PdfName.XOBJECT);
            if (_xobject != null && (imageData = KGPdfUtils.getImageData(_xobject)) != null) break;
        }
        return imageData;
    }

    public static String calculatePdfDoc104Elec(PdfReader reader) {
        return KGPdfUtils.calculatePdfDoc104Elec(reader, new KGDefaultMessageDigest());
    }

    @Deprecated
    public static String calculatePdfDoc104Elec(PdfReader reader, KGMessageDigest messageDigest) {
        return KGPdfUtils.calculatePdfDoc104Elec(reader, messageDigest, false, null);
    }

    public static String calculatePdfDoc104Elec(PdfReader reader, KGMessageDigest messageDigest, boolean digestStream, LinkedHashMap<Integer, PdfIndirectReference> refsMap) {
        try {
            return HashPDFDoc10.getHash(reader, messageDigest, digestStream, refsMap);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static byte[] calculatePdfDoc104ElecByte(PdfReader reader, KGMessageDigest messageDigest) {
        try {
            return HashPDFDoc10.getHashByte(reader, messageDigest);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> parseSeal(PdfDictionary annot) throws IOException {
        Map<String, String> map = null;
        PdfDictionary info = annot.getAsDict(PdfName.INFO);
        if (info != null) {
            PdfNumber proversion = info.getAsNumber(KGElectronicSealName.PROVERSION);
            PdfBoolean unicode = info.getAsBoolean(KGElectronicSealName.UNICODE);
            PdfNumber hashType = info.getAsNumber(KGElectronicSealName.HASH_TYPE);
            boolean isUnicode = false;
            if (unicode != null) {
                isUnicode = unicode.booleanValue();
            }
            String charSet = "GBK";
            if (isUnicode) {
                charSet = "UTF-16LE";
            }
            PRStream baseInfo = (PRStream)info.getAsStream(KGElectronicSealName.BASEINFO);
            byte[] baseInfob = PdfReader.getStreamBytes(baseInfo);
            KGBase64 base64 = new KGBase64();
            base64.setBase64Table("=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
            String sealDetail = new String(base64.decode(new String(baseInfob)), charSet);
            map = KGPdfUtils.getBaseInfo(sealDetail);
            map.put("proversion", String.valueOf(proversion.intValue()));
            if (hashType != null) {
                map.put("hashType", String.valueOf(hashType.intValue()));
            }
        }
        return map;
    }

    public static Map<String, String> getBaseInfo(String string) {
        String[] strings;
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = strings = string.split("\r\n");
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            int indx = str.indexOf("=");
            if (indx != -1) {
                map.put(str.substring(0, indx), str.substring(indx + 1));
            }
            ++n2;
        }
        return map;
    }

    public static Map<String, Float> RotationXY(float x, float y, float width, float height, int rotation) {
        float tmp = x;
        if (rotation == 90) {
            x = y;
            y = width - tmp;
        } else if (rotation == 180) {
            x = width - x;
            y = height - y;
        } else if (rotation == 270) {
            x = height - y;
            y = tmp;
        }
        HashMap<String, Float> map = new HashMap<String, Float>();
        map.put("x", Float.valueOf(x));
        map.put("y", Float.valueOf(y));
        return map;
    }
}

