/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.utils;

import com.alibaba.fastjson.JSONObject;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.exception.KGServerInterfaceErrorException;
import com.kinggrid.kgcore.HttpUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.kg.bouncycastle.util.encoders.Hex;

public class ConnectStampSystemUtil {
    private String url;
    private String salt;
    private String appid;
    private String esid;
    private String orderId;
    private String title;
    private String doSm3;
    private String qrCodeUid;

    public ConnectStampSystemUtil(String url, String salt, String appid, String esid) {
        this.url = url;
        this.salt = salt;
        this.appid = appid;
        this.esid = esid;
    }

    public ConnectStampSystemUtil(String url, String salt, String appid, String esid, String orderId, String title) {
        this(url, salt, appid, esid);
        this.orderId = orderId;
        this.title = title;
    }

    public ConnectStampSystemUtil(String url, String salt, String appid, String esid, String orderId, String title, String doSm3) {
        this(url, salt, appid, esid, orderId, title);
        this.doSm3 = doSm3;
    }

    public void setQrCodeUid(String qrCodeUid) {
        this.qrCodeUid = qrCodeUid;
    }

    public JSONObject textSign(byte[] message) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        HttpUtil httpUtil;
        String result;
        JSONObject retObj;
        String textSignUrl = String.valueOf(this.url) + "/api/textSign";
        String randomN = this.getRandomN();
        KGBase64 base64 = new KGBase64();
        JSONObject jObject = new JSONObject();
        jObject.put("appid", (Object)this.appid);
        jObject.put("randomN", (Object)randomN);
        jObject.put("checkCode", (Object)this.getCheckCode64(randomN));
        jObject.put("sealCode", (Object)this.esid);
        jObject.put("orderId", (Object)this.orderId);
        jObject.put("title", (Object)this.title);
        jObject.put("base64Content", (Object)base64.encode(message));
        if (this.doSm3 != null && this.doSm3.length() > 0) {
            jObject.put("sm3", (Object)this.doSm3);
        }
        if (this.qrCodeUid != null && this.qrCodeUid.length() > 0) {
            jObject.put("qrCodeUid", (Object)this.qrCodeUid);
        }
        if (!"0".equals((retObj = JSONObject.parseObject((String)(result = (httpUtil = new HttpUtil()).getResult(textSignUrl, jObject)))).getString("code"))) {
            throw new KGServerInterfaceErrorException("\u4ece\u7535\u5b50\u5370\u7ae0\u7cfb\u7edf\u83b7\u53d6\u7b7e\u540d\u503c\u5f02\u5e38, code=" + retObj.getString("code") + ", message:" + retObj.getString("message"));
        }
        return retObj;
    }

    public JSONObject getSealByEsid() throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String getSealUrl = String.valueOf(this.url) + "/api/getSealByEsid";
        String randomN = this.getRandomN();
        JSONObject jObject = new JSONObject();
        jObject.put("esid", (Object)this.esid);
        jObject.put("appid", (Object)this.appid);
        jObject.put("randomN", (Object)randomN);
        jObject.put("checkCode", (Object)this.getCheckCode64(randomN));
        HttpUtil httpUtil = new HttpUtil();
        String result = httpUtil.getResult(getSealUrl, jObject);
        JSONObject retObj = JSONObject.parseObject((String)result);
        if (!"0".equals(retObj.getString("code"))) {
            throw new KGServerInterfaceErrorException("\u4ece\u7535\u5b50\u5370\u7ae0\u7cfb\u7edf\u83b7\u53d6\u5370\u7ae0\u5f02\u5e38, code=" + retObj.getString("code") + ", message:" + retObj.getString("message"));
        }
        return retObj;
    }

    public String getRandomN() {
        String randomNUrl = String.valueOf(this.url) + "/api/randomN";
        JSONObject jObject = new JSONObject();
        jObject.put("appid", (Object)this.appid);
        HttpUtil httpUtil = new HttpUtil();
        String ret = httpUtil.getResult(randomNUrl, jObject);
        JSONObject retObj = JSONObject.parseObject((String)ret);
        if (!"0".equals(retObj.getString("code"))) {
            throw new KGServerInterfaceErrorException("\u4ece\u7535\u5b50\u5370\u7ae0\u5e94\u7528\u7cfb\u7edf\u83b7\u53d6\u968f\u673a\u6570\u5f02\u5e38, code=" + retObj.getString("code") + ", message:" + retObj.getString("message"));
        }
        return retObj.getString("randomN");
    }

    private String getCheckCode64(String randomN) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        KGBase64 base64 = new KGBase64();
        return base64.encode(this.getSHA256Hex(String.valueOf(randomN) + this.salt).getBytes("UTF-8"));
    }

    private String getSHA256Hex(String inputStr) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(inputStr.getBytes("UTF-8"));
        byte[] result = messageDigest.digest();
        return new String(Hex.encode((byte[])result));
    }
}

