/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.utils;

import java.io.IOException;
import java.math.BigInteger;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1EncodableVector;
import org.kg.bouncycastle.asn1.ASN1Integer;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERSequence;

public class Asn1Utils {
    public static byte[] sigDataAns1To64bit(byte[] signData) throws IOException {
        int srcPos;
        int dest;
        ASN1Sequence sequense = ASN1Sequence.getInstance((Object)signData);
        ASN1Integer ans1Int0 = (ASN1Integer)sequense.getObjectAt(0);
        ASN1Integer ans1Int1 = (ASN1Integer)sequense.getObjectAt(1);
        byte[] sig1 = ans1Int0.getValue().toByteArray();
        byte[] sig2 = ans1Int1.getValue().toByteArray();
        byte[] buff = new byte[64];
        if (sig1.length < 32) {
            dest = 32 - sig1.length;
            System.arraycopy(sig1, 0, buff, dest, sig1.length);
        } else {
            srcPos = sig1.length == 32 ? 0 : sig1.length - 32;
            System.arraycopy(sig1, srcPos, buff, 0, 32);
        }
        if (sig2.length < 32) {
            dest = 32 - sig2.length;
            System.arraycopy(sig2, 0, buff, dest, sig2.length);
        } else {
            srcPos = sig2.length == 32 ? 0 : sig2.length - 32;
            System.arraycopy(sig2, srcPos, buff, 32, 32);
        }
        return buff;
    }

    public static byte[] sigData64bit2Ans1(byte[] signData) throws IOException {
        byte[] s;
        byte[] r;
        if (signData[0] < 0) {
            r = new byte[33];
            System.arraycopy(signData, 0, r, 1, 32);
        } else {
            r = new byte[32];
            System.arraycopy(signData, 0, r, 0, 32);
        }
        if (signData[32] < 0) {
            s = new byte[33];
            System.arraycopy(signData, 32, s, 1, 32);
        } else {
            s = new byte[32];
            System.arraycopy(signData, 32, s, 0, 32);
        }
        ASN1EncodableVector encodable = new ASN1EncodableVector();
        encodable.add((ASN1Encodable)new ASN1Integer(new BigInteger(r)));
        encodable.add((ASN1Encodable)new ASN1Integer(new BigInteger(s)));
        DERSequence sequence = new DERSequence(encodable);
        return sequence.getEncoded();
    }
}

