/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.utils;

import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.pdf.executes.entity.SignSealInfo;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.kg.bouncycastle.asn1.ASN1GeneralizedTime;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1OctetString;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.ASN1String;
import org.kg.bouncycastle.asn1.ASN1TaggedObject;
import org.kg.bouncycastle.asn1.ASN1UTCTime;
import org.kg.bouncycastle.asn1.DERBitString;
import org.kg.bouncycastle.asn1.DERIA5String;
import org.kg.bouncycastle.asn1.DERInteger;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DERTaggedObject;
import org.kg.bouncycastle.asn1.DLSequence;

public class AnalyticalSealUtil {
    public static SignSealInfo sealinfo(ASN1Sequence sequence) {
        SignSealInfo signSealInfo = new SignSealInfo();
        try {
            signSealInfo.setSesSignature(sequence.getEncoded());
            ASN1Sequence toSign = (ASN1Sequence)sequence.getObjectAt(0);
            signSealInfo.setTosignData(toSign.getEncoded());
            DERBitString sm3hash = (DERBitString)toSign.getObjectAt(3);
            byte[] sm3data = sm3hash.getBytes();
            signSealInfo.setHash(sm3data);
            ASN1Sequence eseal = (ASN1Sequence)toSign.getObjectAt(1);
            signSealInfo.setEseal(eseal.getEncoded());
            String sealVer = ((DERInteger)toSign.getObjectAt(0)).toString();
            signSealInfo.setVersion(sealVer);
            ASN1Sequence esealInfo = (ASN1Sequence)eseal.getObjectAt(0);
            ASN1Sequence header = (ASN1Sequence)esealInfo.getObjectAt(0);
            ASN1Sequence property = (ASN1Sequence)esealInfo.getObjectAt(2);
            ASN1Sequence picture = (ASN1Sequence)esealInfo.getObjectAt(3);
            DERIA5String esidstring = (DERIA5String)esealInfo.getObjectAt(1);
            String esid = esidstring.getString();
            signSealInfo.setEsId(esid);
            DERInteger signType = (DERInteger)header.getObjectAt(1);
            String ver = signType.toString();
            signSealInfo.setHeaderVer(ver);
            String sealID = ((ASN1String)header.getObjectAt(0)).getString();
            signSealInfo.setHeaderbs(sealID);
            String sealVid = ((ASN1String)header.getObjectAt(2)).getString();
            signSealInfo.setHeaderfacVer(sealVid);
            DERIA5String picType = (DERIA5String)picture.getObjectAt(0);
            DEROctetString picData = (DEROctetString)picture.getObjectAt(1);
            DERInteger width = (DERInteger)picture.getObjectAt(2);
            DERInteger height = (DERInteger)picture.getObjectAt(3);
            signSealInfo.setPicData(picData.getOctets());
            DERInteger dertype = (DERInteger)property.getObjectAt(0);
            String type = dertype.toString();
            signSealInfo.setSealType(type);
            String sealName = ((ASN1String)property.getObjectAt(1)).getString();
            signSealInfo.setSealName(sealName);
            Date date = null;
            byte[] signData = null;
            String signDate = "";
            byte[] certData = null;
            if (ver.equals("4")) {
                ASN1GeneralizedTime create = (ASN1GeneralizedTime)property.getObjectAt(4);
                date = create.getDate();
                String createDate = KGDateUtils.date(date);
                signSealInfo.setCreateDate(createDate);
                ASN1GeneralizedTime start = (ASN1GeneralizedTime)property.getObjectAt(5);
                date = start.getDate();
                String validStart = KGDateUtils.date(date);
                signSealInfo.setValidStart(validStart);
                ASN1GeneralizedTime end = (ASN1GeneralizedTime)property.getObjectAt(6);
                date = end.getDate();
                String validEnd = KGDateUtils.date(date);
                signSealInfo.setValidEnd(validEnd);
                DERInteger ctype = (DERInteger)property.getObjectAt(2);
                String certtype = ctype.toString();
                signSealInfo.setCertType(certtype);
                DLSequence certseq = (DLSequence)property.getObjectAt(3);
                signSealInfo.setCertList(certseq);
                signData = ((DERBitString)sequence.getObjectAt(3)).getBytes();
                ASN1GeneralizedTime signtime = (ASN1GeneralizedTime)toSign.getObjectAt(2);
                signDate = signtime.getTimeString();
                certData = ((DEROctetString)sequence.getObjectAt(1)).getOctets();
                int num = sequence.size();
                if (num == 5) {
                    DERBitString timeData = (DERBitString)sequence.getObjectAt(4);
                    signSealInfo.setTimeStamp(AnalyticalSealUtil.getTimeStamp(sequence));
                    if (timeData != null) {
                        signSealInfo.setTimeData(timeData.getBytes());
                    }
                }
                signSealInfo.setSignData(signData);
                signSealInfo.setSignDate(signDate);
                signSealInfo.setCert(certData);
            } else {
                date = ((ASN1UTCTime)property.getObjectAt(3)).getAdjustedDate();
                String createDate = KGDateUtils.date(date);
                signSealInfo.setCreateDate(createDate);
                date = ((ASN1UTCTime)property.getObjectAt(4)).getAdjustedDate();
                String validStart = KGDateUtils.date(date);
                signSealInfo.setValidStart(validStart);
                date = ((ASN1UTCTime)property.getObjectAt(5)).getAdjustedDate();
                String validEnd = KGDateUtils.date(date);
                signSealInfo.setValidEnd(validEnd);
                DLSequence certseq = (DLSequence)property.getObjectAt(2);
                signSealInfo.setCertList(certseq);
                signData = ((DERBitString)sequence.getObjectAt(1)).getBytes();
                signDate = new String(((DERBitString)toSign.getObjectAt(2)).getBytes());
                certData = ((DEROctetString)toSign.getObjectAt(5)).getOctets();
                signSealInfo.setSignData(signData);
                signSealInfo.setSignDate(signDate);
                signSealInfo.setCert(certData);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return signSealInfo;
    }

    public static String getTimeStamp(ASN1Sequence sequence) {
        DERBitString timeseq = (DERBitString)sequence.getObjectAt(4);
        byte[] data = timeseq.getBytes();
        ASN1Sequence sequencetime = null;
        ASN1InputStream asn1In = null;
        DERTaggedObject taggedObject = null;
        String timestamp = "";
        try {
            asn1In = new ASN1InputStream(data);
            sequencetime = (ASN1Sequence)asn1In.readObject();
            sequencetime = (ASN1Sequence)sequencetime.getObjectAt(1);
            taggedObject = (DERTaggedObject)sequencetime.getObjectAt(1);
            sequencetime = ASN1Sequence.getInstance((ASN1TaggedObject)taggedObject, (boolean)false);
            sequencetime = (ASN1Sequence)sequencetime.getObjectAt(0);
            sequencetime = (ASN1Sequence)sequencetime.getObjectAt(2);
            taggedObject = (DERTaggedObject)sequencetime.getObjectAt(1);
            ASN1OctetString oct = ASN1OctetString.getInstance((ASN1TaggedObject)taggedObject, (boolean)false);
            data = oct.getOctets();
            asn1In = new ASN1InputStream(data);
            sequencetime = (ASN1Sequence)asn1In.readObject();
            ASN1GeneralizedTime time = (ASN1GeneralizedTime)sequencetime.getObjectAt(4);
            timestamp = time.getTimeString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return timestamp;
    }
}

