/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.utils;

import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfString;
import com.kinggrid.encrypt.KGBase64;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AnalysisStamperParam {
    private List<String> stampParamList;
    private String filename;

    public AnalysisStamperParam(String filename) {
        this.filename = filename;
    }

    public List<String> Analysis() throws IOException {
        PdfReader pdfReader = new PdfReader(this.filename);
        int num = pdfReader.getNumberOfPages();
        this.stampParamList = new ArrayList<String>();
        int j = 0;
        while (j < num) {
            PdfDictionary page = pdfReader.getPageN(j + 1);
            PdfArray annots = page.getAsArray(PdfName.ANNOTS);
            if (annots != null) {
                int i = 0;
                while (i < annots.size()) {
                    PdfString pdfString;
                    PdfDictionary annot = annots.getAsDict(i);
                    PdfName subType = annot.getAsName(PdfName.SUBTYPE);
                    if (annot != null && subType != null && subType.compareTo(new PdfName("prepareStamp")) == 0 && (pdfString = annot.getAsString(new PdfName("AnnotExtParam"))) != null) {
                        KGBase64 base64 = new KGBase64();
                        String decodeExtParam = new String(base64.decode(pdfString.toString()), "UTF-8");
                        String isQfz = this.getIsQfz(decodeExtParam);
                        if (isQfz.equals("true")) {
                            this.stampParamList.add(decodeExtParam);
                        } else if (this.stampParamList.indexOf("NoQFZ") < 0) {
                            this.stampParamList.add("NoQFZ");
                        }
                    }
                    ++i;
                }
            }
            ++j;
        }
        pdfReader.close();
        return this.stampParamList;
    }

    public String getIsQfz(String extParam) {
        String[] split = extParam.split(";");
        return split[0].split(":")[1];
    }
}

