/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.signinter;

import com.alibaba.fastjson.JSONArray;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.kgcore.KGHttpUtils;
import com.kinggrid.pdf.signinter.DigitalSignatureSM2;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;

public class DigitalSignatureSM2ByServer
extends DigitalSignatureSM2 {
    private static final String ENCRYPTIONAL_GORITHM = "SM2";
    private String url;
    private String keySN;
    private byte[] certBytes;
    private Object[] chainArray;
    private String signSN;
    private KGHttpUtils httpUtils = new KGHttpUtils();

    public DigitalSignatureSM2ByServer(String url, String keySN) {
        this.url = url;
        this.keySN = keySN;
    }

    @Override
    public byte[] sign(byte[] message) throws GeneralSecurityException {
        Map<String, Object> map = this.httpUtils.sign(this.url, this.keySN, this.signSN, message, ENCRYPTIONAL_GORITHM);
        String chainContent = (String)map.get("chain");
        if (chainContent != null && !"".equals(chainContent)) {
            JSONArray jsonArray = (JSONArray)JSONArray.parse((String)chainContent);
            this.chainArray = jsonArray.toArray();
        }
        this.certBytes = (byte[])map.get("certBytes");
        return (byte[])map.get("signData");
    }

    @Override
    public X509Certificate[] getCertificate() {
        if (this.certBytes == null) {
            Map<String, Object> map = this.httpUtils.sign(this.url, this.keySN, "1".getBytes(), ENCRYPTIONAL_GORITHM);
            this.certBytes = (byte[])map.get("certBytes");
            String chainContent = (String)map.get("chain");
            if (chainContent != null && !"".equals(chainContent)) {
                JSONArray jsonArray = (JSONArray)JSONArray.parse((String)chainContent);
                this.chainArray = jsonArray.toArray();
            }
        }
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509", "KGBC");
            X509Certificate[] x509Certificates = null;
            X509Certificate x509Certificate = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(this.certBytes));
            if (this.chainArray == null) {
                x509Certificates = new X509Certificate[]{x509Certificate};
            } else {
                KGBase64 base64 = new KGBase64();
                x509Certificates = new X509Certificate[this.chainArray.length];
                int i = 0;
                while (i < this.chainArray.length) {
                    X509Certificate x509Cer;
                    x509Certificates[i] = x509Cer = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(base64.decode((String)this.chainArray[i])));
                    ++i;
                }
            }
            return x509Certificates;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getSignSN() {
        return this.signSN;
    }

    public void setSignSN(String signSN) {
        this.signSN = signSN;
    }
}

