/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.signinter;

import com.alibaba.fastjson.JSONArray;
import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.kgcore.KGHttpUtils;
import com.kinggrid.pdf.signinter.DigitalSignature;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;

public class DigitalSignatureByServer
implements DigitalSignature {
    private static final String DEFAULT_ENCRYPTIONALGORITHM = "RSA";
    private static final String DEFAULT_HASHALGORITHM = "SHA-1";
    private String encryptionAlgorithm = "RSA";
    private String hashAlgorithm = "SHA-1";
    private String url;
    private String keySN;
    private String signSN;
    private X509Certificate[] x509Certificates;
    private KGHttpUtils httpUtils = new KGHttpUtils();
    private String startTime;
    private String endTime;

    public DigitalSignatureByServer(String url, String keySN) {
        this.url = url;
        this.keySN = keySN;
    }

    @Override
    public byte[] sign(byte[] message) throws GeneralSecurityException {
        Map<String, Object> map = this.httpUtils.sign(this.url, this.keySN, this.signSN, message, this.encryptionAlgorithm);
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        if (map.get("chain") != null && !"".equals(map.get("chain"))) {
            String chainContent = (String)map.get("chain");
            Object[] chainArray = JSONArray.parseArray((String)chainContent).toArray();
            this.x509Certificates = new X509Certificate[chainArray.length];
            KGBase64 base64 = new KGBase64();
            int i = 0;
            while (i < chainArray.length) {
                X509Certificate x509Certificate;
                this.x509Certificates[i] = x509Certificate = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(base64.decode((String)chainArray[i])));
                ++i;
            }
        } else {
            X509Certificate x509Certificate = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream((byte[])map.get("certBytes")));
            this.startTime = KGDateUtils.dateTime(x509Certificate.getNotBefore());
            this.endTime = KGDateUtils.dateTime(x509Certificate.getNotAfter());
            this.x509Certificates = new X509Certificate[]{x509Certificate};
        }
        return (byte[])map.get("signData");
    }

    @Override
    public X509Certificate[] getCertificate() {
        return this.x509Certificates;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    @Override
    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @Override
    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String getSignSN() {
        return this.signSN;
    }

    public void setSignSN(String signSN) {
        this.signSN = signSN;
    }
}

