/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.signinter;

import com.alibaba.fastjson.JSONObject;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.signinter.DigitalSignatureCertBytes;
import com.kinggrid.pdf.utils.ConnectStampSystemUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.kg.bouncycastle.asn1.ASN1Primitive;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DEROctetString;

public class DigitalSignatureByGB
implements DigitalSignatureCertBytes {
    private String url;
    private String salt;
    private String appid;
    private String sealCode;
    private String orderId;
    private String title;
    private byte[] cert;
    private byte[] sesSignature;
    private String doSm3 = "1";
    private String qrCodeUid;

    public DigitalSignatureByGB(String url, String salt, String appid, String sealCode, String orderId, String title) {
        this.url = url;
        this.salt = salt;
        this.appid = appid;
        this.sealCode = sealCode;
        this.orderId = orderId;
        this.title = title;
    }

    @Override
    public String getHashAlgorithm() {
        return "SM3";
    }

    @Override
    public String getEncryptionAlgorithm() {
        return "SM2";
    }

    @Override
    public byte[] sign(byte[] message) throws GeneralSecurityException {
        try {
            ConnectStampSystemUtil cUtil = new ConnectStampSystemUtil(this.url, this.salt, this.appid, this.sealCode, this.orderId, this.title, this.doSm3);
            cUtil.setQrCodeUid(this.qrCodeUid);
            JSONObject retObj = cUtil.textSign(message);
            String sigData = retObj.getString("sigData");
            KGBase64 base64 = new KGBase64();
            byte[] sign = base64.decode(sigData);
            ASN1Sequence signSeq = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])sign);
            DEROctetString certString = (DEROctetString)signSeq.getObjectAt(1);
            this.cert = certString.getOctets();
            return sigData.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public X509Certificate[] getCertificate() {
        X509Certificate[] x509Certificates = null;
        if (this.cert != null) {
            X509Certificate x509Certificate = null;
            try {
                CertificateFactory factory = CertificateFactory.getInstance("X.509", "KGBC");
                x509Certificate = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(this.cert));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            x509Certificates = new X509Certificate[]{x509Certificate};
        }
        return x509Certificates;
    }

    @Override
    public byte[] getCert() {
        return this.cert;
    }

    public byte[] getSesSignature() {
        return this.sesSignature;
    }

    public void setSesSignature(byte[] sesSignature) {
        this.sesSignature = sesSignature;
    }

    public void setDoSm3(String doSm3) {
        this.doSm3 = doSm3;
    }

    public void setQrCodeUid(String qrCodeUid) {
        this.qrCodeUid = qrCodeUid;
    }
}

