/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.exporter;

import com.KGitextpdf.text.Chunk;
import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.PageSize;
import com.KGitextpdf.text.Paragraph;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PdfContentByte;
import com.KGitextpdf.text.pdf.PdfGState;
import com.KGitextpdf.text.pdf.PdfPTable;
import com.KGitextpdf.text.pdf.PdfTemplate;
import com.KGitextpdf.text.pdf.PdfWriter;
import com.kinggrid.authorization.AuthorizationMethod;
import com.kinggrid.authorization.KGFacadeCglib;
import com.kinggrid.pdf.exporter.HeaderFooter;
import com.kinggrid.pdf.exporter.KGChunk;
import com.kinggrid.pdf.exporter.KGPdfPCell;
import com.kinggrid.pdf.exporter.PageBackgroundImage;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class KGPdfExporter {
    private PdfWriter pdfWriter = null;
    private com.KGitextpdf.text.Document document = null;
    private String version;
    private String fontName;
    private HeaderFooter headerFooter;
    private Element header;
    private Element footer;
    private PdfTemplate totalPage;
    private float[] pagemargin;
    private String content;

    protected KGPdfExporter() {
    }

    public static KGPdfExporter getInstance() {
        return (KGPdfExporter)KGFacadeCglib.getInstance(KGPdfExporter.class);
    }

    public void loadObject(String content) {
        this.content = content;
    }

    public void loadObjectFromFile(String fileName) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(fileName);
            byte[] bytes = new byte[fileInputStream.available()];
            fileInputStream.read(bytes);
            this.content = new String(bytes, "UTF-8");
        }
        finally {
            this.close(fileInputStream);
        }
    }

    @AuthorizationMethod(authEx=true)
    public void export(OutputStream os) throws org.dom4j.DocumentException, DocumentException, IOException {
        Document document4j = DocumentHelper.parseText((String)this.content);
        Element root = document4j.getRootElement();
        this.version = root.attributeValue("version");
        this.fontName = root.attributeValue("fontName");
        this.document = this.getPage(root);
        this.pdfWriter = PdfWriter.getInstance(this.document, os);
        if (this.isNotBlank(root.attributeValue("backgroundImage"))) {
            this.pdfWriter.setPageEvent(new PageBackgroundImage(root.attributeValue("backgroundImage")));
        }
        List elements = root.elements();
        int i = 0;
        while (i < elements.size()) {
            Element element = (Element)elements.get(i);
            String elementName = element.getName();
            if ("4.0".equals(this.version)) {
                if ("header".equalsIgnoreCase(elementName)) {
                    this.header = element;
                    elements.remove(i--);
                } else if ("footer".equalsIgnoreCase(elementName)) {
                    this.footer = element;
                    elements.remove(i--);
                }
            } else if ("table".equalsIgnoreCase(elementName)) {
                String flag = element.attributeValue("flag");
                if ("header".equalsIgnoreCase(flag)) {
                    this.header = element;
                    elements.remove(i--);
                } else if ("footer".equalsIgnoreCase(flag)) {
                    this.footer = element;
                    elements.remove(i--);
                }
            }
            ++i;
        }
        this.headerFooter = new HeaderFooter(this.header, this.footer, this);
        this.pdfWriter.setPageEvent(this.headerFooter);
        this.document.open();
        this.addElements(this.document, this.pdfWriter, elements);
        this.document.close();
    }

    private com.KGitextpdf.text.Document getPage(Element root) {
        String[] marginArray;
        com.KGitextpdf.text.Document document = null;
        boolean landscape = "true".equalsIgnoreCase(root.attributeValue("landscape"));
        String margin = root.attributeValue("margin");
        String width = root.attributeValue("width");
        String height = root.attributeValue("height");
        if (width != null && width.length() != 0 && height != null && height.length() != 0) {
            document = new com.KGitextpdf.text.Document(new Rectangle(Float.valueOf(width).floatValue(), Float.valueOf(height).floatValue()));
        } else {
            Rectangle pageSize = PageSize.A4;
            document = !landscape ? new com.KGitextpdf.text.Document(PageSize.A4) : new com.KGitextpdf.text.Document(new Rectangle(pageSize.getHeight(), pageSize.getWidth()));
        }
        if (margin != null && margin.length() > 0 && (marginArray = margin.split("[\\p{Blank}]+")).length == 4) {
            this.pagemargin = new float[4];
            int i = 0;
            while (i < this.pagemargin.length) {
                this.pagemargin[i] = Float.valueOf(marginArray[i]).floatValue();
                ++i;
            }
            document.setMargins(this.pagemargin[0], this.pagemargin[1], this.pagemargin[2], this.pagemargin[3]);
        }
        return document;
    }

    protected void addElements(com.KGitextpdf.text.Document document, PdfWriter pdfWriter, List elements) throws org.dom4j.DocumentException, DocumentException, IOException {
        int i = 0;
        while (i < elements.size()) {
            Element element = (Element)elements.get(i);
            String elementName = element.getName();
            if ("table".equalsIgnoreCase(elementName)) {
                String align;
                String spacingAfter;
                String absolute = element.attributeValue("absolute");
                String percent = element.attributeValue("percent");
                String tableWidth = element.attributeValue("tableWidth");
                String tableBoderWidth = element.attributeValue("borderWidth");
                String borderWidthType = element.attributeValue("borderWidthType");
                PdfPTable table = null;
                if (this.isNotBlank(absolute)) {
                    float[] percentF = this.string2Float(absolute.split(","));
                    table = new PdfPTable(percentF.length);
                    table.setTotalWidth(percentF);
                    table.setLockedWidth(true);
                } else if ("4.0".equals(this.version)) {
                    int[] percenti = this.string2Int(percent.split(","));
                    table = new PdfPTable(percenti.length);
                    table.setWidths(percenti);
                    if (this.isNotBlank(tableWidth)) {
                        table.setTotalWidth(Float.valueOf(tableWidth).floatValue());
                    } else {
                        float pageWidth = document.getPageSize().getWidth() - document.leftMargin() - document.rightMargin();
                        table.setTotalWidth(pageWidth);
                    }
                    table.setLockedWidth(true);
                } else {
                    List trs = element.selectNodes("tr");
                    Element tr = (Element)trs.get(0);
                    table = new PdfPTable(tr.selectNodes("td").size());
                    table.setTotalWidth(document.getPageSize().getWidth() - (document.leftMargin() + document.rightMargin()));
                    if (percent != null) {
                        table.setWidths(this.string2Int(percent.split(",")));
                    }
                    table.setLockedWidth(true);
                }
                String spacingBefore = element.attributeValue("spacingBefore");
                if (this.isNotBlank(spacingBefore)) {
                    table.setSpacingBefore(Float.valueOf(spacingBefore).floatValue());
                }
                if (this.isNotBlank(spacingAfter = element.attributeValue("spacingAfter"))) {
                    table.setSpacingAfter(Float.valueOf(spacingAfter).floatValue());
                }
                if ("left".equalsIgnoreCase(align = element.attributeValue("align"))) {
                    table.setHorizontalAlignment(0);
                } else if ("right".equalsIgnoreCase(align)) {
                    table.setHorizontalAlignment(2);
                } else {
                    table.setHorizontalAlignment(1);
                }
                List trs = element.selectNodes("tr");
                int k = 0;
                while (k < trs.size()) {
                    Element tr = (Element)trs.get(k);
                    List tds = tr.selectNodes("td");
                    int j = 0;
                    while (j < tds.size()) {
                        Element td = (Element)tds.get(j);
                        if (this.isNotBlank(tableBoderWidth)) {
                            this.setTableBorderWidth(td, k, j, trs.size(), tds.size(), tableBoderWidth, borderWidthType);
                        }
                        KGPdfPCell kgCell = new KGPdfPCell(this, this.version);
                        kgCell.setText(td.getText());
                        List chunks = td.selectNodes("chunk");
                        kgCell.setChunks(chunks);
                        List paragraphs = td.selectNodes("paragraph");
                        kgCell.setParagraphs(paragraphs);
                        KGPdfExporter.setterObj(kgCell, td);
                        table.addCell(kgCell.build());
                        ++j;
                    }
                    ++k;
                }
                document.add(table);
            } else if ("paragraph".equalsIgnoreCase(elementName)) {
                Paragraph paragraph = new Paragraph();
                KGPdfExporter.setterObj(paragraph, element);
                String align = element.attributeValue("align");
                if ("center".equalsIgnoreCase(align)) {
                    paragraph.setAlignment(1);
                } else if ("right".equals(align)) {
                    paragraph.setAlignment(2);
                } else {
                    paragraph.setAlignment(0);
                }
                String lineHeight = element.attributeValue("lineHeight");
                List list = element.selectNodes("chunk");
                int j = 0;
                while (j < list.size()) {
                    Element chunk = (Element)list.get(j);
                    KGChunk kgChunk = new KGChunk(this);
                    kgChunk.setText(chunk.getText());
                    KGPdfExporter.setterObj(kgChunk, chunk);
                    Chunk chunkElment = kgChunk.build2();
                    if (this.isNotBlank(lineHeight)) {
                        chunkElment.setLineHeight(Float.parseFloat(lineHeight));
                    }
                    paragraph.add(chunkElment);
                    ++j;
                }
                document.add(paragraph);
            } else if ("line".equalsIgnoreCase(elementName)) {
                float currentHeight = document.getCurrentHeight();
                String val = element.attributeValue("value");
                PdfContentByte contentByte = pdfWriter.getDirectContent();
                PdfGState pdfGState = new PdfGState();
                pdfGState.setFillOpacity(0.8f);
                contentByte.setLineWidth(0.5f);
                contentByte.setGState(pdfGState);
                currentHeight -= 4.0f;
                contentByte.saveState();
                if ("0".equals(val)) {
                    contentByte.setLineDash(3.0f, 3.0f, 0.0f);
                }
                contentByte.moveTo(document.leftMargin(), currentHeight);
                contentByte.lineTo(document.getPageSize().getWidth() - document.rightMargin(), currentHeight);
                contentByte.stroke();
                contentByte.closePathEoFillStroke();
                contentByte.restoreState();
            }
            ++i;
        }
    }

    private void setTableBorderWidth(Element td, int k, int j, int trsSize, int tdsSize, String tableBoderWidth, String borderWidthType) {
        td.addAttribute("borderWidth", "0");
        if ("outer".equals(borderWidthType)) {
            if (k == 0) {
                td.addAttribute("borderWidthTop", tableBoderWidth);
            }
            if (j == 0) {
                td.addAttribute("borderWidthLeft", tableBoderWidth);
            }
        } else {
            td.addAttribute("borderWidthTop", tableBoderWidth);
            td.addAttribute("borderWidthLeft", tableBoderWidth);
        }
        if (j == tdsSize - 1) {
            td.addAttribute("borderWidthRight", tableBoderWidth);
        }
        if (k == trsSize - 1) {
            td.addAttribute("borderWidthBottom", tableBoderWidth);
        }
    }

    public float[] getPagemargin() {
        return this.pagemargin;
    }

    public void setPagemargin(float[] pagemargin) {
        this.pagemargin = pagemargin;
    }

    private void close(Closeable able) {
        try {
            if (able != null) {
                able.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isNotBlank(String val) {
        boolean ret = false;
        if (val != null && val.length() > 0) {
            ret = true;
        }
        return ret;
    }

    private float[] string2Float(String[] vals) {
        float[] floats = new float[vals.length];
        int i = 0;
        while (i < vals.length) {
            floats[i] = Float.valueOf(vals[i]).floatValue();
            ++i;
        }
        return floats;
    }

    private int[] string2Int(String[] vals) {
        int[] floats = new int[vals.length];
        int i = 0;
        while (i < vals.length) {
            floats[i] = Integer.valueOf(vals[i]);
            ++i;
        }
        return floats;
    }

    protected static void setterObj(Object obj, Element element) {
        Field[] fields;
        Field[] fieldArray = fields = obj.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String name = field.getName();
            String val = element.attributeValue(name);
            KGPdfExporter.setter(obj, name, val);
            ++n2;
        }
    }

    private static void setter(Object obj, String name, String val) {
        if (val == null || val.length() == 0) {
            return;
        }
        try {
            Field field = obj.getClass().getDeclaredField(name);
            Class<?> clazz = field.getType();
            Object args = null;
            args = clazz == Integer.TYPE || clazz == Integer.class ? Integer.valueOf(val) : (clazz == Float.TYPE || clazz == Float.class ? Float.valueOf(val) : (clazz == Boolean.TYPE ? Boolean.valueOf(val) : val));
            String methodName = "set" + String.valueOf(name.charAt(0)).toUpperCase() + name.substring(1);
            Method method = obj.getClass().getMethod(methodName, clazz);
            method.invoke(obj, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected PdfWriter getPdfWriter() {
        return this.pdfWriter;
    }

    protected void setPdfWriter(PdfWriter pdfWriter) {
        this.pdfWriter = pdfWriter;
    }

    protected HeaderFooter getHeaderFooter() {
        return this.headerFooter;
    }

    protected void setHeaderFooter(HeaderFooter headerFooter) {
        this.headerFooter = headerFooter;
    }

    protected PdfTemplate getTotalPage() {
        return this.totalPage;
    }

    protected void setTotalPage(PdfTemplate totalPage) {
        this.totalPage = totalPage;
    }

    protected String getFontName() {
        return this.fontName;
    }

    protected void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public com.KGitextpdf.text.Document getDocument() {
        return this.document;
    }

    public void setDocument(com.KGitextpdf.text.Document document) {
        this.document = document;
    }
}

