/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.signature.sm2;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.pdf.PdfDate;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfSignature;
import com.KGitextpdf.text.pdf.PdfSignatureAppearance;
import com.KGitextpdf.text.pdf.PdfString;
import com.KGitextpdf.text.pdf.security.CrlClient;
import com.KGitextpdf.text.pdf.security.ExternalDigest;
import com.KGitextpdf.text.pdf.security.ExternalSignature;
import com.KGitextpdf.text.pdf.security.MakeSignature;
import com.KGitextpdf.text.pdf.security.OcspClient;
import com.KGitextpdf.text.pdf.security.TSAClient;
import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.kgcore.gm.SealGM;
import com.kinggrid.kgcore.gm.SealUtil;
import com.kinggrid.pdf.DigitalSignatureByKeySM2;
import com.kinggrid.pdf.executes.signature.sm2.GMSesSignature;
import com.kinggrid.pdf.executes.signature.sm2.KGDigest;
import com.kinggrid.pdf.executes.signature.sm2.SesSignature;
import com.kinggrid.pdf.signinter.DigitalSignatureByGB;
import com.kinggrid.pdf.signinter.DigitalSignatureSM2;
import com.kinggrid.pdf.utils.VerifyCertUtils;
import com.kinggrid.pdf.utils.VerifySealUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERSequence;

public class MakeSM2Signature {
    public static void signDetached(PdfSignatureAppearance sap, ExternalDigest externalDigest, ExternalSignature externalSignature, byte[] seal, Certificate[] chain, Collection<CrlClient> crlList, OcspClient ocspClient, TSAClient tsaClient, int estimatedSize, MakeSignature.CryptoStandard sigtype) throws IOException, DocumentException, GeneralSecurityException {
        MakeSM2Signature makeSM2Signature = new MakeSM2Signature();
        SealGM sealInfo = makeSM2Signature.verifyBeforeSign(chain, seal);
        if (estimatedSize == 0) {
            estimatedSize = seal.length + 8192;
        }
        PdfSignature dic = new PdfSignature(new PdfName("GM.PkiLite"), new PdfName("GM.sm2seal"));
        dic.setReason(sap.getReason());
        dic.setLocation(sap.getLocation());
        dic.setSignatureCreator(sap.getSignatureCreator());
        dic.setContact(sap.getContact());
        dic.setDate(new PdfDate(sap.getSignDate()));
        sap.setCryptoDictionary(dic);
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        exc.put(PdfName.CONTENTS, new Integer(estimatedSize * 2 + 2));
        sap.preClose(exc);
        String hashAlgorithm = externalSignature.getHashAlgorithm();
        InputStream data = sap.getRangeStream();
        byte[] hash = KGDigest.digest(data, hashAlgorithm);
        byte[] paddedSig = new byte[estimatedSize];
        byte[] encodedSig = null;
        Date time = Calendar.getInstance().getTime();
        int version = sealInfo.getVersion();
        if (externalSignature instanceof DigitalSignatureByKeySM2) {
            DigitalSignatureByKeySM2 digitalSignatureByKeySM2 = (DigitalSignatureByKeySM2)externalSignature;
            DERSequence toSignSeq = null;
            if (version == 4) {
                String date = String.valueOf(KGDateUtils.format2GMTTime(time, "yyyyMMddHHmmss")) + "Z";
                toSignSeq = SesSignature.getToSignData(seal, date, hash, "hash");
            } else {
                String date = String.valueOf(KGDateUtils.format2GMTTime(time, "yyMMddHHmmss")) + "Z";
                toSignSeq = GMSesSignature.getGMToSignData(seal, date, hash, "hash", chain[0].getEncoded());
            }
            digitalSignatureByKeySM2.sign(toSignSeq.getEncoded());
            digitalSignatureByKeySM2.setSealVersion(version);
            digitalSignatureByKeySM2.setContentsPostion(sap.getContentsPostion());
        } else {
            String date;
            if (version == 4) {
                date = String.valueOf(KGDateUtils.format2GMTTime(time, "yyyyMMddHHmmss")) + "Z";
                if (externalSignature instanceof DigitalSignatureByGB) {
                    DigitalSignatureByGB digitalSignatureByGB = (DigitalSignatureByGB)externalSignature;
                    digitalSignatureByGB.setDoSm3("0");
                    byte[] sign = digitalSignatureByGB.sign(hash);
                    chain = digitalSignatureByGB.getCertificate();
                    VerifyCertUtils.verifySignCert(sealInfo, chain);
                    KGBase64 base64 = new KGBase64();
                    encodedSig = base64.decode(new String(sign, "UTF-8"));
                } else {
                    DERSequence toSignSeq = SesSignature.getToSignData(seal, date, hash, "hash");
                    byte[] sign = externalSignature.sign(toSignSeq.getEncoded());
                    encodedSig = SesSignature.getSesSignature((ASN1Sequence)toSignSeq, chain[0].getEncoded(), sign, null).getEncoded();
                }
            } else {
                date = String.valueOf(KGDateUtils.format2GMTTime(time, "yyMMddHHmmss")) + "Z";
                DERSequence toSignSeq = GMSesSignature.getGMToSignData(seal, date, hash, "hash", chain[0].getEncoded());
                byte[] sign = externalSignature.sign(toSignSeq.getEncoded());
                encodedSig = GMSesSignature.getGMSesSignature((ASN1Sequence)toSignSeq, sign).getEncoded();
            }
            if (estimatedSize < encodedSig.length) {
                throw new IOException("Not enough space");
            }
            System.arraycopy(encodedSig, 0, paddedSig, 0, encodedSig.length);
            if (externalSignature instanceof DigitalSignatureSM2) {
                ((DigitalSignatureSM2)externalSignature).setSesSignature(encodedSig);
            }
            if (externalSignature instanceof DigitalSignatureByGB) {
                ((DigitalSignatureByGB)externalSignature).setSesSignature(encodedSig);
            }
        }
        PdfDictionary dic2 = new PdfDictionary();
        dic2.put(PdfName.CONTENTS, new PdfString(paddedSig).setHexWriting(true));
        sap.close(dic2);
    }

    private SealGM verifyBeforeSign(Certificate[] chain, byte[] seal) throws IOException, CertificateEncodingException {
        SealGM sealInfo = SealUtil.getSealInfo(seal);
        VerifySealUtil verifySealUtil = new VerifySealUtil();
        ASN1Sequence sequence = DERSequence.getInstance((Object)seal);
        verifySealUtil.asn1SealComplete(sequence);
        verifySealUtil.verifySeal(seal);
        if (chain != null) {
            VerifyCertUtils.verifySignCert(sealInfo, chain);
        }
        return sealInfo;
    }
}

