/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.signature;

import com.KGitextpdf.text.io.RASInputStream;
import com.KGitextpdf.text.io.RandomAccessSourceFactory;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.RandomAccessFileOrArray;
import com.kinggrid.pdf.executes.entity.SignSealInfo;
import com.kinggrid.pdf.executes.signature.sm2.KGDigest;
import com.kinggrid.pdf.utils.AnalyticalSealUtil;
import com.kinggrid.pdf.utils.VerifySealUtil;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.kg.bouncycastle.asn1.ASN1Sequence;

public class VerifySignatureSM2 {
    private PdfDictionary v;
    private PdfIndirectReference n;
    private PdfReader reader;
    private SignSealInfo signSealInfo;

    public VerifySignatureSM2(PdfDictionary v, PdfIndirectReference n, PdfReader reader) throws IOException {
        this.v = v;
        this.n = n;
        this.reader = reader;
    }

    public void verify() throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
        PdfName sub = this.v.getAsName(PdfName.SUBFILTER);
        if (!sub.equals(new PdfName("GM.sm2seal")) && !sub.equals(new PdfName("GM.eSealGM.PKILite"))) {
            throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u8be5\u79cd\u5b50\u8fc7\u6ee4\u5668\u5904\u7406PDF\u6570\u5b57\u7b7e\u540d\uff01");
        }
        PdfArray b = this.v.getAsArray(PdfName.BYTERANGE);
        RandomAccessFileOrArray rf = this.reader.getSafeFile();
        RASInputStream rg = new RASInputStream(new RandomAccessSourceFactory().createRanged(rf.createSourceView(), b.asLongArray()));
        byte[] newHash = KGDigest.digest(rg, "SM3");
        byte[] contents = this.v.getAsString(PdfName.CONTENTS).getOriginalBytes();
        this.signSealInfo = AnalyticalSealUtil.sealinfo(ASN1Sequence.getInstance((Object)contents));
        VerifySealUtil verifySealUtil = new VerifySealUtil();
        verifySealUtil.verifySignatureStructure(this.signSealInfo, newHash);
    }

    public SignSealInfo getSignSealInfo() {
        return this.signSealInfo;
    }
}

