/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.signature;

import com.kinggrid.commons.KGDateUtils;
import java.io.IOException;
import java.util.Date;
import org.kg.bouncycastle.asn1.ASN1Primitive;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.kg.bouncycastle.asn1.x509.TBSCertificateStructure;

public class VerifyHelperUtils {
    public static boolean verifyDate(TBSCertificateStructure tbsCert, Date date) {
        boolean res = false;
        String startTime = tbsCert.getStartDate().getTime();
        String endTime = tbsCert.getEndDate().getTime();
        Date startDate = KGDateUtils.parseGMT2Date(startTime);
        Date endDate = KGDateUtils.parseGMT2Date(endTime);
        if (KGDateUtils.compareDate(startDate, date) < 0 && KGDateUtils.compareDate(endDate, date) > 0) {
            res = true;
        }
        return res;
    }

    public static byte[] getPubkey(TBSCertificateStructure tbsCert) {
        SubjectPublicKeyInfo subPublicKeyInfo = tbsCert.getSubjectPublicKeyInfo();
        byte[] pubkey = subPublicKeyInfo.getPublicKeyData().getBytes();
        byte[] pk = new byte[64];
        System.arraycopy(pubkey, 1, pk, 0, 64);
        return pk;
    }

    public static TBSCertificateStructure getTbsCert(byte[] cert) throws IOException {
        ASN1Sequence certSeq = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])cert);
        return TBSCertificateStructure.getInstance((Object)certSeq.getObjectAt(0));
    }
}

