/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.electronicseal;

import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.security.DigestAlgorithms;
import com.KGitextpdf.text.pdf.security.PdfPKCS7;
import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.encrypt.KGSignature;
import com.kinggrid.encrypt.SM3Utils;
import com.kinggrid.exception.KGElecDigitalSigVerifyException;
import com.kinggrid.pdf.executes.PdfElectronicSealDetails;
import com.kinggrid.pdf.executes.customize.DisposeSigndataToClient;
import com.kinggrid.pdf.executes.entity.SignSealInfo;
import com.kinggrid.pdf.executes.signature.sm2.SM2;
import com.kinggrid.pdf.signinter.TimeStampValidInter;
import com.kinggrid.pdf.utils.AnalyticalSealUtil;
import com.kinggrid.pdf.utils.VerifySealUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.kg.bouncycastle.asn1.ASN1Integer;
import org.kg.bouncycastle.asn1.ASN1Primitive;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DERSequence;
import org.kg.bouncycastle.asn1.DLSequence;
import org.kg.bouncycastle.asn1.x509.Certificate;
import org.kg.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.kg.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.kg.bouncycastle.jce.provider.BouncyCastleProvider;

public class VerifyDigitalSignatureSoftVImpl
implements PdfElectronicSealDetails.PdfElecDigitalSigVerify {
    private TimeStampValidInter timeStampValidInter;
    private String certstartDate;
    private String certendDate;
    private int errorCode = 0;

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public String getCertstartDate() {
        return this.certstartDate;
    }

    public void setCertstartDate(String certstartDate) {
        this.certstartDate = certstartDate;
    }

    public String getCertendDate() {
        return this.certendDate;
    }

    public void setCertendDate(String certendDate) {
        this.certendDate = certendDate;
    }

    public TimeStampValidInter getTimeStampValidInter() {
        return this.timeStampValidInter;
    }

    public void setTimeStampValidInter(TimeStampValidInter timeStampValidInter) {
        this.timeStampValidInter = timeStampValidInter;
    }

    @Override
    public boolean verify(byte[] sigData, byte[] newDigest, byte[] cert, PdfDictionary annot) {
        try {
            KGBase64 base64 = new KGBase64();
            String sigDataBase64 = new String(sigData);
            byte[] sigDataBytes = base64.decode(sigDataBase64);
            cert = this.dealCertData(cert);
            String sigName = this.getAlgorithm(cert);
            VerifySealUtil verifySealUtil = new VerifySealUtil();
            if (sigName.equals("RSA") && annot.getAsString(new PdfName("ESType")) == null) {
                PdfPKCS7 pdfPKCS7 = new PdfPKCS7(base64.decode(sigDataBase64), new PdfName("KG"), "KGBC");
                byte[] extSignature = pdfPKCS7.getDigest();
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate oCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert));
                if (!KGSignature.verify(oCert, extSignature, newDigest, pdfPKCS7.getDigestAlgorithm())) {
                    throw new KGElecDigitalSigVerifyException("\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u7b7e\u540d\u503c\u5931\u8d25\uff01");
                }
            } else if (annot.getAsString(new PdfName("ESType")) != null && "GB".equals(annot.getAsString(new PdfName("ESType")).toString())) {
                ASN1Sequence sequence = DERSequence.getInstance((Object)sigDataBytes);
                SignSealInfo signSealInfo = AnalyticalSealUtil.sealinfo(sequence);
                byte[] signbyte = signSealInfo.getSignData();
                byte[] tosigndata = signSealInfo.getTosignData();
                byte[] hash = signSealInfo.getHash();
                String signdate = signSealInfo.getSignDate();
                String esid = signSealInfo.getEsId();
                verifySealUtil.setVersion(Integer.valueOf(signSealInfo.getHeaderVer()));
                verifySealUtil.setSealinfo(signSealInfo);
                if (signbyte.length != 64) {
                    signbyte = VerifyDigitalSignatureSoftVImpl.sigDataAns1To64bit(signbyte);
                }
                if (!verifySealUtil.asn1Complete(sequence)) {
                    throw new KGElecDigitalSigVerifyException("\u9a8c\u8bc1\u7b7e\u7ae0\u7ed3\u6784\u4f53\u5b8c\u6574\u6027\u5931\u8d25\uff01errorCode:" + this.errorCode);
                }
                if (!this.sm2Verify(tosigndata, cert, signbyte)) {
                    throw new KGElecDigitalSigVerifyException("\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u5931\u8d25\uff0c\u9a8c\u8bc1\u7b7e\u540d\u503c\u5931\u8d25\uff01");
                }
                byte[] newSM3Hash = SM3Utils.sm3Digest(newDigest);
                if (!Arrays.equals(hash, newSM3Hash)) {
                    throw new KGElecDigitalSigVerifyException("\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u5931\u8d25\uff0c\u6587\u6863\u5df2\u88ab\u7be1\u6539\uff01");
                }
                if (!this.certMatchValid(signSealInfo.getCertType(), signSealInfo.getCert(), signSealInfo.getCertList())) {
                    throw new KGElecDigitalSigVerifyException("\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u7b7e\u540d\u503c\u5931\u8d25,\u7b7e\u7ae0\u8005\u8bc1\u4e66\u4e0e\u7535\u5b50\u5370\u7ae0\u4e0d\u5339\u914d\uff01");
                }
                if (!this.cerValid(signdate, esid)) {
                    throw new KGElecDigitalSigVerifyException("\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u5931\u8d25\uff0c\u7b7e\u7ae0\u65f6\u95f4\u4e0d\u5728\u8bc1\u4e66\u6709\u6548\u671f\u5185\uff01");
                }
            } else if (annot.getAsString(new PdfName("ESType")) != null && "GMV4".equals(annot.getAsString(new PdfName("ESType")).toString())) {
                ASN1Sequence sequence = DERSequence.getInstance((Object)sigDataBytes);
                SignSealInfo signSealInfo = AnalyticalSealUtil.sealinfo(sequence);
                byte[] signbyte = signSealInfo.getSignData();
                byte[] tosigndata = signSealInfo.getTosignData();
                byte[] hash = signSealInfo.getHash();
                String signdate = signSealInfo.getSignDate();
                String esid = signSealInfo.getEsId();
                verifySealUtil.setVersion(Integer.valueOf(signSealInfo.getHeaderVer()));
                verifySealUtil.setSealinfo(signSealInfo);
                if (signbyte.length != 64) {
                    signbyte = VerifyDigitalSignatureSoftVImpl.sigDataAns1To64bit(signbyte);
                }
                if (!verifySealUtil.asn1Complete(sequence)) {
                    throw new KGElecDigitalSigVerifyException("\u9a8c\u8bc1\u7b7e\u7ae0\u7ed3\u6784\u4f53\u5b8c\u6574\u6027\u5931\u8d25\uff01errorCode:" + this.errorCode);
                }
                if (!this.sm2Verify(tosigndata, cert, signbyte)) {
                    throw new KGElecDigitalSigVerifyException("\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u5931\u8d25\uff0c\u9a8c\u8bc1\u7b7e\u540d\u503c\u5931\u8d25\uff01");
                }
                byte[] newSM3Hash = SM3Utils.sm3Digest(newDigest);
                if (!Arrays.equals(hash, newSM3Hash)) {
                    throw new KGElecDigitalSigVerifyException("\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u5931\u8d25\uff0c\u6587\u6863\u5df2\u88ab\u7be1\u6539\uff01");
                }
                if (!this.certMatchValid(signSealInfo.getCertType(), signSealInfo.getCert(), signSealInfo.getCertList())) {
                    throw new KGElecDigitalSigVerifyException("\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u7b7e\u540d\u503c\u5931\u8d25,\u7b7e\u7ae0\u8005\u8bc1\u4e66\u4e0e\u7535\u5b50\u5370\u7ae0\u4e0d\u5339\u914d\uff01");
                }
                if (!this.cerValid(signdate, esid)) {
                    throw new KGElecDigitalSigVerifyException("\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u5931\u8d25\uff0c\u7b7e\u7ae0\u65f6\u95f4\u4e0d\u5728\u8bc1\u4e66\u6709\u6548\u671f\u5185\uff01");
                }
                String timestamp = signSealInfo.getTimeStamp();
                byte[] bresp = signSealInfo.getTimeData();
                byte[] sign = signSealInfo.getSignData();
                if (!(this.timeStampValidInter == null || bresp == null || this.timeStampValidInter.valid(bresp, sign) && this.validsigndate(timestamp, signdate, esid))) {
                    throw new KGElecDigitalSigVerifyException("\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u5931\u8d25\uff0c\u9a8c\u8bc1\u65f6\u95f4\u6233\u5931\u8d25\uff01");
                }
            } else {
                if (sigDataBytes.length != 64) {
                    if (sigDataBytes.length != 64 && base64.decode(sigDataBase64)[0] == 48) {
                        sigDataBytes = VerifyDigitalSignatureSoftVImpl.sigDataAns1To64bit(sigDataBytes);
                    } else {
                        sigDataBytes = DisposeSigndataToClient.dismantleSigndata(sigDataBase64.getBytes());
                        if (sigDataBytes.length != 64) {
                            sigDataBytes = VerifyDigitalSignatureSoftVImpl.sigDataAns1To64bit(sigDataBytes);
                        }
                    }
                }
                if (!this.sm2Verify(newDigest, cert, sigDataBytes)) {
                    throw new KGElecDigitalSigVerifyException("\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u5931\u8d25\uff0c\u9a8c\u8bc1\u7b7e\u540d\u503c\u5931\u8d25\uff01");
                }
            }
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private boolean sm2Verify(byte[] msg, byte[] cert, byte[] signedData) throws IOException {
        TBSCertificateStructure tbsCert = VerifyDigitalSignatureSoftVImpl.getTbsCert(cert);
        byte[] pk = VerifyDigitalSignatureSoftVImpl.getPubkey(tbsCert);
        SM2 sm2 = new SM2(true);
        return sm2.Verify(msg, signedData, pk);
    }

    public byte[] dealCertData(byte[] cert) {
        KGBase64 base64 = new KGBase64();
        String certBase64 = new String(cert);
        certBase64 = certBase64.replaceAll("\r\n", "");
        if ((certBase64 = certBase64.replaceAll("\n", "")).indexOf("-----BEGIN CERTIFICATE-----") != -1) {
            int bidx = "-----BEGIN CERTIFICATE-----".length();
            int eidx = certBase64.indexOf("-----END CERTIFICATE-----");
            certBase64 = certBase64.substring(bidx, eidx);
        }
        return base64.decode(certBase64);
    }

    public static byte[] getPubkey(TBSCertificateStructure tbsCert) {
        SubjectPublicKeyInfo subPublicKeyInfo = tbsCert.getSubjectPublicKeyInfo();
        byte[] pubkey = subPublicKeyInfo.getPublicKeyData().getBytes();
        byte[] pk = new byte[64];
        System.arraycopy(pubkey, 1, pk, 0, 64);
        return pk;
    }

    public static TBSCertificateStructure getTbsCert(byte[] cert) throws IOException {
        ASN1Sequence certSeq = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])cert);
        return TBSCertificateStructure.getInstance((Object)certSeq.getObjectAt(0));
    }

    private static byte[] sigDataAns1To64bit(byte[] signData) throws IOException {
        int srcPos;
        int dest;
        ASN1Sequence sequense = ASN1Sequence.getInstance((Object)signData);
        ASN1Integer ans1Int0 = (ASN1Integer)sequense.getObjectAt(0);
        ASN1Integer ans1Int1 = (ASN1Integer)sequense.getObjectAt(1);
        byte[] sig1 = ans1Int0.getValue().toByteArray();
        byte[] sig2 = ans1Int1.getValue().toByteArray();
        byte[] buff = new byte[64];
        if (sig1.length < 32) {
            dest = 32 - sig1.length;
            System.arraycopy(sig1, 0, buff, dest, sig1.length);
        } else {
            srcPos = sig1.length == 32 ? 0 : sig1.length - 32;
            System.arraycopy(sig1, srcPos, buff, 0, 32);
        }
        if (sig2.length < 32) {
            dest = 32 - sig2.length;
            System.arraycopy(sig2, 0, buff, dest, sig2.length);
        } else {
            srcPos = sig2.length == 32 ? 0 : sig2.length - 32;
            System.arraycopy(sig2, srcPos, buff, 32, 32);
        }
        return buff;
    }

    public boolean cerValid(String signdate, String esid) {
        String certSta = this.getCertstartDate();
        String certend = this.getCertendDate();
        signdate = signdate.substring(0, 14);
        long signDate = Long.parseLong(signdate);
        long startDate = Long.parseLong(certSta.substring(0, 14));
        long endDate = Long.parseLong(certend.substring(0, 14));
        return startDate <= signDate && endDate >= signDate;
    }

    public String getAlgorithm(byte[] cert) throws IOException {
        ASN1Sequence seq = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])cert);
        Certificate certificate = Certificate.getInstance((Object)seq);
        this.setCertstartDate(certificate.getStartDate().getTime());
        this.setCertendDate(certificate.getEndDate().getTime());
        String algorithm = certificate.getSignatureAlgorithm().getAlgorithm().toString();
        String algName = DigestAlgorithms.getDigest(algorithm);
        if (algName.equals(algorithm)) {
            algName = "SM3";
        }
        String oid = certificate.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().toString();
        String sigName = null;
        if ("1.2.840.113549.1.1.1".equals(oid)) {
            sigName = "RSA";
        } else if ("1.2.840.10045.2.1".equals(oid)) {
            sigName = "SM2";
        } else {
            throw new RuntimeException("\u76ee\u524d\u4e0d\u652f\u6301\u7b7e\u540d\u7b97\u6cd5oid\uff1a" + oid);
        }
        return sigName;
    }

    public boolean validsigndate(String time, String signdate, String esid) {
        int num = esid.length();
        String signtime = signdate.substring(0, 14);
        String timestamp = time.substring(0, 14);
        if (num == 14) {
            signtime = KGDateUtils.getDate(signdate.substring(0, 14));
            signtime = KGDateUtils.dealHour(signtime, "sub", 8);
            signtime = KGDateUtils.toTimeStamp(signtime);
        }
        Long newtimestamp = Long.parseLong(timestamp);
        Long newsigntime = Long.parseLong(signtime);
        return newsigntime <= newtimestamp;
    }

    public boolean certMatchValid(String certtype, byte[] cert, DLSequence sequence) {
        int num = sequence.size();
        boolean flag = false;
        if (certtype.equals("1")) {
            byte[] cert_list = null;
            int i = 0;
            while (i < num) {
                cert_list = ((DEROctetString)sequence.getObjectAt(i)).getOctets();
                flag = Arrays.equals(cert, cert_list);
                if (flag) break;
                ++i;
            }
        }
        return flag;
    }
}

