/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.customize;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfString;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.KGExecute;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PdfSignatureSpSealSigHashAndData
extends KGExecute {
    private KGBase64 base64 = new KGBase64();
    private List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();

    @Override
    protected void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        PdfDictionary page = pdfReader.getPageN(pagen);
        PdfArray annots = page.getAsArray(PdfName.ANNOTS);
        if (annots != null) {
            int i = annots.size() - 1;
            while (i >= 0) {
                PdfDictionary sealSig;
                PdfDictionary kg;
                PdfDictionary annot = annots.getAsDict(i);
                if (annot != null && PdfName.SIG.equals(annot.getAsName(PdfName.FT)) && (kg = annot.getAsDict(new PdfName("KG"))) != null && (sealSig = kg.getAsDict(new PdfName("sealSig"))) != null) {
                    PdfIndirectReference certRef = sealSig.getAsIndirectObject(new PdfName("certContext"));
                    PdfIndirectReference signDataRef = sealSig.getAsIndirectObject(new PdfName("certSignMsg6"));
                    PdfString signTime = sealSig.getAsString(new PdfName("signTime"));
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    if (signTime != null) {
                        map.put("signTime", signTime.toString());
                    }
                    if (certRef != null) {
                        PRStream certStream = (PRStream)pdfReader.getPdfObject(certRef.getNumber());
                        byte[] certData = PdfReader.getStreamBytesRaw(certStream);
                        if (PdfName.FLATEDECODE.equals(certStream.get(PdfName.FILTER))) {
                            certData = PdfReader.FlateDecode(certData);
                        }
                        map.put("certData", certData);
                    }
                    if (signDataRef != null) {
                        PRStream signDataStream = (PRStream)pdfReader.getPdfObject(signDataRef.getNumber());
                        byte[] signData = PdfReader.getStreamBytesRaw(signDataStream);
                        if (PdfName.FLATEDECODE.equals(signDataStream.get(PdfName.FILTER))) {
                            signData = PdfReader.FlateDecode(signData);
                        }
                        map.put("signData", this.base64.decode(new String(signData, "UTF-16LE")));
                    }
                    this.list.add(map);
                }
                --i;
            }
        }
    }

    public List<Map<String, Object>> getSignDatas() {
        return this.list;
    }
}

