/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.customize;

import com.KGitextpdf.text.BadElementException;
import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PRIndirectReference;
import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfFormField;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.executes.PdfSignature;
import com.kinggrid.pdf.executes.signature.KGPdfSignaureExecute;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PdfElectronicSeal2Sig
extends PdfSignature {
    private PdfName subtype = KGElectronicSealName.SEAL;

    public PdfElectronicSeal2Sig() {
    }

    public PdfElectronicSeal2Sig(List<KGPdfSignaureExecute> pdfSignaureExecutes) {
        for (KGPdfSignaureExecute pdfSignaureExecute : pdfSignaureExecutes) {
            super.addExtraExecute(pdfSignaureExecute);
        }
    }

    @Override
    public void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        PdfDictionary page = pdfReader.getPageN(pagen);
        PdfArray annots = page.getAsArray(PdfName.ANNOTS);
        if (annots != null) {
            int seal2SigNumb = 0;
            int i = annots.size() - 1;
            while (i >= 0) {
                PdfDictionary annot = annots.getAsDict(i);
                if (annot != null && this.subtype.equals(annot.getAsName(PdfName.SUBTYPE))) {
                    PdfArray pdfArray = annot.getAsArray(PdfName.RECT);
                    Rectangle rect = new Rectangle(pdfArray.getAsNumber(0).floatValue(), pdfArray.getAsNumber(1).floatValue(), pdfArray.getAsNumber(2).floatValue(), pdfArray.getAsNumber(3).floatValue());
                    Image img = this.getAnnotImage(pdfReader, annot);
                    if (img != null) {
                        this.setImage(img);
                        this.setRect(rect);
                        final PdfIndirectReference certRef = annot.getAsIndirectObject(new PdfName("certContext"));
                        final PdfIndirectReference signDataRef = annot.getAsIndirectObject(new PdfName("certSignMsg"));
                        final PdfIndirectReference signDataRef6 = annot.getAsIndirectObject(new PdfName("certSignMsg6"));
                        final PRIndirectReference info = (PRIndirectReference)annot.get(new PdfName("Info"));
                        this.addExtraExecute(new KGPdfSignaureExecute(){

                            @Override
                            public void execute(PdfStamper pdfStamper, PdfFormField sigField, int pagen) {
                                PdfName kgName;
                                PdfDictionary kg;
                                PdfDictionary sealSig = new PdfDictionary();
                                if (certRef != null) {
                                    sealSig.put(new PdfName("certContext"), certRef);
                                }
                                if (signDataRef != null) {
                                    sealSig.put(new PdfName("certSignMsg"), signDataRef);
                                }
                                if (signDataRef6 != null) {
                                    sealSig.put(new PdfName("certSignMsg6"), signDataRef6);
                                }
                                if ((kg = sigField.getAsDict(kgName = new PdfName("KG"))) == null) {
                                    kg = new PdfDictionary();
                                    sigField.put(new PdfName("KG"), kg);
                                }
                                kg.put(new PdfName("sealSig"), sealSig);
                                sigField.put(PdfName.INFO, info);
                            }
                        });
                        super.execute(pdfReader, pdfStamper, pagen);
                        annots.remove(i);
                        ++seal2SigNumb;
                    }
                }
                --i;
            }
            if (seal2SigNumb > 0) {
                pdfStamper.markUsed(annots);
                pdfStamper.markUsed(page);
            }
        }
    }

    private Image getAnnotImage(PdfReader pdfReader, PdfDictionary annotation) throws BadElementException {
        PdfObject object = annotation.get(PdfName.AP);
        if (object == null) {
            return null;
        }
        PdfDictionary apDictionary = null;
        if (object instanceof PRIndirectReference) {
            PRIndirectReference ap = (PRIndirectReference)object;
            apDictionary = (PdfDictionary)pdfReader.getPdfObject(ap.getNumber());
        } else {
            apDictionary = (PdfDictionary)object;
        }
        PRIndirectReference NReference = (PRIndirectReference)apDictionary.get(PdfName.N);
        return this.getImg(pdfReader, NReference);
    }

    private Image getImg(PdfReader pdfReader, PRIndirectReference NReference) throws BadElementException {
        Set<PdfName> set;
        Iterator<PdfName> iterator;
        PdfObject object = null;
        PRStream N = (PRStream)pdfReader.getPdfObject(NReference.getNumber());
        object = N.get(PdfName.RESOURCES);
        PdfDictionary resources = null;
        if (object instanceof PRIndirectReference) {
            PRIndirectReference resourcesReference = (PRIndirectReference)object;
            resources = (PdfDictionary)pdfReader.getPdfObject(resourcesReference.getNumber());
        } else {
            resources = (PdfDictionary)object;
        }
        object = resources.get(PdfName.XOBJECT);
        PdfDictionary xobject = null;
        if (object instanceof PRIndirectReference) {
            PRIndirectReference resourcesReference = (PRIndirectReference)object;
            xobject = (PdfDictionary)pdfReader.getPdfObject(resourcesReference.getNumber());
        } else {
            xobject = (PdfDictionary)object;
        }
        object = xobject.get(new PdfName("Icon"));
        if (object == null) {
            object = xobject.get(new PdfName("Im0"));
        }
        if (object == null && (iterator = (set = xobject.getKeys()).iterator()).hasNext()) {
            PdfName img = iterator.next();
            object = xobject.get(img);
        }
        if (object == null) {
            throw new IllegalArgumentException("\u7535\u5b50\u7b7e\u7ae0\u627e\u4e0d\u5230\u56fe\u7247\u4fe1\u606f.");
        }
        PRIndirectReference im0Reference = (PRIndirectReference)object;
        xobject = (PdfDictionary)pdfReader.getPdfObject(im0Reference.getNumber());
        if (xobject.getAsName(PdfName.SUBTYPE).equals(PdfName.FORM)) {
            return this.getImg(pdfReader, im0Reference);
        }
        return Image.getInstance(im0Reference);
    }

    public PdfName getSubtype() {
        return this.subtype;
    }

    public void setSubtype(PdfName subtype) {
        this.subtype = subtype;
    }
}

