/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes.customize;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.kinggrid.img.CutImage;
import com.kinggrid.kgcore.enmu.KGServerTypeEnum;
import com.kinggrid.pdf.executes.PdfElectronicSeal4KG;
import java.io.IOException;
import java.util.Map;

public class PdfElecQfzSkip
extends PdfElectronicSeal4KG {
    private Rectangle rect;
    private Map<Integer, Integer> orginalMap = null;
    private Map<Integer, Integer> rectMap = null;
    private int startPage = 1;
    private int increment = 1;
    private int startX = 0;
    private String imgFormat = "GIF";
    private int yDistance = -1;
    private boolean upward = false;

    public PdfElecQfzSkip(String keyPath, int sealNumb, String sealPwd) {
        super(keyPath, sealNumb, sealPwd);
    }

    public PdfElecQfzSkip(String url, KGServerTypeEnum type, String keySN, String password, String signName) {
        super(url, type, keySN, password, signName);
    }

    public PdfElecQfzSkip(String url, KGServerTypeEnum type, String keySN, String password, int index) {
        super(url, type, keySN, password, index);
    }

    @Override
    public Rectangle getRect() {
        return this.rect;
    }

    @Override
    public void setRect(Rectangle rect) {
        this.rect = rect;
    }

    @Override
    public int getStartPage() {
        return this.startPage;
    }

    @Override
    public void setStartPage(int startPage) {
        if (startPage < 1) {
            throw new IllegalArgumentException("startPage \u4e0d\u80fd\u5c0f\u4e8e1.");
        }
        this.startPage = startPage;
    }

    @Override
    public void qfzSign(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws IOException, DocumentException {
        if (this.getyDistanceOrigin() < this.getQfzHeight()) {
            throw new IllegalArgumentException("yDistanceOrigin \u4e0d\u80fd\u5c0f\u4e8e" + this.getQfzHeight() + ",\u5426\u5219\u663e\u793a\u4e0d\u5168.");
        }
        if (this.yDistance < 0) {
            this.yDistance = this.getyDistanceOrigin();
        }
        int lastpage = this.pagens[this.pagens.length - 1];
        int totalpages = this.pagens.length;
        if (totalpages < 2) {
            throw new IllegalArgumentException("\u9a91\u7f1d\u7ae0\uff0cPDF\u6587\u6863\u81f3\u5c11\u9700\u8981\u4e24\u9875\u76d6\u7ae0\u9875\u3002\u5f53\u524d\u76d6\u7ae0\u9875\u6570\uff1a" + totalpages);
        }
        int originalWidth = (int)this.getImage().getWidth();
        if (this.orginalMap == null) {
            if (totalpages < this.getNumber()) {
                this.orginalMap = this.getPerPagePercent(totalpages, originalWidth, this.getNumber());
                this.rectMap = this.getPerPagePercent(totalpages, this.getQfzWidth(), this.getNumber());
            } else {
                this.orginalMap = this.getPerPagePercent(this.getNumber(), originalWidth, this.getNumber());
                this.rectMap = this.getPerPagePercent(this.getNumber(), this.getQfzWidth(), this.getNumber());
            }
        }
        int rotation = pdfReader.getPageRotation(pagen);
        int cutImgWidth = this.orginalMap.get(this.increment);
        int rectWidth = this.rectMap.get(this.increment);
        CutImage cutImage = new CutImage(this.getImage().getOriginalData(), this.imgFormat);
        if ((float)(this.startX + cutImgWidth) > this.getImage().getWidth()) {
            this.startX = 0;
        }
        byte[] partImageData = cutImage.cut(this.startX, 0, cutImgWidth, (int)this.getImage().getHeight());
        Image partImage = Image.getInstance(partImageData);
        partImage.scaleToFit(rectWidth, this.getQfzHeight());
        Rectangle pageRect = pdfReader.getPageSize(pagen);
        this.rect = rotation == 90 || rotation == 270 ? new Rectangle(pageRect.getHeight() - (float)rectWidth, this.yDistance, pageRect.getHeight(), this.yDistance + this.getQfzHeight(), rotation) : new Rectangle(pageRect.getWidth() - (float)rectWidth, this.yDistance, pageRect.getWidth(), this.yDistance + this.getQfzHeight(), rotation);
        this.sign(pdfReader, pdfStamper, pagen, partImage, this.rect);
        if (pagen != lastpage) {
            if (this.increment == this.getNumber()) {
                this.increment = 1;
                this.startX = 0;
                if (this.upward) {
                    this.yDistance += this.getQfzHeight();
                    this.upward = false;
                } else {
                    this.yDistance -= this.getQfzHeight();
                    this.upward = true;
                }
                int surplusPage = lastpage - pagen;
                if (surplusPage < this.getNumber() && surplusPage > 0) {
                    this.orginalMap = this.getPerPagePercent(surplusPage + 1, originalWidth, surplusPage + 1);
                    this.rectMap = this.getPerPagePercent(surplusPage + 1, this.getQfzWidth(), surplusPage + 1);
                }
                cutImgWidth = this.orginalMap.get(this.increment);
                rectWidth = this.rectMap.get(this.increment);
                partImageData = cutImage.cut(this.startX, 0, cutImgWidth, (int)this.getImage().getHeight());
                partImage = Image.getInstance(partImageData);
                this.rect = rotation == 90 || rotation == 270 ? new Rectangle(pageRect.getHeight() - (float)rectWidth, this.yDistance, pageRect.getHeight(), this.yDistance + this.getQfzHeight(), rotation) : new Rectangle(pageRect.getWidth() - (float)rectWidth, this.yDistance, pageRect.getWidth(), this.yDistance + this.getQfzHeight(), rotation);
                this.sign(pdfReader, pdfStamper, pagen, partImage, this.rect);
                ++this.increment;
                this.startX += cutImgWidth;
            } else {
                ++this.increment;
                this.startX += cutImgWidth;
            }
        }
    }
}

