/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.kinggrid.kgcore.KGElectronicSeal;
import com.kinggrid.kgcore.SealInformation;
import com.kinggrid.kgcore.enmu.KGServerTypeEnum;
import com.kinggrid.pdf.executes.PdfSignature;
import com.kinggrid.pdf.utils.KGPropertyUtils;
import java.io.IOException;

public class PdfSignature4KG
extends PdfSignature {
    private float resetImageWidth;
    private float resetImageHeight;
    private String signSN;

    public String getSignSN() {
        return this.signSN;
    }

    public void setSignSN(String signSN) {
        this.signSN = signSN;
    }

    public PdfSignature4KG(String keyPath, int sealNumb, String sealPwd) {
        this.kgElectronicSeal = new KGElectronicSeal(keyPath, sealNumb, sealPwd);
    }

    public PdfSignature4KG(String url, KGServerTypeEnum type, String keySN, String password, String signName) {
        this.kgElectronicSeal = new KGElectronicSeal(url, type, keySN, password, signName);
    }

    public PdfSignature4KG(String url, KGServerTypeEnum type, String keySN, String password, int index) {
        this.kgElectronicSeal = new KGElectronicSeal(url, type, keySN, password, index);
    }

    @Override
    public void before(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        if (this.getImage() == null && this.getQfzSealMap() == null) {
            SealInformation sealInformation = this.kgElectronicSeal.getSeal();
            float width = Float.valueOf(sealInformation.getImgWidth()).floatValue() * this.cm2px();
            float height = Float.valueOf(sealInformation.getImgHeight()).floatValue() * this.cm2px();
            String imgExt = sealInformation.getImgFileExt().substring(1);
            if (this.resetImageWidth != 0.0f && this.resetImageHeight != 0.0f) {
                width = this.resetImageWidth;
                height = this.resetImageHeight;
            }
            this.setImage(sealInformation.getImgValue(), imgExt, (int)width, (int)height);
            this.setSignSN(sealInformation.getSignSN());
            this.kgProperty(pdfReader, sealInformation.getKeySN(), sealInformation.getImgUserName(), sealInformation.getImgUnitName(), sealInformation.getSignSN(), sealInformation.getImgSignName(), "0", "", "127.0.0.1");
            if (this.logEntity != null) {
                this.logEntity.setLogType("00");
                this.logEntity.setLogSort("13");
                this.logEntity.setKeySN(sealInformation.getKeySN());
                this.logEntity.setSignSN(sealInformation.getSignSN());
            }
        }
        this.addText2Img();
    }

    public void resetImageSize(float resetImageWidth, float resetImageHeight) {
        this.resetImageWidth = resetImageWidth;
        this.resetImageHeight = resetImageHeight;
    }

    public void kgProperty(PdfReader pdfReader, String keySN, String userName, String unitName, String signSN, String signName, String signatureType, String mac, String ip) {
        this.kgProperty(pdfReader, keySN, userName, unitName, signSN, signName, signatureType, mac, ip, null, null, null);
    }

    public void kgProperty(PdfReader pdfReader, String keySN, String userName, String unitName, String signSN, String signName, String signatureType, String mac, String ip, String scanStamp, String scanUserId, String scanUserName) {
        String kgProperty = KGPropertyUtils.getKGProperty(pdfReader, keySN, userName, unitName, signSN, signName, signatureType, mac, ip, scanStamp, scanUserId, scanUserName);
        this.setKGProperty(kgProperty.getBytes());
    }
}

