/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PRIndirectReference;
import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfWriter;
import com.kinggrid.img.ImageUtils;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.KGExecute;
import com.kinggrid.pdf.executes.DeleteElectronicSeal;
import com.kinggrid.pdf.executes.DeleteSignature;
import com.kinggrid.pdf.executes.PdfWatermark;
import com.kinggrid.pdf.utils.KGPdfUtils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PdfSeal2GrayImageWatermark {
    private PdfReader pdfReader;
    private PdfStamper pdfStamper;
    private List<PdfWatermark> watermarkExecutes;
    private DeleteElectronicSeal deleteElectronicSeal;
    private DeleteSignature deleteSignature;
    private boolean contentToGray;
    private boolean isKeepImage;
    private Color color = new Color(105, 105, 105);

    public void setColor(Color color) {
        this.color = color;
    }

    public void setKeepImage(boolean isKeepImage) {
        this.isKeepImage = isKeepImage;
    }

    public void setContentToGray(boolean contentToGray) {
        this.contentToGray = contentToGray;
    }

    public PdfSeal2GrayImageWatermark(PdfReader pdfReader, PdfStamper pdfStamper) {
        this.pdfReader = pdfReader;
        this.pdfStamper = pdfStamper;
    }

    public void execute() throws DocumentException, IOException {
        int k = 1;
        while (k <= this.pdfReader.getNumberOfPages()) {
            PdfArray annots;
            PdfDictionary pageN = this.pdfReader.getPageN(k);
            if (this.contentToGray) {
                this.convertToGray(k, pageN);
            }
            if ((annots = pageN.getAsArray(PdfName.ANNOTS)) != null && annots.size() != 0) {
                this.watermarkExecutes = new ArrayList<PdfWatermark>();
                int i = annots.size() - 1;
                while (i >= 0) {
                    PdfDictionary annot = annots.getAsDict(i);
                    if (KGElectronicSealName.SEAL.equals(annot.getAsName(PdfName.SUBTYPE)) || PdfName.SIG.equals(annot.getAsName(PdfName.FT))) {
                        if (KGElectronicSealName.SEAL.equals(annot.getAsName(PdfName.SUBTYPE)) && this.deleteElectronicSeal == null) {
                            this.deleteElectronicSeal = new DeleteElectronicSeal();
                        }
                        if (PdfName.SIG.equals(annot.getAsName(PdfName.FT)) && this.deleteSignature == null) {
                            this.deleteSignature = new DeleteSignature();
                        }
                        Rectangle rectangle = this.getRect(this.pdfReader, k, annot);
                        byte[] imageData = this.getImage(annot);
                        if (imageData != null) {
                            Image image = Image.getInstance(imageData);
                            image.scaleAbsolute(rectangle.getWidth(), rectangle.getHeight());
                            PdfWatermark pdfWatermark = new PdfWatermark();
                            pdfWatermark.setImage(image);
                            pdfWatermark.setPosition(rectangle.getLeft(), rectangle.getBottom());
                            pdfWatermark.setRotation(0.0f);
                            pdfWatermark.setImageTransparent();
                            pdfWatermark.setFillOpacity(1.0f);
                            this.watermarkExecutes.add(pdfWatermark);
                        }
                    }
                    --i;
                }
                this.doExtraExecute(k);
            }
            ++k;
        }
        this.afterExecute();
    }

    private void convertToGray(int k, PdfDictionary pageN) throws IOException, DocumentException {
        PdfWriter writer = this.pdfStamper.getWriter();
        byte[] contentbytes = this.pdfReader.getPageContent(k);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(contentbytes), "ISO-8859-1"));
        String line = null;
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            if (line.contains("1 0 0") && line.toLowerCase().contains("rg")) {
                line = this.changeRedToUserDefinedColor(line);
            }
            sb.append(String.valueOf(line) + "\n");
        }
        String newContent = sb.toString();
        PdfStream newContentStream = new PdfStream(newContent.getBytes("ISO-8859-1"));
        newContentStream.flateCompress();
        PRIndirectReference contents = (PRIndirectReference)pageN.get(PdfName.CONTENTS);
        writer.addToBody((PdfObject)newContentStream, contents);
        PdfDictionary pageResources = this.pdfReader.getPageResources(pageN);
        PdfDictionary xObject = pageResources.getAsDict(PdfName.XOBJECT);
        if (xObject != null) {
            Set<Map.Entry<PdfName, PdfObject>> set = xObject.getKeyValSet();
            for (Map.Entry<PdfName, PdfObject> entry : set) {
                PRIndirectReference ref = (PRIndirectReference)entry.getValue();
                PRStream stream = (PRStream)PdfReader.getPdfObject(ref);
                if (stream.getAsName(PdfName.SUBTYPE).compareTo(PdfName.IMAGE) != 0) continue;
                byte[] grayImage = ImageUtils.getGrayImage(stream, this.color);
                Image image = Image.getInstance(grayImage);
                PdfName newName = writer.addDirectImageSimple(image);
                xObject.put(entry.getKey(), writer.getImageReference(newName));
            }
        }
        this.pdfStamper.markUsed(pageN);
    }

    private byte[] getImage(PdfDictionary annot) throws IOException {
        PdfStream n = annot.getAsDict(PdfName.AP).getAsStream(PdfName.N);
        PdfDictionary xobject = n.getAsDict(PdfName.RESOURCES).getAsDict(PdfName.XOBJECT);
        HashMap<PdfName, PRStream> map = new HashMap<PdfName, PRStream>();
        if (xobject != null) {
            PdfSeal2GrayImageWatermark.getImageObj(map, xobject);
        }
        if (map.containsKey(PdfName.IMAGE)) {
            return ImageUtils.getImage((PRStream)map.get(PdfName.IMAGE), this.color, this.isKeepImage);
        }
        return null;
    }

    private Rectangle getRect(PdfReader pdfReader, int pagen, PdfDictionary annot) {
        Rectangle pageRect = pdfReader.getPageSize(pagen);
        float width = pageRect.getWidth();
        float height = pageRect.getHeight();
        int rotation = pdfReader.getPageRotation(pagen);
        PdfArray asArray = annot.getAsArray(PdfName.RECT);
        Map<String, Float> ll = KGPdfUtils.RotationXY(asArray.getAsNumber(0).floatValue(), asArray.getAsNumber(1).floatValue(), width, height, rotation);
        Map<String, Float> ur = KGPdfUtils.RotationXY(asArray.getAsNumber(2).floatValue(), asArray.getAsNumber(3).floatValue(), width, height, rotation);
        Rectangle rect = new Rectangle(ll.get("x").floatValue(), ll.get("y").floatValue(), ur.get("x").floatValue(), ur.get("y").floatValue());
        rect.normalize();
        return rect;
    }

    private static Map<PdfName, PRStream> getImageObj(Map<PdfName, PRStream> map, PdfDictionary xobject) {
        Set<Map.Entry<PdfName, PdfObject>> entries = xobject.getKeyValSet();
        Iterator<Map.Entry<PdfName, PdfObject>> iterator = entries.iterator();
        PRStream obj = null;
        while (iterator.hasNext()) {
            Map.Entry<PdfName, PdfObject> entry = iterator.next();
            PRIndirectReference ref = (PRIndirectReference)entry.getValue();
            PRStream pdfObject = obj = (PRStream)PdfReader.getPdfObject(ref);
            PdfName subType = pdfObject.getAsName(PdfName.SUBTYPE);
            PdfDictionary resource = pdfObject.getAsDict(PdfName.RESOURCES);
            if (subType != null && "/Image".equals(subType.toString())) {
                map.put(PdfName.IMAGE, obj);
                return map;
            }
            if (resource.size() != 0 && resource.getAsDict(PdfName.XOBJECT) != null && (map = PdfSeal2GrayImageWatermark.getImageObj(map, resource.getAsDict(PdfName.XOBJECT))).size() != 0) break;
        }
        return map;
    }

    private String helperRGB(Color color) {
        StringBuilder sb = new StringBuilder();
        float red = (float)(color.getRed() & 0xFF) / 255.0f;
        float green = (float)(color.getGreen() & 0xFF) / 255.0f;
        float blue = (float)(color.getBlue() & 0xFF) / 255.0f;
        sb.append(red).append(' ').append(green).append(' ').append(blue);
        return sb.toString();
    }

    private void doExtraExecute(int pagen) throws DocumentException, IOException {
        if (this.watermarkExecutes != null) {
            for (PdfWatermark pdfWatermark : this.watermarkExecutes) {
                pdfWatermark.execute(this.pdfReader, this.pdfStamper, pagen);
            }
        }
        if (this.deleteElectronicSeal != null) {
            this.deleteElectronicSeal.execute(this.pdfReader, this.pdfStamper, pagen);
        }
    }

    private void afterExecute() throws DocumentException, IOException {
        if (this.deleteSignature != null) {
            ArrayList<KGExecute> executes = new ArrayList<KGExecute>();
            executes.add(this.deleteSignature);
            this.deleteSignature.setKGHummderExecutes(executes);
            this.deleteSignature.execute(this.pdfReader, this.pdfStamper, 0);
        }
        if (this.deleteElectronicSeal != null) {
            this.pdfStamper.markUsed(this.pdfReader.getCatalog());
        }
        this.pdfStamper.close();
    }

    private String changeRedToUserDefinedColor(String line) {
        String str = line;
        StringBuilder sb = new StringBuilder();
        int lastIndex = str.toLowerCase().indexOf("1 0 0 rg");
        while (lastIndex != -1) {
            sb.append(str.substring(0, lastIndex));
            sb.append(this.helperRGB(this.color));
            str = str.substring(lastIndex + 5);
            lastIndex = str.toLowerCase().indexOf("1 0 0 rg");
        }
        lastIndex = lastIndex == -1 ? 0 : lastIndex;
        sb.append(str.substring(0, str.length()));
        return sb.toString();
    }
}

