/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.kgcore.gb.SealGB;
import com.kinggrid.kgcore.gb.SealUtilGB;
import com.kinggrid.pdf.executes.PdfElectronicSeal;
import com.kinggrid.pdf.utils.ConnectStampSystemUtil;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;

public class PdfElectronicSeal4GB
extends PdfElectronicSeal {
    private String url;
    private String esid;
    private String appid;
    private String salt;

    public PdfElectronicSeal4GB(String url, String salt, String appid, String esid) {
        this.url = url;
        this.salt = salt;
        this.appid = appid;
        this.esid = esid;
    }

    @Override
    public void before(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
        try {
            ConnectStampSystemUtil cUtil = new ConnectStampSystemUtil(this.url, this.salt, this.appid, this.esid);
            JSONObject retObj = cUtil.getSealByEsid();
            KGBase64 base64 = new KGBase64();
            byte[] sealData = base64.decode(retObj.getString("sealData"));
            String userName = retObj.getString("userName");
            String orgName = retObj.getString("orgName");
            String keySn = retObj.getString("keySn");
            SealGB sealGB = SealUtilGB.getSeal(sealData);
            sealGB.setUserName(userName);
            sealGB.setOrgName(orgName);
            sealGB.setKeySn(keySn);
            this.setImage(sealGB.getImgb(), sealGB.getSealType(), (int)((float)sealGB.getWidth() * 720.0f / 254.0f), (int)((float)sealGB.getHeight() * 720.0f / 254.0f));
            this.setSealMsg(sealGB.getKeySn(), sealGB.getOrgName(), sealGB.getKeySn(), sealGB.getEsid(), sealGB.getSealName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        super.before(pdfReader, pdfStamper);
    }
}

