/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf.executes;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfBoolean;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectObject;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfWriter;
import com.kinggrid.authorization.AuthorizationType;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.KGElectronicSealName;
import com.kinggrid.pdf.KGExecute;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@AuthorizationType(hasAuth=true)
public class DeviateProtectElectronicSeal
extends KGExecute {
    @Override
    protected void execute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        PdfDictionary page = pdfReader.getPageN(pagen);
        PdfArray annots = page.getAsArray(PdfName.ANNOTS);
        if (annots != null) {
            int i = 0;
            while (i < annots.size()) {
                PdfDictionary info;
                PdfDictionary annot = annots.getAsDict(i);
                if (annot != null && KGElectronicSealName.SEAL.equals(annot.getAsName(PdfName.SUBTYPE)) && (info = annot.getAsDict(PdfName.INFO)) != null) {
                    PdfBoolean unicode = info.getAsBoolean(KGElectronicSealName.UNICODE);
                    boolean isUnicode = false;
                    if (unicode != null) {
                        isUnicode = unicode.booleanValue();
                    }
                    String charSet = "GBK";
                    if (isUnicode) {
                        charSet = "UTF-16LE";
                    }
                    PRStream baseInfo = (PRStream)info.getAsStream(KGElectronicSealName.BASEINFO);
                    byte[] baseInfob = PdfReader.getStreamBytes(baseInfo);
                    KGBase64 base64 = new KGBase64();
                    base64.setBase64Table("=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
                    String sealDetail = new String(base64.decode(new String(baseInfob)), charSet);
                    Map<String, String> map = this.getBaseInfo(sealDetail);
                    int protectDoc = Integer.valueOf(map.get("bProtectDoc"));
                    if (protectDoc != 0) {
                        protectDoc = 0;
                    }
                    map.put("bProtectDoc", String.valueOf(protectDoc));
                    String sealMsg = base64.encode(this.getBaseInfo(map).getBytes("UTF-16LE"));
                    PdfStream baseInfoStream = new PdfStream(sealMsg.getBytes());
                    PdfNumber pdfNumber = new PdfNumber(sealMsg.length());
                    PdfWriter pdfWriter = pdfStamper.getWriter();
                    PdfIndirectObject pdfNumberIndObj = pdfWriter.addToBody(pdfNumber);
                    baseInfoStream.put(KGElectronicSealName.STRLEN, pdfNumberIndObj.getIndirectReference());
                    PdfIndirectObject baseInfoIndObj = pdfWriter.addToBody(baseInfoStream);
                    info.put(KGElectronicSealName.BASEINFO, baseInfoIndObj.getIndirectReference());
                    pdfStamper.markUsed(info);
                    pdfStamper.markUsed(annot);
                    pdfStamper.markUsed(annots);
                    pdfStamper.markUsed(page);
                }
                ++i;
            }
        }
    }

    private Map<String, String> getBaseInfo(String string) {
        String[] strings;
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = strings = string.split("\r\n");
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            int indx = str.indexOf("=");
            if (indx != -1) {
                map.put(str.substring(0, indx), str.substring(indx + 1));
            }
            ++n2;
        }
        return map;
    }

    private String getBaseInfo(Map<String, String> map) {
        StringBuilder builder = new StringBuilder();
        Set<String> keys = map.keySet();
        for (String key : keys) {
            builder.append(String.valueOf(key) + "=" + map.get(key)).append("\r\n");
        }
        return builder.toString();
    }
}

