/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.kgcore.gb;

import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.kgcore.gb.SealGB;
import java.io.IOException;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERGeneralizedTime;
import org.kg.bouncycastle.asn1.DERIA5String;
import org.kg.bouncycastle.asn1.DERInteger;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DERUTF8String;
import org.kg.bouncycastle.asn1.DLSequence;

public class SealUtilGB {
    public static SealGB getSeal(byte[] bytes) throws IOException {
        ASN1InputStream asn1InputStream = new ASN1InputStream(bytes);
        try {
            ASN1Sequence sequence = (ASN1Sequence)asn1InputStream.readObject();
            asn1InputStream.close();
            ASN1Sequence signInfo = (ASN1Sequence)sequence.getObjectAt(0);
            String esID = signInfo.getObjectAt(1).toString();
            DLSequence propertyInfo = (DLSequence)signInfo.getObjectAt(2);
            DERInteger sealType = (DERInteger)propertyInfo.getObjectAt(0);
            DERUTF8String sealName = (DERUTF8String)propertyInfo.getObjectAt(1);
            DLSequence certList = (DLSequence)propertyInfo.getObjectAt(3);
            DEROctetString cert = (DEROctetString)certList.getObjectAt(0);
            KGBase64 base64 = new KGBase64();
            String str = base64.encode(cert.getOctets());
            String createDate = ((DERGeneralizedTime)propertyInfo.getObjectAt(4)).getTimeString();
            String validStart = ((DERGeneralizedTime)propertyInfo.getObjectAt(5)).getTimeString();
            String validEnd = ((DERGeneralizedTime)propertyInfo.getObjectAt(6)).getTimeString();
            DLSequence picInfo = (DLSequence)signInfo.getObjectAt(3);
            DERIA5String sealPicType = (DERIA5String)picInfo.getObjectAt(0);
            DEROctetString sealPicData = (DEROctetString)picInfo.getObjectAt(1);
            DERInteger sealPicWidth = (DERInteger)picInfo.getObjectAt(2);
            DERInteger sealPicHeight = (DERInteger)picInfo.getObjectAt(3);
            DEROctetString signCertInfo = (DEROctetString)sequence.getObjectAt(1);
            SealGB seal = new SealGB();
            seal.setEsid(esID);
            seal.setSealType(sealType.toString());
            seal.setSealName(sealName.toString());
            seal.setWidth(Integer.parseInt(sealPicWidth.toString()));
            seal.setHeight(Integer.parseInt(sealPicHeight.toString()));
            seal.setCreateDate(KGDateUtils.date(KGDateUtils.parseZ2Date(createDate)));
            seal.setValidStart(KGDateUtils.date(KGDateUtils.parseZ2Date(validStart)));
            seal.setValidEnd(KGDateUtils.date(KGDateUtils.parseZ2Date(validEnd)));
            seal.setProductCertData(base64.encode(signCertInfo.getOctets()));
            seal.setSignatureCertData(str);
            seal.setSignData(base64.encode(sealPicData.getOctets()));
            seal.setSealPicType(sealPicType.getString());
            seal.setImgb(sealPicData.getOctets());
            seal.setCert(cert.getOctets());
            SealGB sealGB = seal;
            return sealGB;
        }
        finally {
            if (asn1InputStream != null) {
                asn1InputStream.close();
            }
        }
    }
}

