/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.kgcore;

import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.encrypt.MD5;
import com.kinggrid.exception.KGServerInterfaceErrorException;
import com.kinggrid.kgcore.IMsgServer;
import com.kinggrid.kgcore.LogEntity;
import com.kinggrid.kgcore.SealInformation;
import com.kinggrid.kgcore.enmu.KGQueryByEnum;
import com.kinggrid.kgcore.enmu.KGSealTypeEnum;
import com.kinggrid.kgcore.enmu.KGServerTypeEnum;
import com.kinggrid.kgcore.enmu.LanguageEnum;
import com.kinggrid.kgcore.gm.SealGM;
import com.kinggrid.kgcore.gm.SealUtil;
import com.kinggrid.pdf.utils.VerifySealUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERSequence;

public class KGHttpUtils {
    public static final String DELETESEAL = "14";
    private static final String CHARSET = "GBK";
    private KGQueryByEnum queryBy;
    private String authOrizeCode;
    private LanguageEnum language = LanguageEnum.ZH_CN;
    private KGSealTypeEnum sealType;

    public KGHttpUtils() {
        this.queryBy = KGQueryByEnum.KEYSN;
    }

    public KGQueryByEnum getQueryBy() {
        return this.queryBy;
    }

    public void setQueryBy(KGQueryByEnum queryBy) {
        this.queryBy = queryBy;
    }

    public String getAuthOrizeCode() {
        return this.authOrizeCode;
    }

    public void setAuthOrizeCode(String authOrizeCode) {
        this.authOrizeCode = authOrizeCode;
    }

    public LanguageEnum getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageEnum language) {
        this.language = language;
    }

    public KGSealTypeEnum getSealType() {
        return this.sealType;
    }

    public void setSealType(KGSealTypeEnum sealType) {
        this.sealType = sealType;
    }

    public void modifyUserPwdByKeySN(String url, String keySN, String originalPwd, String newPwd) throws Exception {
        this.modifyUserPwd(url, keySN, null, originalPwd, newPwd);
    }

    public void modifyUserPwdByUserCode(String url, String userCode, String originalPwd, String newPwd) throws Exception {
        this.modifyUserPwd(url, null, userCode, originalPwd, newPwd);
    }

    private void modifyUserPwd(String url, String keySN, String userCode, String originalPwd, String newPwd) throws Exception {
        IMsgServer msgServer;
        Pattern p = Pattern.compile("[0-9a-zA-z,!,@,#,$,%,^,&,*,~]{6,16}");
        Matcher m = p.matcher(newPwd);
        if (m.matches()) {
            msgServer = new IMsgServer();
            msgServer.setCharset(CHARSET);
            msgServer.SetMsgByName("OPTION", "MODIFYVIRTUALPASSWORD2");
            if (keySN != null) {
                msgServer.SetMsgByName("KEYSN", keySN);
            } else {
                msgServer.SetMsgByName("USERCODE", userCode);
            }
        } else {
            throw new IllegalArgumentException("\u5bc6\u7801\u5fc5\u987b\u4e3a\u6570\u5b57\u82f1\u6587\u5b57\u6bcd\u7b49\uff0c\u4e0d\u80fd\u4f7f\u7528\u4e2d\u6587.\u4e14\u5bc6\u7801\u957f\u5ea6\u4e3a6-16\u4f4d.");
        }
        msgServer.SetMsgByName("PASSWORD", originalPwd);
        msgServer.SetMsgByName("NEWPWD", newPwd);
        this.sendPacktToServer(url, msgServer);
    }

    public Map<String, Object> sign(String url, String keySN, byte[] text, String encryptionAlgorithm) {
        return this.sign(url, keySN, null, text, encryptionAlgorithm);
    }

    public Map<String, Object> sign(String url, String keySN, String signSN, byte[] text, String encryptionAlgorithm) {
        IMsgServer msgServer = new IMsgServer();
        KGBase64 base64 = new KGBase64();
        msgServer.setCharset(CHARSET);
        msgServer.SetMsgByName("OPTION", "SIGNCONTEXT");
        msgServer.SetMsgByName("RSAORSM2", encryptionAlgorithm);
        msgServer.SetMsgByName("KEYSN", keySN);
        msgServer.SetMsgByName("SIGNSN", signSN);
        msgServer.SetMsgByName("CERTTEXT", text == null ? "" : base64.encode(text));
        this.sendPacktToServer(url, msgServer);
        if ("OK".equals(msgServer.GetMsgByName("STATUS"))) {
            byte[] cert = base64.decode(msgServer.GetMsgByName("CERTCONTEXT"));
            byte[] signData = base64.decode(msgServer.GetMsgByName("SIGNRESULT"));
            String chain = msgServer.GetMsgByName("CHAIN");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("certBytes", cert);
            map.put("signData", signData);
            map.put("chain", chain);
            return map;
        }
        throw new RuntimeException(String.valueOf(keySN) + " : " + msgServer.MsgError());
    }

    public List<SealInformation> getServerSeal(String url, KGServerTypeEnum serverTypeEnum, String keySN, String sealName) {
        if (serverTypeEnum == KGServerTypeEnum.GA) {
            return this.getGAServerSeal(url, keySN, sealName);
        }
        if (this.sealType == KGSealTypeEnum.GM) {
            return this.getServerGMSeal(url, serverTypeEnum, keySN, sealName);
        }
        IMsgServer msgServer = new IMsgServer();
        msgServer.setCharset(CHARSET);
        msgServer.SetMsgByName("OPTION", "GETNETFILESIGNATURES");
        if (KGQueryByEnum.KEYSN == this.queryBy) {
            msgServer.SetMsgByName("VIRTUALKEYNUMBER", keySN);
        } else if (KGQueryByEnum.USERCODE == this.queryBy) {
            msgServer.SetMsgByName("USERCODE", keySN);
        }
        msgServer.SetMsgByName("SIGNATURENAME", sealName);
        this.sendPacktToServer(url, msgServer);
        String userInfo = msgServer.GetMsgByName("USERINFO");
        String netFileSignatures = msgServer.GetMsgByName("NETFILESIGNATURES");
        String phone = msgServer.GetMsgByName("PHONE");
        if (netFileSignatures != null && !"".equals(netFileSignatures)) {
            return this.parseUserAndSignaturesInfo(userInfo, netFileSignatures, phone, serverTypeEnum);
        }
        return null;
    }

    public List<SealInformation> parseUserAndSignaturesInfo(String userInfo, String netFileSignatures, String phone, KGServerTypeEnum serverTypeEnum) {
        ArrayList<SealInformation> list = new ArrayList<SealInformation>();
        if (netFileSignatures == null || "".equals(netFileSignatures)) {
            throw new IllegalArgumentException("\u5370\u7ae0\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a");
        }
        if (userInfo == null || "".equals(userInfo)) {
            throw new IllegalArgumentException("\u7528\u6237\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a");
        }
        String[] tmp = userInfo.split(",");
        String[] signDatas = netFileSignatures.split(";");
        String signData = null;
        SealInformation sealInformation = null;
        if (signDatas != null && signDatas.length > 0) {
            int i = 0;
            while (i < signDatas.length) {
                sealInformation = new SealInformation();
                sealInformation.setPhone(phone);
                sealInformation.setImgUserName(tmp[1]);
                sealInformation.setKeySN(tmp[0]);
                sealInformation.setKeySerial(tmp[0]);
                sealInformation.setKeyPwd(tmp[3]);
                sealInformation.setImgSignPass(tmp[3]);
                sealInformation.setImgUnitName(tmp[2]);
                signData = signDatas[i];
                String[] signParams = signData.split(",");
                if (signParams.length > 2) {
                    sealInformation.setImgSignName(signParams[1]);
                }
                this.parserSignData(signData, serverTypeEnum, sealInformation);
                list.add(sealInformation);
                ++i;
            }
        }
        return list;
    }

    public List<SealInformation> parseUserAndSignaturesInfo(String userInfo, String netFileSignatures, KGServerTypeEnum serverTypeEnum) {
        return this.parseUserAndSignaturesInfo(userInfo, netFileSignatures, null, serverTypeEnum);
    }

    public List<SealInformation> getServerGMSeal(String url, KGServerTypeEnum serverTypeEnum, String keySN, String sealName) {
        IMsgServer msgServer = new IMsgServer();
        msgServer.setCharset(CHARSET);
        msgServer.SetMsgByName("OPTION", "GETSIGNATUREBYSM2");
        if (KGQueryByEnum.KEYSN == this.queryBy) {
            msgServer.SetMsgByName("VIRTUALKEYNUMBER", keySN);
        } else if (KGQueryByEnum.USERCODE == this.queryBy) {
            msgServer.SetMsgByName("USERCODE", keySN);
        }
        msgServer.SetMsgByName("SIGNATURENAME", sealName);
        this.sendPacktToServer(url, msgServer);
        String userInfo = msgServer.GetMsgByName("USERINFO");
        String netFileSignatures = msgServer.GetMsgByName("NETFILESIGNATURES");
        String phone = msgServer.GetMsgByName("PHONE");
        if (netFileSignatures != null && !"".equals(netFileSignatures)) {
            ArrayList<SealInformation> list = new ArrayList<SealInformation>();
            String[] tmp = userInfo.split(",");
            String[] signDatas = netFileSignatures.split(";");
            String signData = null;
            SealInformation sealInformation = null;
            if (signDatas != null && signDatas.length > 0) {
                int i = 0;
                while (i < signDatas.length) {
                    sealInformation = new SealInformation();
                    sealInformation.setImgUserName(tmp[1]);
                    sealInformation.setKeySN(tmp[0]);
                    sealInformation.setKeySerial(tmp[0]);
                    sealInformation.setKeyPwd(tmp[3]);
                    sealInformation.setImgSignPass(tmp[3]);
                    sealInformation.setImgUnitName(tmp[2]);
                    sealInformation.setPhone(phone);
                    signData = signDatas[i];
                    String[] signParams = signData.split(",");
                    String signsn = signParams[0];
                    if (signParams.length > 2) {
                        sealInformation.setImgSignName(signParams[1]);
                    }
                    sealInformation.setSignSN(signsn);
                    sealInformation.setImgWidth(signParams[3]);
                    sealInformation.setImgHeight(signParams[4]);
                    String imageExt = signParams[2];
                    if (!imageExt.contains(".")) {
                        imageExt = "." + imageExt;
                    }
                    if (!".kgf".equals(imageExt)) {
                        String imageData = signParams[5];
                        try {
                            KGBase64 base64 = new KGBase64();
                            byte[] gmData = base64.decode(imageData);
                            VerifySealUtil verifySealUtil = new VerifySealUtil();
                            ASN1Sequence sequence = DERSequence.getInstance((Object)gmData);
                            verifySealUtil.asn1SealComplete(sequence);
                            verifySealUtil.verifySeal(gmData);
                            SealGM seal = SealUtil.getSealInfo(gmData);
                            sealInformation.setImgValue(seal.getPicData());
                            sealInformation.setSealData(imageData);
                            sealInformation.setImgFileExt(imageExt);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u5931\u8d25\uff1a\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u5931\u8d25\uff01");
                        }
                        if (signParams.length > 6) {
                            sealInformation.setImgType(signParams[6]);
                        }
                        list.add(sealInformation);
                    }
                    ++i;
                }
            }
            return list;
        }
        return null;
    }

    public List<SealInformation> getGAServerSeal(String url, String keySN, String sealName) {
        IMsgServer msgServer = new IMsgServer();
        msgServer.setCharset(CHARSET);
        msgServer.SetMsgByName("OPTION", "CHECKSIGNBYALL");
        msgServer.SetMsgByName("COMMAND", "GETKEYSIGNINFO");
        msgServer.SetMsgByName("SIGNPRIORPUB", "8");
        msgServer.SetMsgByName("KEYSN", keySN);
        this.sendPacktToServer(url, msgServer);
        String signsString = msgServer.GetMsgByName("SIGNPOWER");
        ArrayList<SealInformation> list = new ArrayList<SealInformation>();
        if (signsString == null) {
            return list;
        }
        String[] signs = signsString.split(";");
        SealInformation sealInformation = null;
        String signImageData = null;
        int i = 0;
        while (i < signs.length) {
            sealInformation = new SealInformation();
            String[] sign = signs[i].split(",");
            sealInformation.setKeySN(keySN);
            sealInformation.setSignSN(sign[0]);
            sealInformation.setImgSignName(msgServer.DecodeBase64(sign[2]));
            sealInformation.setImgUnitName(msgServer.DecodeBase64(sign[10]));
            sealInformation.setImgUserName(msgServer.DecodeBase64(sign[12]));
            sealInformation.setImgFileExt(sign[4]);
            sealInformation.setImgWidth(sign[5]);
            sealInformation.setImgHeight(sign[6]);
            signImageData = sign[9];
            this.parserSignData(signImageData, KGServerTypeEnum.GA, sealInformation);
            list.add(sealInformation);
            ++i;
        }
        return list;
    }

    public void parserSignData(String signData, KGServerTypeEnum serverTypeEnum, SealInformation sealInformation) {
        if (!"".equalsIgnoreCase(signData)) {
            if (KGServerTypeEnum.GA == serverTypeEnum) {
                this.parserSignData4GA(signData, sealInformation);
                return;
            }
            String[] tmp = signData.split(",");
            sealInformation.setFileName(String.valueOf(tmp[1]) + tmp[2]);
            sealInformation.setSignSN(tmp[0]);
            sealInformation.setKeySerial(tmp[1]);
            sealInformation.setImgFileExt(tmp[2]);
            sealInformation.setImgWidth(tmp[3]);
            sealInformation.setImgHeight(tmp[4]);
            if (KGServerTypeEnum.AUTO == serverTypeEnum) {
                String signSN = sealInformation.getSignSN();
                String keysnMd5 = MD5.stringToMD5(sealInformation.getKeySN(), "UTF-8").toUpperCase();
                if (tmp[5].startsWith(keysnMd5)) {
                    this.parserSignData2byte(tmp[5], sealInformation);
                } else if (signSN.startsWith("{")) {
                    String base64Table = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
                    this.parserImageData(tmp[5], base64Table, sealInformation);
                } else {
                    this.parserSignData4NET(tmp[5], sealInformation);
                }
            } else if (KGServerTypeEnum.NET == serverTypeEnum) {
                this.parserSignData4NET(tmp[5], sealInformation);
            } else {
                this.parserSignData2byte(tmp[5], sealInformation);
            }
            if (".bmp".equals(sealInformation.getImgFileExt())) {
                byte[] imgValue = sealInformation.getImgValue();
                sealInformation.setImgValue(this.getDecompressedBmp(imgValue));
            }
            if (tmp.length > 6) {
                sealInformation.setImgType(tmp[6]);
            }
        }
    }

    private void parserSignData4NET(String signData, SealInformation sealInformation) {
        String base64Table = signData.substring(0, 65);
        String imageData = signData.substring(65);
        sealInformation.setImgTableBase64(base64Table);
        this.parserImageData(imageData, base64Table, sealInformation);
    }

    private void parserSignData4GA(String signData, SealInformation sealInformation) {
        String base64Table = "=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        String imageData = signData.substring(65);
        sealInformation.setImgTableBase64(base64Table);
        this.parserImageData(imageData, base64Table, sealInformation);
    }

    private void parserSignData2byte(String signData, SealInformation sealInformation) {
        String base64Table = signData.substring(32, 97);
        String imageData = signData.substring(97);
        sealInformation.setImgTableBase64(base64Table);
        this.parserImageData(imageData, base64Table, sealInformation);
    }

    private void parserImageData(String imageData, String base64Table, SealInformation sealInformation) {
        KGBase64 base64 = new KGBase64();
        base64.setBase64Table(base64Table);
        sealInformation.setImgValue(base64.decode(imageData));
    }

    private byte[] getDecompressedBmp(byte[] imgb) {
        byte[] img = new byte[imgb.length - 4];
        System.arraycopy(imgb, 4, img, 0, img.length);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = null;
        try {
            try {
                is = new InflaterInputStream(new ByteArrayInputStream(img));
                int len = 0;
                byte[] bytes = new byte[1024];
                while ((len = is.read(bytes)) != -1) {
                    baos.write(bytes, 0, len);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return baos.toByteArray();
    }

    public void saveLog(String url, LogEntity logEntity) {
        IMsgServer msgServer = new IMsgServer();
        msgServer.SetMsgByName("DBSTEP", "DBSTEP");
        msgServer.SetMsgByName("OPTION", "SAVELOG");
        msgServer.SetMsgByName("KEYSN", logEntity.getKeySN());
        msgServer.SetMsgByName("SIGNSN", logEntity.getSignSN());
        msgServer.SetMsgByName("LOGSORT", logEntity.getLogSort());
        msgServer.SetMsgByName("LOGTYPE", logEntity.getLogType());
        msgServer.SetMsgByName("LOGIP", logEntity.getLogIP());
        msgServer.SetMsgByName("LOGMEMO", logEntity.getLogMemo());
        msgServer.SetMsgByName("DOCUMENTID", logEntity.getDocumentID());
        msgServer.SetMsgByName("DOCUMENTNAME", logEntity.getDocumentName());
        msgServer.SetMsgByName("EXTPARAM1", logEntity.getExtparam1());
        msgServer.SetMsgByName("EXTPARAM2", logEntity.getExtparam2());
        this.sendPacktToServer(url, msgServer);
    }

    public void sendPacktToServer(String url, IMsgServer msgServer) {
        OutputStream outStream = null;
        InputStream inputStream = null;
        msgServer.SetMsgByName("DBSTEP", "DBSTEP");
        msgServer.SetMsgByName("AUTHORIZECODE", this.authOrizeCode);
        msgServer.SetMsgByName("LOCALE", this.language.toString());
        HttpURLConnection connection = null;
        KGHttpUtils.init();
        try {
            try {
                URL objUrl = new URL(url);
                connection = (HttpURLConnection)objUrl.openConnection();
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                connection.connect();
                outStream = connection.getOutputStream();
                byte[] databytes = msgServer.MsgVariant();
                outStream.write(databytes);
                outStream.flush();
                inputStream = connection.getInputStream();
                byte[] packData = this.readPack(inputStream);
                msgServer.MsgTextClear();
                msgServer.MsgVariant(packData);
                if (msgServer.MsgError() != null && !"".equals(msgServer.MsgError())) {
                    throw new KGServerInterfaceErrorException(msgServer.MsgError());
                }
            }
            catch (MalformedURLException var13) {
                throw new RuntimeException(var13);
            }
            catch (IOException var14) {
                throw new RuntimeException(var14);
            }
        }
        catch (Throwable throwable) {
            this.close(outStream);
            this.close(inputStream);
            if (connection != null) {
                connection.disconnect();
            }
            throw throwable;
        }
        this.close(outStream);
        this.close(inputStream);
        if (connection != null) {
            connection.disconnect();
        }
    }

    public static void init() {
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }
            }};
            sc.init(null, tm, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] readPack(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(is);
        byte[] buf = new byte[1024];
        boolean var5 = true;
        while ((length = bufferedInputStream.read(buf)) != -1) {
            byteArrayOutputStream.write(buf, 0, length);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void close(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

