/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.img.seal;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class SquareSeal {
    private int imageWidth = 100;
    private int imageHigth = 105;
    private String text;
    private Font textFont = new Font("\u5b8b\u4f53", 1, 40);
    private Color textColor = Color.red;
    private int border = 5;

    public byte[] squarePng() throws IOException {
        BufferedImage image = new BufferedImage(this.imageWidth, this.imageHigth, 1);
        Graphics2D g2D = (Graphics2D)image.getGraphics();
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2D.setColor(this.textColor);
        g2D.fillRect(0, 0, this.imageWidth, this.imageHigth);
        g2D.setColor(Color.white);
        g2D.fillRect(this.border, this.border, this.imageWidth - this.border * 2, this.imageHigth - this.border * 2);
        g2D.setColor(this.textColor);
        g2D.setFont(this.textFont);
        if (this.text != null && !"".equals(this.text)) {
            FontMetrics fontMetrics = g2D.getFontMetrics(this.textFont);
            int lineWidth = fontMetrics.stringWidth(this.text);
            int height = fontMetrics.getHeight() - fontMetrics.getAscent() / 2;
            int width = this.imageWidth - 2 * this.border;
            if (lineWidth <= width) {
                int dis = width - lineWidth;
                int space = dis / (this.text.length() + 1);
                int start = this.border;
                int i = 0;
                while (i < this.text.length()) {
                    String c = String.valueOf(this.text.charAt(i));
                    int cWidth = fontMetrics.stringWidth(c);
                    g2D.drawString(c, (float)(start += space), (float)(this.imageHigth + height) / 2.0f);
                    start += cWidth;
                    ++i;
                }
            } else {
                float dis = (float)width / (float)(this.text.length() + 1);
                int i = 0;
                while (i < this.text.length()) {
                    String c = String.valueOf(this.text.charAt(i));
                    int cWidth = fontMetrics.stringWidth(c);
                    int start = (int)((float)this.border + dis * (float)(i + 1) - (float)(cWidth / 2));
                    g2D.drawString(c, (float)start, (float)(this.imageHigth + height) / 2.0f);
                    ++i;
                }
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHigth() {
        return this.imageHigth;
    }

    public void setImageHigth(int imageHigth) {
        this.imageHigth = imageHigth;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setText(String text, Font font) {
        this.text = text;
        this.textFont = font;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        SquareSeal square = new SquareSeal();
        square.setImageWidth(113);
        square.setImageHigth(42);
        square.setText("\u4e07\u5148\u4e07", new Font("\u5b8b\u4f53", 1, 25));
        square.setTextColor(new Color(Integer.parseInt("FF0000", 16)));
        square.setBorder(3);
        byte[] bs = square.squarePng();
        FileOutputStream file = new FileOutputStream(new File("d:/tmp/square.png"));
        file.write(bs);
    }
}

