/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.img;

import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfString;
import com.KGitextpdf.text.pdf.parser.PdfImageObject;
import com.kinggrid.img.KGTextInfo;
import com.kinggrid.img.TextInfoPosType;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ImageUtils {
    private static BufferedImage _arrange(BufferedImage bi) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(bi.getWidth(), bi.getHeight(), 9);
        Graphics2D g2D = (Graphics2D)bufferedImage.getGraphics();
        g2D.drawImage((Image)bi, 0, 0, null);
        g2D.dispose();
        return bufferedImage;
    }

    private static boolean isNeedArrange(BufferedImage bi) {
        int rgb = bi.getRGB(1, 1);
        int R = (rgb & 0xFF0000) >> 16;
        int G = (rgb & 0xFF00) >> 8;
        int B = rgb & 0xFF;
        return rgb == -1 && R == 255 && G == 255 && B == 255 && 13 == bi.getType();
    }

    public static BufferedImage arrange(byte[] imgdata) throws IOException {
        BufferedImage bi = ImageIO.read(new ByteArrayInputStream(imgdata));
        if (ImageUtils.isNeedArrange(bi)) {
            bi = ImageUtils._arrange(bi);
        }
        return bi;
    }

    public static BufferedImage invalidImg(BufferedImage bi, double percent) {
        Graphics2D g = bi.createGraphics();
        g.setColor(new Color(128, 128, 128));
        double height = (float)(30.0 * percent);
        int start = (int)((double)(bi.getHeight() / 2) - height / 2.0);
        g.fillRect(0, start, bi.getWidth(), (int)(height / 3.0));
        g.fillRect(0, (int)((double)start + height / 3.0 * 2.0), bi.getWidth(), (int)(height / 3.0));
        g.dispose();
        return bi;
    }

    public static BufferedImage invalidImg(BufferedImage bi, double Xpercent, double Ypercent) {
        Graphics2D g = bi.createGraphics();
        g.setColor(new Color(128, 128, 128));
        double height = (float)(30.0 * Ypercent);
        double width = (float)(30.0 * Xpercent);
        int start = (int)((double)(bi.getHeight() / 2) - height / 2.0);
        g.fillRect(0, start, bi.getWidth(), (int)(width / 3.0));
        g.fillRect(0, (int)((double)start + height / 3.0 * 2.0), bi.getWidth(), (int)(height / 3.0));
        g.dispose();
        return bi;
    }

    public static BufferedImage resize(BufferedImage image, double scaleX, double scaleY) {
        AffineTransform transform = AffineTransform.getScaleInstance(scaleX, scaleY);
        AffineTransformOp op = new AffineTransformOp(transform, 1);
        return op.filter(image, null);
    }

    public static BufferedImage resize(BufferedImage image, double scale) {
        return ImageUtils.resize(image, scale, scale);
    }

    public static BufferedImage decrypt(BufferedImage bi) {
        int j1 = bi.getMinY();
        while (j1 < bi.getHeight()) {
            int j2 = bi.getMinX();
            while (j2 < bi.getWidth()) {
                int rgb = bi.getRGB(j2, j1);
                int R = (rgb & 0xFF0000) >> 16;
                int G = (rgb & 0xFF00) >> 8;
                int B = rgb & 0xFF;
                rgb = 255 - R < 30 && 255 - G < 30 && 255 - B < 30 || rgb == 0 ? -2894893 : -12434878;
                bi.setRGB(j2, j1, rgb);
                ++j2;
            }
            ++j1;
        }
        return bi;
    }

    public static BufferedImage alpha(BufferedImage bi) {
        ImageIcon imageIcon = new ImageIcon(bi);
        BufferedImage _bi = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 7);
        Graphics2D g2D = (Graphics2D)_bi.getGraphics();
        g2D.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
        int alpha = 0;
        int j1 = _bi.getMinY();
        while (j1 < _bi.getHeight()) {
            int j2 = _bi.getMinX();
            while (j2 < _bi.getWidth()) {
                int rgb = _bi.getRGB(j2, j1);
                int R = (rgb & 0xFF0000) >> 16;
                int G = (rgb & 0xFF00) >> 8;
                int B = rgb & 0xFF;
                if (255 - R < 30 && 255 - G < 30 && 255 - B < 30) {
                    rgb = alpha + 1 << 24 | rgb & 0xFFFFFF;
                }
                _bi.setRGB(j2, j1, rgb);
                ++j2;
            }
            ++j1;
        }
        return _bi;
    }

    private static List<String> paragraphingText(String text, Graphics2D g2D, Font font, float width, float textWidth, boolean isBreakWord) {
        ArrayList<String> lineList = new ArrayList<String>();
        if (!isBreakWord || textWidth < width) {
            lineList.add(text);
        } else {
            double lines = textWidth / width;
            int lineCharCount = (int)Math.ceil((double)text.length() / lines);
            int beginIndex = 0;
            while (beginIndex < text.length()) {
                int endIndex = beginIndex + lineCharCount;
                if (endIndex >= text.length()) {
                    endIndex = text.length();
                }
                String lineText = text.substring(beginIndex, endIndex);
                FontMetrics fontMetrics = g2D.getFontMetrics();
                int lineWidth = fontMetrics.stringWidth(lineText);
                while ((float)lineWidth > width) {
                    lineText = lineText.substring(0, lineText.length() - 1);
                    lineWidth = fontMetrics.stringWidth(lineText);
                }
                lineList.add(lineText);
                beginIndex += lineText.length();
            }
        }
        return lineList;
    }

    public static BufferedImage addText(BufferedImage bi, List<KGTextInfo> textInfoList) {
        int dis;
        int height;
        FontMetrics fontMetrics;
        Font font;
        if (textInfoList == null || textInfoList.size() == 0) {
            return bi;
        }
        BufferedImage oldbi = bi;
        int oriWidth = oldbi.getWidth(null);
        int oriHeight = oldbi.getHeight(null);
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        ArrayList<KGTextInfo> outText = new ArrayList<KGTextInfo>();
        Graphics2D g2D = (Graphics2D)oldbi.getGraphics();
        int i = 0;
        while (i < textInfoList.size()) {
            float minWidth;
            float lineWidth;
            KGTextInfo textInfo = textInfoList.get(i);
            String signText = textInfo.getSignText();
            font = new Font(textInfo.getFontName(), textInfo.getFontStyle(), textInfo.getFontSize());
            g2D.setFont(font);
            g2D.setColor(new Color(textInfo.getFontColor()));
            fontMetrics = g2D.getFontMetrics();
            int textWidth = fontMetrics.stringWidth(signText);
            height = fontMetrics.getHeight();
            dis = height - font.getSize();
            List<String> lines = null;
            if (textInfo.getPosType() == TextInfoPosType.XY) {
                float x = 0.0f;
                float y = 0.0f;
                lineWidth = 0.0f;
                if (!textInfo.isCenter()) {
                    x = textInfo.getX();
                    lineWidth = (float)oriWidth - x;
                    lines = ImageUtils.paragraphingText(signText, g2D, font, lineWidth, textWidth, textInfo.isBreakWord());
                    y = (float)oriHeight - textInfo.getY() - (float)(height * (lines.size() - 1)) - (float)dis;
                } else {
                    lineWidth = textWidth < oriWidth ? textWidth : oriWidth;
                    minWidth = textInfo.getX() < (float)(oriWidth / 2) ? textInfo.getX() : (float)oriWidth - textInfo.getX();
                    lineWidth = minWidth < lineWidth / 2.0f ? minWidth * 2.0f : lineWidth;
                    lines = ImageUtils.paragraphingText(signText, g2D, font, lineWidth, textWidth, textInfo.isBreakWord());
                    lineWidth = textInfo.isBreakWord() ? lineWidth : (float)textWidth;
                    x = textInfo.getX() - lineWidth / 2.0f;
                    y = (float)oriHeight - textInfo.getY() - (float)(height * (lines.size() / 2 - 1)) - (float)dis;
                }
                for (String text : lines) {
                    if (y <= (float)oriHeight && y >= (float)height) {
                        g2D.drawString(text, x, y);
                    }
                    y += (float)height;
                }
            } else if (textInfo.getPosType() == TextInfoPosType.XYPERCENT) {
                float x = 0.0f;
                float y = 0.0f;
                lineWidth = 0.0f;
                if (!textInfo.isCenter()) {
                    x = (float)oriWidth * textInfo.getXPercent();
                    lineWidth = (float)oriWidth - x;
                    lines = ImageUtils.paragraphingText(signText, g2D, font, lineWidth, textWidth, textInfo.isBreakWord());
                    y = (float)oriHeight - (float)oriHeight * textInfo.getYPercent() - (float)(height * (lines.size() - 1)) - (float)dis;
                } else {
                    lineWidth = textWidth < oriWidth ? textWidth : oriWidth;
                    minWidth = (float)oriWidth * textInfo.getXPercent() < (float)(oriWidth / 2) ? (float)oriWidth * textInfo.getXPercent() : (float)oriWidth * (1.0f - textInfo.getXPercent());
                    lineWidth = minWidth < lineWidth / 2.0f ? minWidth * 2.0f : lineWidth;
                    lines = ImageUtils.paragraphingText(signText, g2D, font, lineWidth, textWidth, textInfo.isBreakWord());
                    lineWidth = textInfo.isBreakWord() ? lineWidth : (float)textWidth;
                    x = (float)oriWidth * textInfo.getXPercent() - lineWidth / 2.0f;
                    y = (float)oriHeight - (float)oriHeight * textInfo.getYPercent() - (float)(height * (lines.size() / 2 - 1)) - (float)dis;
                }
                for (String text : lines) {
                    if (y < (float)oriHeight && y > (float)height) {
                        g2D.drawString(text, x, y);
                    }
                    y += (float)height;
                }
            } else if (!textInfo.getPosType().toString().startsWith("OUT_")) {
                int x = 0;
                int y = 0;
                switch (textInfo.getPosType()) {
                    case SOUTH_LEFT: {
                        g2D.drawString(textInfo.getSignText(), x, oriHeight - dis);
                        break;
                    }
                    case SOUTH_CENTER: {
                        x = oriWidth / 2;
                        g2D.drawString(textInfo.getSignText(), x - textWidth / 2, oriHeight - dis);
                        break;
                    }
                    case SOUTH_RIGHT: {
                        g2D.drawString(textInfo.getSignText(), oriWidth - textWidth, oriHeight - dis);
                        break;
                    }
                    case WEST_MIDDLE: {
                        y = oriHeight / 2;
                        g2D.drawString(textInfo.getSignText(), x, y + height / 2);
                        break;
                    }
                    case CENTER_MIDDLE: {
                        x = oriWidth / 2;
                        y = oriHeight / 2;
                        g2D.drawString(textInfo.getSignText(), x - textWidth / 2, y + height / 2);
                        break;
                    }
                    case EAST_MIDDLE: {
                        y = oriHeight / 2;
                        g2D.drawString(textInfo.getSignText(), oriWidth - textWidth, y + height / 2);
                        break;
                    }
                    case NORTH_LEFT: {
                        g2D.drawString(textInfo.getSignText(), x, height);
                        break;
                    }
                    case NORTH_CENTER: {
                        x = oriWidth / 2;
                        g2D.drawString(textInfo.getSignText(), x - textWidth / 2, height);
                        break;
                    }
                    case NORTH_RIGHT: {
                        g2D.drawString(textInfo.getSignText(), oriWidth - textWidth, height);
                        break;
                    }
                }
            } else {
                if (textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_LEFT || textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_MIDDLE || textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_RIGHT) {
                    if (bottom < height) {
                        bottom = height;
                    }
                } else if (textInfo.getPosType() == TextInfoPosType.OUT_NORTH_LEFT || textInfo.getPosType() == TextInfoPosType.OUT_NORTH_CENTER || textInfo.getPosType() == TextInfoPosType.OUT_NORTH_RIGHT) {
                    if (top < height) {
                        top = height;
                    }
                } else if (textInfo.getPosType() == TextInfoPosType.OUT_WEST_TOP || textInfo.getPosType() == TextInfoPosType.OUT_WEST_MIDDLE || textInfo.getPosType() == TextInfoPosType.OUT_WEST_BUTTOM) {
                    if (left < textWidth) {
                        left = textWidth;
                    }
                } else if (textInfo.getPosType() == TextInfoPosType.OUT_EAST_TOP || textInfo.getPosType() == TextInfoPosType.OUT_EAST_MIDDLE || textInfo.getPosType() == TextInfoPosType.OUT_EAST_BUTTOM) {
                    if (right < textWidth) {
                        right = textWidth;
                    }
                } else if (textInfo.getPosType() == TextInfoPosType.OUT_NORTH_WEST) {
                    if (top < height) {
                        top = height;
                    }
                    if (left < textWidth) {
                        left = textWidth;
                    }
                } else if (textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_WEST) {
                    if (bottom < height) {
                        bottom = height;
                    }
                    if (left < textWidth) {
                        left = textWidth;
                    }
                } else if (textInfo.getPosType() == TextInfoPosType.OUT_EAST_NORTH) {
                    if (top < height) {
                        top = height;
                    }
                    if (right < textWidth) {
                        right = textWidth;
                    }
                } else if (textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_EAST) {
                    if (bottom < height) {
                        bottom = height;
                    }
                    if (right < textWidth) {
                        right = textWidth;
                    }
                }
                outText.add(textInfo);
            }
            ++i;
        }
        g2D.dispose();
        if (outText.size() <= 0) {
            return oldbi;
        }
        BufferedImage newbuffimg = new BufferedImage(oriWidth + left + right, oriHeight + top + bottom, 6);
        g2D = newbuffimg.createGraphics();
        g2D.setBackground(Color.WHITE);
        g2D.fillRect(0, 0, oriWidth + left + right, oriHeight + top + bottom);
        g2D.drawImage((Image)oldbi, left, top, null);
        for (KGTextInfo textInfo : outText) {
            font = new Font(textInfo.getFontName(), textInfo.getFontStyle(), textInfo.getFontSize());
            g2D.setFont(font);
            g2D.setColor(new Color(textInfo.getFontColor()));
            fontMetrics = g2D.getFontMetrics();
            int width = fontMetrics.stringWidth(textInfo.getSignText());
            height = fontMetrics.getHeight();
            dis = height - font.getSize();
            int x = 0;
            int y = 0;
            if (textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_LEFT) {
                x = left + oriWidth / 6 - width / 2;
                y = top + oriHeight + bottom - dis;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_MIDDLE) {
                x = left + oriWidth / 2 - width / 2;
                y = top + oriHeight + bottom - dis;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_RIGHT) {
                x = left + (oriWidth - oriWidth / 6) - width / 2;
                y = top + oriHeight + bottom - dis;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_NORTH_LEFT) {
                x = left + oriWidth / 6 - width / 2;
                y = height;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_NORTH_CENTER) {
                x = left + oriWidth / 2 - width / 2;
                y = height;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_NORTH_RIGHT) {
                x = left + (oriWidth - oriWidth / 6) - width / 2;
                y = height;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_WEST_TOP) {
                y = top + height;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_WEST_MIDDLE) {
                y = top + oriHeight / 2 + height / 2;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_WEST_BUTTOM) {
                y = top + oriHeight - dis;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_EAST_TOP) {
                x = left + oriWidth;
                y = top + height;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_EAST_MIDDLE) {
                x = left + oriWidth;
                y = top + oriHeight / 2 + height / 2;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_EAST_BUTTOM) {
                x = left + oriWidth;
                y = top + oriHeight - dis;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_NORTH_WEST) {
                y = height;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_WEST) {
                y = top + oriHeight + bottom - dis;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_EAST_NORTH) {
                x = left + oriWidth;
                y = height;
            } else if (textInfo.getPosType() == TextInfoPosType.OUT_SOUTH_EAST) {
                x = left + oriWidth;
                y = top + oriHeight + bottom - dis;
            }
            g2D.drawString(textInfo.getSignText(), x, y);
        }
        g2D.dispose();
        return newbuffimg;
    }

    public static BufferedImage rotate(BufferedImage buffimg, int angle) {
        if (angle != 0) {
            int _angle = angle * 90;
            int w = buffimg.getWidth();
            int h = buffimg.getHeight();
            BufferedImage tempimg = null;
            Graphics2D graphics2d = null;
            int type = buffimg.getColorModel().getTransparency();
            if (_angle % 180 == 0) {
                tempimg = new BufferedImage(w, h, type);
                graphics2d = tempimg.createGraphics();
                graphics2d.rotate(Math.toRadians(_angle), w / 2, h / 2);
            } else if (_angle % 90 == 0) {
                tempimg = new BufferedImage(h, w, type);
                graphics2d = tempimg.createGraphics();
                if (_angle < 0) {
                    graphics2d.rotate(Math.toRadians(_angle), h / 2, h / 2);
                } else if (_angle == 90) {
                    graphics2d.rotate(Math.toRadians(_angle), h / 2, h / 2);
                } else {
                    graphics2d.rotate(Math.toRadians(_angle), w / 2, w / 2);
                }
            }
            graphics2d.drawImage((Image)buffimg, 0, 0, null);
            graphics2d.dispose();
            return tempimg;
        }
        return buffimg;
    }

    public static BufferedImage filler(BufferedImage bi, int newwidth, int newheight, int x, int y) {
        BufferedImage new_bi = new BufferedImage(newwidth, newheight, 7);
        Graphics2D g2D = (Graphics2D)new_bi.getGraphics();
        g2D.drawImage((Image)bi, x, y, null);
        g2D.dispose();
        return new_bi;
    }

    private static boolean isIndexed(PdfObject colorspace) {
        PdfArray cs;
        boolean isIndexed = false;
        if (colorspace instanceof PdfArray && PdfName.INDEXED.equals((cs = (PdfArray)colorspace).getDirectObject(0))) {
            isIndexed = true;
        }
        return isIndexed;
    }

    public static byte[] getImage(PRStream stream, Color color, boolean isKeepImage) throws IOException {
        PdfDictionary imageDictionary = (PdfDictionary)PdfReader.getPdfObject(stream);
        byte[] streamContent = PdfReader.getStreamBytesRaw(stream);
        byte[] imageObjectData = null;
        PdfObject colorspace = imageDictionary.getDirectObject(PdfName.COLORSPACE);
        if (ImageUtils.isIndexed(colorspace)) {
            imageObjectData = ImageUtils.getIndexedImage(imageDictionary, streamContent);
        }
        if (imageObjectData == null) {
            imageObjectData = ImageUtils.getImageDataFromPdfImageObject(new PdfImageObject(stream));
        }
        BufferedImage bufferedImage = null;
        if (imageDictionary.getAsStream(PdfName.SMASK) != null) {
            PRStream maskStream = (PRStream)imageDictionary.getAsStream(PdfName.SMASK);
            byte[] maskImageData = ImageUtils.getImageDataFromPdfImageObject(new PdfImageObject(maskStream));
            bufferedImage = ImageUtils.combineImage(imageObjectData, maskImageData);
        } else {
            bufferedImage = ImageIO.read(new ByteArrayInputStream(imageObjectData));
        }
        byte[] image = null;
        if (isKeepImage) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
            image = byteArrayOutputStream.toByteArray();
        } else {
            image = ImageUtils.imageToGray(bufferedImage, color);
        }
        return image;
    }

    public static byte[] getGrayImage(PRStream stream, Color color) throws IOException {
        return ImageUtils.getImage(stream, color, false);
    }

    private static byte[] getIndexedImage(PdfDictionary imageDictionary, byte[] streamContent) throws IOException {
        Color[] colors;
        byte[] decodeImages = PdfReader.decodeBytes(streamContent, imageDictionary);
        int width = imageDictionary.getAsNumber(PdfName.WIDTH).intValue();
        int height = imageDictionary.getAsNumber(PdfName.HEIGHT).intValue();
        int bpc = imageDictionary.getAsNumber(PdfName.BITSPERCOMPONENT).intValue();
        PdfObject colorspace = imageDictionary.getDirectObject(PdfName.COLORSPACE);
        PdfArray cs = (PdfArray)colorspace;
        BufferedImage img = null;
        byte[] colorPalette = ImageUtils.getPalette(cs);
        int hival = cs.getAsNumber(2).intValue();
        int numCSComps = 3;
        int[] b1 = new int[numCSComps];
        float[] f1 = new float[numCSComps];
        Color[] cols = new Color[hival + 1];
        int j = 0;
        while (j <= hival) {
            int i = 0;
            while (i < numCSComps) {
                b1[numCSComps - 1 - i] = 0xFF & colorPalette[j * numCSComps + i];
                ++i;
            }
            ImageUtils.normaliseComponentsToFloats(b1, f1, 255.0f);
            cols[j] = ImageUtils.getColor(f1, true);
            ++j;
        }
        Object smaskImage = null;
        Object maskImage = null;
        int[] maskMinRGB = null;
        int[] maskMaxRGB = null;
        int maskMinIndex = -1;
        int maskMaxIndex = -1;
        PdfObject smaskObj = imageDictionary.get(PdfName.SMASK);
        PdfObject maskObj = imageDictionary.get(PdfName.MASK);
        if (bpc == 1 || bpc == 2 || bpc == 4) {
            WritableRaster wr;
            DataBufferByte db;
            boolean usingAlpha;
            colors = cols;
            int[] cmap = new int[colors == null ? 0 : colors.length];
            int i = 0;
            while (i < cmap.length) {
                cmap[i] = colors[i].getRGB();
                ++i;
            }
            int cmapMaxLength = 1 << bpc;
            if (cmap.length > cmapMaxLength) {
                int[] cmapTruncated = new int[cmapMaxLength];
                System.arraycopy(cmap, 0, cmapTruncated, 0, cmapMaxLength);
                cmap = cmapTruncated;
            }
            if (maskObj != null && smaskObj == null && maskObj instanceof List) {
                List maskVector = (List)((Object)maskObj);
                int[] maskMinOrigCompsInt = new int[1];
                int[] maskMaxOrigCompsInt = new int[1];
                int i2 = 0;
                while (i2 < 1) {
                    if (i2 * 2 < maskVector.size()) {
                        maskMinOrigCompsInt[i2] = ((Number)maskVector.get(i2 * 2)).intValue();
                    }
                    if (i2 * 2 + 1 < maskVector.size()) {
                        maskMaxOrigCompsInt[i2] = ((Number)maskVector.get(i2 * 2 + 1)).intValue();
                    }
                    ++i2;
                }
                if (colors != null && maskMinOrigCompsInt.length >= 1 && maskMaxOrigCompsInt.length >= 1) {
                    maskMinIndex = maskMinOrigCompsInt[0];
                    maskMaxIndex = maskMaxOrigCompsInt[0];
                    if (maskMinIndex >= 0 && maskMinIndex < colors.length && maskMaxIndex >= 0 && maskMaxIndex < colors.length) {
                        Color minColor = colors[maskMinOrigCompsInt[0]];
                        Color maxColor = colors[maskMaxOrigCompsInt[0]];
                        maskMinRGB = new int[]{minColor.getRed(), minColor.getGreen(), minColor.getBlue()};
                        maskMaxRGB = new int[]{maxColor.getRed(), maxColor.getGreen(), maxColor.getBlue()};
                    }
                }
            }
            boolean bl = usingAlpha = smaskImage != null || maskImage != null || maskMinRGB != null && maskMaxRGB != null;
            if (usingAlpha) {
                db = new DataBufferByte(decodeImages, decodeImages.length);
                wr = Raster.createPackedRaster(db, width, height, bpc, new Point(0, 0));
                IndexColorModel cm = new IndexColorModel(bpc, cmap.length, cmap, 0, true, -1, db.getDataType());
                img = new BufferedImage(cm, wr, false, null);
                img = ImageUtils.alterBufferedImageAlpha(img, maskMinRGB, maskMaxRGB);
            } else {
                db = new DataBufferByte(decodeImages, decodeImages.length);
                wr = Raster.createPackedRaster(db, width, height, bpc, new Point(0, 0));
                IndexColorModel cm = new IndexColorModel(bpc, cmap.length, cmap, 0, false, -1, db.getDataType());
                img = new BufferedImage(cm, wr, false, null);
            }
        } else if (bpc == 8) {
            boolean usingAlpha;
            colors = cols;
            int colorsLength = colors == null ? 0 : colors.length;
            int[] cmap = new int[256];
            int i = 0;
            while (i < colorsLength) {
                cmap[i] = colors[i].getRGB();
                ++i;
            }
            i = colorsLength;
            while (i < cmap.length) {
                cmap[i] = -16777216;
                ++i;
            }
            boolean usingIndexedAlpha = maskMinIndex >= 0 && maskMaxIndex >= 0;
            boolean bl = usingAlpha = smaskImage != null || maskImage != null || maskMinRGB != null && maskMaxRGB != null;
            if (usingIndexedAlpha) {
                int i3 = maskMinIndex;
                while (i3 <= maskMaxIndex) {
                    cmap[i3] = 0;
                    ++i3;
                }
                DataBufferByte db = new DataBufferByte(decodeImages, decodeImages.length);
                PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(db.getDataType(), width, height, 1, width, new int[1]);
                WritableRaster wr = Raster.createWritableRaster(sm, db, new Point(0, 0));
                IndexColorModel cm = new IndexColorModel(bpc, cmap.length, cmap, 0, true, -1, db.getDataType());
                img = new BufferedImage(cm, wr, false, null);
            } else if (usingAlpha) {
                int[] rgbaData = new int[width * height];
                int index = 0;
                int max = rgbaData.length;
                while (index < max) {
                    int cmapIndex = decodeImages[index] & 0xFF;
                    rgbaData[index] = cmap[cmapIndex];
                    ++index;
                }
                DataBufferInt db = new DataBufferInt(rgbaData, rgbaData.length);
                int[] masks = new int[]{0xFF0000, 65280, 255, -16777216};
                WritableRaster wr = Raster.createPackedRaster(db, width, height, width, masks, new Point(0, 0));
                ColorSpace cs_sRGB = ColorSpace.getInstance(1000);
                DirectColorModel cm = new DirectColorModel(cs_sRGB, 32, 0xFF0000, 65280, 255, -16777216, false, db.getDataType());
                img = new BufferedImage(cm, wr, false, null);
            } else {
                DataBufferByte db = new DataBufferByte(decodeImages, decodeImages.length);
                PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(db.getDataType(), width, height, 1, width, new int[1]);
                WritableRaster wr = Raster.createWritableRaster(sm, db, new Point(0, 0));
                IndexColorModel cm = new IndexColorModel(bpc, cmap.length, cmap, 0, false, -1, db.getDataType());
                img = new BufferedImage(cm, wr, false, null);
            }
        }
        if (img != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write(img, "png", baos);
            return baos.toByteArray();
        }
        return null;
    }

    private static byte[] getPalette(PdfArray cs) throws IOException {
        byte[] colorBytes = null;
        PdfObject id2 = cs.getDirectObject(3);
        if (id2 instanceof PdfString) {
            colorBytes = ((PdfString)id2).getBytes();
        } else if (id2 instanceof PRStream) {
            colorBytes = PdfReader.getStreamBytes((PRStream)id2);
        }
        return colorBytes;
    }

    public static BufferedImage combineImage(byte[] image, byte[] smask) {
        ByteArrayInputStream imageIn = new ByteArrayInputStream(image);
        ByteArrayInputStream smaskIn = new ByteArrayInputStream(smask);
        BufferedImage imageBufferedImage = null;
        BufferedImage smaskBufferedImage = null;
        BufferedImage bufferedImage = null;
        try {
            imageBufferedImage = ImageIO.read(imageIn);
            smaskBufferedImage = ImageIO.read(smaskIn);
            int width = imageBufferedImage.getWidth();
            int height = imageBufferedImage.getHeight();
            int minx = imageBufferedImage.getMinX();
            int miny = imageBufferedImage.getMinY();
            bufferedImage = new BufferedImage(width, height, 6);
            int i = minx;
            while (i < width) {
                int j = miny;
                while (j < height) {
                    int smaskRGB = smaskBufferedImage.getRGB(i, j);
                    int imageRGB = imageBufferedImage.getRGB(i, j);
                    int R = (smaskRGB & 0xFF0000) >> 16;
                    int G = (smaskRGB & 0xFF00) >> 8;
                    int B = smaskRGB & 0xFF;
                    int A = (smaskRGB & 0xFF000000) >>> 24;
                    if (R == 0) {
                        bufferedImage.setRGB(i, j, -1);
                    } else {
                        bufferedImage.setRGB(i, j, imageRGB);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return bufferedImage;
    }

    public static byte[] imageToGray(BufferedImage imageBufferedImage, Color color) throws IOException {
        BufferedImage destImage = new BufferedImage(imageBufferedImage.getWidth(), imageBufferedImage.getHeight(), 4);
        ColorConvertOp cco = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        cco.filter(imageBufferedImage, destImage);
        int width = destImage.getWidth();
        int height = destImage.getHeight();
        BufferedImage bufferedImage = new BufferedImage(width, height, destImage.getType());
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                int B;
                int G;
                int imageRGB = destImage.getRGB(i, j);
                int R = (imageRGB & 0xFF0000) >> 16;
                int gray = (int)((double)R * 0.3 + (double)(G = (imageRGB & 0xFF00) >> 8) * 0.59 + (double)(B = imageRGB & 0xFF) * 0.11);
                if (gray <= 128) {
                    bufferedImage.setRGB(i, j, color.getRGB());
                } else {
                    bufferedImage.setRGB(i, j, imageRGB);
                }
                ++j;
            }
            ++i;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] getImageDataFromPdfImageObject(PdfImageObject pdfImageObject) throws IOException {
        PdfName filter = (PdfName)pdfImageObject.get(PdfName.FILTER);
        byte[] imageData = null;
        if (PdfName.DCTDECODE.equals(filter) || PdfName.JPXDECODE.equals(filter)) {
            imageData = pdfImageObject.getImageAsBytes();
        } else {
            BufferedImage bufferedImage = pdfImageObject.getBufferedImage();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
            imageData = byteArrayOutputStream.toByteArray();
        }
        return imageData;
    }

    public static void normaliseComponentsToFloats(int[] in, float[] out, float maxval) {
        int i = 0;
        while (i < 3) {
            out[i] = (float)in[i] / maxval;
            ++i;
        }
    }

    public static Color getColor(float[] colours, boolean fillAndStroke) {
        return new Color(ImageUtils.validateColorRange(colours[2]), ImageUtils.validateColorRange(colours[1]), ImageUtils.validateColorRange(colours[0]));
    }

    private static float validateColorRange(float component) {
        if (component < 0.0f) {
            return 0.0f;
        }
        if (component > 1.0f) {
            return 1.0f;
        }
        return component;
    }

    protected static BufferedImage alterBufferedImageAlpha(BufferedImage bi, int[] maskMinRGB, int[] maskMaxRGB) {
        if (!ImageUtils.hasAlpha(bi)) {
            bi = ImageUtils.createBufferedImage(bi);
        }
        int width = bi.getWidth();
        int height = bi.getHeight();
        int maskMinRed = 255;
        int maskMinGreen = 255;
        int maskMinBlue = 255;
        int maskMaxRed = 0;
        int maskMaxGreen = 0;
        int maskMaxBlue = 0;
        if (maskMinRGB != null && maskMaxRGB != null) {
            maskMinRed = maskMinRGB[0];
            maskMinGreen = maskMinRGB[1];
            maskMinBlue = maskMinRGB[2];
            maskMaxRed = maskMaxRGB[0];
            maskMaxGreen = maskMaxRGB[1];
            maskMaxBlue = maskMaxRGB[2];
        }
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int alpha = 255;
                int argb = bi.getRGB(x, y);
                int red = argb >> 16 & 0xFF;
                int green = argb >> 8 & 0xFF;
                int blue = argb & 0xFF;
                if (blue >= maskMinBlue && blue <= maskMaxBlue && green >= maskMinGreen && green <= maskMaxGreen && red >= maskMinRed && red <= maskMaxRed) {
                    alpha = 0;
                }
                if (alpha != 255) {
                    argb = bi.getRGB(x, y);
                    argb &= 0xFFFFFF;
                    bi.setRGB(x, y, argb |= alpha << 24 & 0xFF000000);
                }
                ++x;
            }
            ++y;
        }
        return bi;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pixelGrabber.getColorModel();
        return cm == null || cm.hasAlpha();
    }

    public static BufferedImage createBufferedImage(Image imageIn) {
        return ImageUtils.createBufferedImage(imageIn, 2);
    }

    public static BufferedImage createBufferedImage(Image imageIn, int imageType) {
        BufferedImage bufferedImageOut = new BufferedImage(imageIn.getWidth(null), imageIn.getHeight(null), imageType);
        Graphics g = bufferedImageOut.getGraphics();
        g.drawImage(imageIn, 0, 0, null);
        imageIn.flush();
        return bufferedImageOut;
    }
}

