/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf.qrcode;

public final class ByteMatrix {
    private final byte[][] bytes;
    private final int width;
    private final int height;

    public ByteMatrix(int width, int height) {
        this.bytes = new byte[height][width];
        this.width = width;
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public byte get(int x, int y) {
        return this.bytes[y][x];
    }

    public byte[][] getArray() {
        return this.bytes;
    }

    public void set(int x, int y, byte value) {
        this.bytes[y][x] = value;
    }

    public void set(int x, int y, int value) {
        this.bytes[y][x] = (byte)value;
    }

    public void clear(byte value) {
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                this.bytes[y][x] = value;
                ++x;
            }
            ++y;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(2 * this.width * this.height + 2);
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                switch (this.bytes[y][x]) {
                    case 0: {
                        result.append(" 0");
                        break;
                    }
                    case 1: {
                        result.append(" 1");
                        break;
                    }
                    default: {
                        result.append("  ");
                    }
                }
                ++x;
            }
            result.append('\n');
            ++y;
        }
        return result.toString();
    }
}

