/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf.parser;

import com.KGitextpdf.text.BaseColor;
import com.KGitextpdf.text.ExceptionConverter;
import com.KGitextpdf.text.error_messages.MessageLocalization;
import com.KGitextpdf.text.io.RandomAccessSourceFactory;
import com.KGitextpdf.text.pdf.CMYKColor;
import com.KGitextpdf.text.pdf.CMapAwareDocumentFont;
import com.KGitextpdf.text.pdf.GrayColor;
import com.KGitextpdf.text.pdf.PRIndirectReference;
import com.KGitextpdf.text.pdf.PRTokeniser;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfContentParser;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfLiteral;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfString;
import com.KGitextpdf.text.pdf.RandomAccessFileOrArray;
import com.KGitextpdf.text.pdf.parser.ContentByteUtils;
import com.KGitextpdf.text.pdf.parser.ContentOperator;
import com.KGitextpdf.text.pdf.parser.GraphicsState;
import com.KGitextpdf.text.pdf.parser.ImageRenderInfo;
import com.KGitextpdf.text.pdf.parser.InlineImageInfo;
import com.KGitextpdf.text.pdf.parser.InlineImageUtils;
import com.KGitextpdf.text.pdf.parser.MarkedContentInfo;
import com.KGitextpdf.text.pdf.parser.Matrix;
import com.KGitextpdf.text.pdf.parser.RenderListener;
import com.KGitextpdf.text.pdf.parser.TextRenderInfo;
import com.KGitextpdf.text.pdf.parser.XObjectDoHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;

public class PdfContentStreamProcessor {
    public static final String DEFAULTOPERATOR = "DefaultOperator";
    private final Map<String, ContentOperator> operators;
    private ResourceDictionary resources;
    private final Stack<GraphicsState> gsStack = new Stack();
    private Matrix textMatrix;
    private Matrix textLineMatrix;
    private final RenderListener renderListener;
    private final Map<PdfName, XObjectDoHandler> xobjectDoHandlers;
    private final Map<Integer, CMapAwareDocumentFont> cachedFonts = new HashMap<Integer, CMapAwareDocumentFont>();
    private final Stack<MarkedContentInfo> markedContentStack = new Stack();

    public PdfContentStreamProcessor(RenderListener renderListener) {
        this.renderListener = renderListener;
        this.operators = new HashMap<String, ContentOperator>();
        this.populateOperators();
        this.xobjectDoHandlers = new HashMap<PdfName, XObjectDoHandler>();
        this.populateXObjectDoHandlers();
        this.reset();
    }

    private void populateXObjectDoHandlers() {
        this.registerXObjectDoHandler(PdfName.DEFAULT, new IgnoreXObjectDoHandler());
        this.registerXObjectDoHandler(PdfName.FORM, new FormXObjectDoHandler());
        this.registerXObjectDoHandler(PdfName.IMAGE, new ImageXObjectDoHandler());
    }

    public XObjectDoHandler registerXObjectDoHandler(PdfName xobjectSubType, XObjectDoHandler handler) {
        return this.xobjectDoHandlers.put(xobjectSubType, handler);
    }

    private CMapAwareDocumentFont getFont(PRIndirectReference ind) {
        Integer n = ind.getNumber();
        CMapAwareDocumentFont font = this.cachedFonts.get(n);
        if (font == null) {
            font = new CMapAwareDocumentFont(ind);
            this.cachedFonts.put(n, font);
        }
        return font;
    }

    private CMapAwareDocumentFont getFont(PdfDictionary fontResource) {
        return new CMapAwareDocumentFont(fontResource);
    }

    private void populateOperators() {
        this.registerContentOperator(DEFAULTOPERATOR, new IgnoreOperatorContentOperator());
        this.registerContentOperator("q", new PushGraphicsState());
        this.registerContentOperator("Q", new PopGraphicsState());
        this.registerContentOperator("g", new SetGrayFill());
        this.registerContentOperator("G", new SetGrayStroke());
        this.registerContentOperator("rg", new SetRGBFill());
        this.registerContentOperator("RG", new SetRGBStroke());
        this.registerContentOperator("k", new SetCMYKFill());
        this.registerContentOperator("K", new SetCMYKStroke());
        this.registerContentOperator("cs", new SetColorSpaceFill());
        this.registerContentOperator("CS", new SetColorSpaceStroke());
        this.registerContentOperator("sc", new SetColorFill());
        this.registerContentOperator("SC", new SetColorStroke());
        this.registerContentOperator("scn", new SetColorFill());
        this.registerContentOperator("SCN", new SetColorStroke());
        this.registerContentOperator("cm", new ModifyCurrentTransformationMatrix());
        this.registerContentOperator("gs", new ProcessGraphicsStateResource());
        SetTextCharacterSpacing tcOperator = new SetTextCharacterSpacing();
        this.registerContentOperator("Tc", tcOperator);
        SetTextWordSpacing twOperator = new SetTextWordSpacing();
        this.registerContentOperator("Tw", twOperator);
        this.registerContentOperator("Tz", new SetTextHorizontalScaling());
        SetTextLeading tlOperator = new SetTextLeading();
        this.registerContentOperator("TL", tlOperator);
        this.registerContentOperator("Tf", new SetTextFont());
        this.registerContentOperator("Tr", new SetTextRenderMode());
        this.registerContentOperator("Ts", new SetTextRise());
        this.registerContentOperator("BT", new BeginText());
        this.registerContentOperator("ET", new EndText());
        this.registerContentOperator("BMC", new BeginMarkedContent());
        this.registerContentOperator("BDC", new BeginMarkedContentDictionary());
        this.registerContentOperator("EMC", new EndMarkedContent());
        TextMoveStartNextLine tdOperator = new TextMoveStartNextLine();
        this.registerContentOperator("Td", tdOperator);
        this.registerContentOperator("TD", new TextMoveStartNextLineWithLeading(tdOperator, tlOperator));
        this.registerContentOperator("Tm", new TextSetTextMatrix());
        TextMoveNextLine tstarOperator = new TextMoveNextLine(tdOperator);
        this.registerContentOperator("T*", tstarOperator);
        ShowText tjOperator = new ShowText();
        this.registerContentOperator("Tj", tjOperator);
        MoveNextLineAndShowText tickOperator = new MoveNextLineAndShowText(tstarOperator, tjOperator);
        this.registerContentOperator("'", tickOperator);
        this.registerContentOperator("\"", new MoveNextLineAndShowTextWithSpacing(twOperator, tcOperator, tickOperator));
        this.registerContentOperator("TJ", new ShowTextArray());
        this.registerContentOperator("Do", new Do());
    }

    public ContentOperator registerContentOperator(String operatorString, ContentOperator operator) {
        return this.operators.put(operatorString, operator);
    }

    public void reset() {
        this.gsStack.removeAllElements();
        this.gsStack.add(new GraphicsState());
        this.textMatrix = null;
        this.textLineMatrix = null;
        this.resources = new ResourceDictionary();
    }

    private GraphicsState gs() {
        return this.gsStack.peek();
    }

    private void invokeOperator(PdfLiteral operator, ArrayList<PdfObject> operands) throws Exception {
        ContentOperator op = this.operators.get(operator.toString());
        if (op == null) {
            op = this.operators.get(DEFAULTOPERATOR);
        }
        op.invoke(this, operator, operands);
    }

    private void beginMarkedContent(PdfName tag, PdfDictionary dict) {
        this.markedContentStack.push(new MarkedContentInfo(tag, dict));
    }

    private void endMarkedContent() {
        this.markedContentStack.pop();
    }

    private String decode(PdfString in) {
        PdfStream toUni;
        byte[] bytes = in.getBytes();
        CMapAwareDocumentFont font = this.gs().font;
        PdfDictionary fontdic = font.getFontDictionary();
        if (fontdic != null && (toUni = fontdic.getAsStream(PdfName.TOUNICODE)) != null) {
            PdfName type = toUni.getAsName(PdfName.TYPE);
            PdfNumber wmode = toUni.getAsNumber(new PdfName("WMode"));
            if (type != null && "/CMAP".equalsIgnoreCase(type.toString()) && wmode != null && wmode.intValue() == 0) {
                try {
                    return new String(bytes, "UnicodeBigUnmarked");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return font.decode(bytes, 0, bytes.length);
    }

    private void beginText() {
        this.renderListener.beginTextBlock();
    }

    private void endText() {
        this.renderListener.endTextBlock();
    }

    private void displayPdfString(PdfString string) {
        String unicode = this.decode(string);
        TextRenderInfo renderInfo = new TextRenderInfo(unicode, this.gs(), this.textMatrix, this.markedContentStack);
        this.renderListener.renderText(renderInfo);
        this.textMatrix = new Matrix(renderInfo.getUnscaledWidth(), 0.0f).multiply(this.textMatrix);
    }

    private void displayXObject(PdfName xobjectName) throws IOException {
        XObjectDoHandler handler;
        PdfDictionary xobjects = this.resources.getAsDict(PdfName.XOBJECT);
        PdfObject xobject = xobjects.getDirectObject(xobjectName);
        PdfStream xobjectStream = (PdfStream)xobject;
        PdfName subType = xobjectStream.getAsName(PdfName.SUBTYPE);
        if (xobject.isStream()) {
            handler = this.xobjectDoHandlers.get(subType);
            if (handler == null) {
                handler = this.xobjectDoHandlers.get(PdfName.DEFAULT);
            }
        } else {
            throw new IllegalStateException(MessageLocalization.getComposedMessage("XObject.1.is.not.a.stream", xobjectName));
        }
        handler.handleXObject(this, xobjectStream, xobjects.getAsIndirectObject(xobjectName));
    }

    private void applyTextAdjust(float tj) {
        float adjustBy = -tj / 1000.0f * this.gs().fontSize * this.gs().horizontalScaling;
        this.textMatrix = new Matrix(adjustBy, 0.0f).multiply(this.textMatrix);
    }

    public void processContent(byte[] contentBytes, PdfDictionary resources) {
        this.resources.push(resources);
        try {
            PRTokeniser tokeniser = new PRTokeniser(new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(contentBytes)));
            PdfContentParser ps = new PdfContentParser(tokeniser);
            ArrayList<PdfObject> operands = new ArrayList<PdfObject>();
            while (ps.parse(operands).size() > 0) {
                PdfLiteral operator = (PdfLiteral)operands.get(operands.size() - 1);
                if ("BI".equals(operator.toString())) {
                    PdfDictionary colorSpaceDic = resources != null ? resources.getAsDict(PdfName.COLORSPACE) : null;
                    this.handleInlineImage(InlineImageUtils.parseInlineImage(ps, colorSpaceDic), colorSpaceDic);
                    continue;
                }
                this.invokeOperator(operator, operands);
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
        this.resources.pop();
    }

    protected void handleInlineImage(InlineImageInfo info, PdfDictionary colorSpaceDic) {
        ImageRenderInfo renderInfo = ImageRenderInfo.createForEmbeddedImage(this.gs().ctm, info, colorSpaceDic);
        this.renderListener.renderImage(renderInfo);
    }

    private static BaseColor getColor(PdfName colorSpace, List<PdfObject> operands) {
        if (PdfName.DEVICEGRAY.equals(colorSpace)) {
            return PdfContentStreamProcessor.getColor(1, operands);
        }
        if (PdfName.DEVICERGB.equals(colorSpace)) {
            return PdfContentStreamProcessor.getColor(3, operands);
        }
        if (PdfName.DEVICECMYK.equals(colorSpace)) {
            return PdfContentStreamProcessor.getColor(4, operands);
        }
        return null;
    }

    private static BaseColor getColor(int nOperands, List<PdfObject> operands) {
        float[] c = new float[nOperands];
        int i = 0;
        while (i < nOperands) {
            c[i] = ((PdfNumber)operands.get(i)).floatValue();
            ++i;
        }
        switch (nOperands) {
            case 1: {
                return new GrayColor(c[0]);
            }
            case 3: {
                return new BaseColor(c[0], c[1], c[2]);
            }
            case 4: {
                return new CMYKColor(c[0], c[1], c[2], c[3]);
            }
        }
        return null;
    }

    private static class BeginMarkedContent
    implements ContentOperator {
        private BeginMarkedContent() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) throws Exception {
            processor.beginMarkedContent((PdfName)operands.get(0), new PdfDictionary());
        }
    }

    private static class BeginMarkedContentDictionary
    implements ContentOperator {
        private BeginMarkedContentDictionary() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) throws Exception {
            PdfObject properties = operands.get(1);
            processor.beginMarkedContent((PdfName)operands.get(0), this.getPropertiesDictionary(properties, processor.resources));
        }

        private PdfDictionary getPropertiesDictionary(PdfObject operand1, ResourceDictionary resources) {
            if (operand1.isDictionary()) {
                return (PdfDictionary)operand1;
            }
            PdfName dictionaryName = (PdfName)operand1;
            return resources.getAsDict(dictionaryName);
        }
    }

    private static class BeginText
    implements ContentOperator {
        private BeginText() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            processor.textMatrix = new Matrix();
            processor.textLineMatrix = processor.textMatrix;
            processor.beginText();
        }
    }

    private static class Do
    implements ContentOperator {
        private Do() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) throws IOException {
            PdfName xobjectName = (PdfName)operands.get(0);
            processor.displayXObject(xobjectName);
        }
    }

    private static class EndMarkedContent
    implements ContentOperator {
        private EndMarkedContent() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) throws Exception {
            processor.endMarkedContent();
        }
    }

    private static class EndText
    implements ContentOperator {
        private EndText() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            processor.textMatrix = null;
            processor.textLineMatrix = null;
            processor.endText();
        }
    }

    private static class FormXObjectDoHandler
    implements XObjectDoHandler {
        private FormXObjectDoHandler() {
        }

        @Override
        public void handleXObject(PdfContentStreamProcessor processor, PdfStream stream, PdfIndirectReference ref) {
            byte[] contentBytes;
            PdfDictionary resources = stream.getAsDict(PdfName.RESOURCES);
            try {
                contentBytes = ContentByteUtils.getContentBytesFromContentObject(stream);
            }
            catch (IOException e1) {
                throw new ExceptionConverter(e1);
            }
            PdfArray matrix = stream.getAsArray(PdfName.MATRIX);
            new PushGraphicsState().invoke(processor, null, null);
            if (matrix != null) {
                float a = matrix.getAsNumber(0).floatValue();
                float b = matrix.getAsNumber(1).floatValue();
                float c = matrix.getAsNumber(2).floatValue();
                float d = matrix.getAsNumber(3).floatValue();
                float e = matrix.getAsNumber(4).floatValue();
                float f = matrix.getAsNumber(5).floatValue();
                Matrix formMatrix = new Matrix(a, b, c, d, e, f);
                ((PdfContentStreamProcessor)processor).gs().ctm = formMatrix.multiply(((PdfContentStreamProcessor)processor).gs().ctm);
            }
            processor.processContent(contentBytes, resources);
            new PopGraphicsState().invoke(processor, null, null);
        }
    }

    private static class IgnoreOperatorContentOperator
    implements ContentOperator {
        private IgnoreOperatorContentOperator() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
        }
    }

    private static class IgnoreXObjectDoHandler
    implements XObjectDoHandler {
        private IgnoreXObjectDoHandler() {
        }

        @Override
        public void handleXObject(PdfContentStreamProcessor processor, PdfStream xobjectStream, PdfIndirectReference ref) {
        }
    }

    private static class ImageXObjectDoHandler
    implements XObjectDoHandler {
        private ImageXObjectDoHandler() {
        }

        @Override
        public void handleXObject(PdfContentStreamProcessor processor, PdfStream xobjectStream, PdfIndirectReference ref) {
            PdfDictionary colorSpaceDic = processor.resources.getAsDict(PdfName.COLORSPACE);
            ImageRenderInfo renderInfo = ImageRenderInfo.createForXObject(((PdfContentStreamProcessor)processor).gs().ctm, ref, colorSpaceDic);
            processor.renderListener.renderImage(renderInfo);
        }
    }

    private static class ModifyCurrentTransformationMatrix
    implements ContentOperator {
        private ModifyCurrentTransformationMatrix() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            float a = ((PdfNumber)operands.get(0)).floatValue();
            float b = ((PdfNumber)operands.get(1)).floatValue();
            float c = ((PdfNumber)operands.get(2)).floatValue();
            float d = ((PdfNumber)operands.get(3)).floatValue();
            float e = ((PdfNumber)operands.get(4)).floatValue();
            float f = ((PdfNumber)operands.get(5)).floatValue();
            Matrix matrix = new Matrix(a, b, c, d, e, f);
            GraphicsState gs = (GraphicsState)processor.gsStack.peek();
            gs.ctm = matrix.multiply(gs.ctm);
        }
    }

    private static class MoveNextLineAndShowText
    implements ContentOperator {
        private final TextMoveNextLine textMoveNextLine;
        private final ShowText showText;

        public MoveNextLineAndShowText(TextMoveNextLine textMoveNextLine, ShowText showText) {
            this.textMoveNextLine = textMoveNextLine;
            this.showText = showText;
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            this.textMoveNextLine.invoke(processor, null, new ArrayList<PdfObject>(0));
            this.showText.invoke(processor, null, operands);
        }
    }

    private static class MoveNextLineAndShowTextWithSpacing
    implements ContentOperator {
        private final SetTextWordSpacing setTextWordSpacing;
        private final SetTextCharacterSpacing setTextCharacterSpacing;
        private final MoveNextLineAndShowText moveNextLineAndShowText;

        public MoveNextLineAndShowTextWithSpacing(SetTextWordSpacing setTextWordSpacing, SetTextCharacterSpacing setTextCharacterSpacing, MoveNextLineAndShowText moveNextLineAndShowText) {
            this.setTextWordSpacing = setTextWordSpacing;
            this.setTextCharacterSpacing = setTextCharacterSpacing;
            this.moveNextLineAndShowText = moveNextLineAndShowText;
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfNumber aw = (PdfNumber)operands.get(0);
            PdfNumber ac = (PdfNumber)operands.get(1);
            PdfString string = (PdfString)operands.get(2);
            ArrayList<PdfObject> twOperands = new ArrayList<PdfObject>(1);
            twOperands.add(0, aw);
            this.setTextWordSpacing.invoke(processor, null, twOperands);
            ArrayList<PdfObject> tcOperands = new ArrayList<PdfObject>(1);
            tcOperands.add(0, ac);
            this.setTextCharacterSpacing.invoke(processor, null, tcOperands);
            ArrayList<PdfObject> tickOperands = new ArrayList<PdfObject>(1);
            tickOperands.add(0, string);
            this.moveNextLineAndShowText.invoke(processor, null, tickOperands);
        }
    }

    private static class PopGraphicsState
    implements ContentOperator {
        private PopGraphicsState() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            processor.gsStack.pop();
        }
    }

    private static class ProcessGraphicsStateResource
    implements ContentOperator {
        private ProcessGraphicsStateResource() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfName dictionaryName = (PdfName)operands.get(0);
            PdfDictionary extGState = processor.resources.getAsDict(PdfName.EXTGSTATE);
            if (extGState == null) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("resources.do.not.contain.extgstate.entry.unable.to.process.operator.1", operator));
            }
            PdfDictionary gsDic = extGState.getAsDict(dictionaryName);
            if (gsDic == null) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("1.is.an.unknown.graphics.state.dictionary", dictionaryName));
            }
            PdfArray fontParameter = gsDic.getAsArray(PdfName.FONT);
            if (fontParameter != null) {
                CMapAwareDocumentFont font = processor.getFont((PRIndirectReference)fontParameter.getPdfObject(0));
                float size = fontParameter.getAsNumber(1).floatValue();
                ((PdfContentStreamProcessor)processor).gs().font = font;
                ((PdfContentStreamProcessor)processor).gs().fontSize = size;
            }
        }
    }

    private static class PushGraphicsState
    implements ContentOperator {
        private PushGraphicsState() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            GraphicsState gs = (GraphicsState)processor.gsStack.peek();
            GraphicsState copy = new GraphicsState(gs);
            processor.gsStack.push(copy);
        }
    }

    private static class ResourceDictionary
    extends PdfDictionary {
        private final List<PdfDictionary> resourcesStack = new ArrayList<PdfDictionary>();

        public void push(PdfDictionary resources) {
            this.resourcesStack.add(resources);
        }

        public void pop() {
            this.resourcesStack.remove(this.resourcesStack.size() - 1);
        }

        @Override
        public PdfObject getDirectObject(PdfName key) {
            int i = this.resourcesStack.size() - 1;
            while (i >= 0) {
                PdfObject obj;
                PdfDictionary subResource = this.resourcesStack.get(i);
                if (subResource != null && (obj = subResource.getDirectObject(key)) != null) {
                    return obj;
                }
                --i;
            }
            return super.getDirectObject(key);
        }
    }

    private static class SetCMYKFill
    implements ContentOperator {
        private SetCMYKFill() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            ((PdfContentStreamProcessor)processor).gs().fillColor = PdfContentStreamProcessor.getColor(4, (List<PdfObject>)operands);
        }
    }

    private static class SetCMYKStroke
    implements ContentOperator {
        private SetCMYKStroke() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            ((PdfContentStreamProcessor)processor).gs().strokeColor = PdfContentStreamProcessor.getColor(4, (List<PdfObject>)operands);
        }
    }

    private static class SetColorFill
    implements ContentOperator {
        private SetColorFill() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            ((PdfContentStreamProcessor)processor).gs().fillColor = PdfContentStreamProcessor.getColor(((PdfContentStreamProcessor)processor).gs().colorSpaceFill, (List<PdfObject>)operands);
        }
    }

    private static class SetColorSpaceFill
    implements ContentOperator {
        private SetColorSpaceFill() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            ((PdfContentStreamProcessor)processor).gs().colorSpaceFill = (PdfName)operands.get(0);
        }
    }

    private static class SetColorSpaceStroke
    implements ContentOperator {
        private SetColorSpaceStroke() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            ((PdfContentStreamProcessor)processor).gs().colorSpaceStroke = (PdfName)operands.get(0);
        }
    }

    private static class SetColorStroke
    implements ContentOperator {
        private SetColorStroke() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            ((PdfContentStreamProcessor)processor).gs().strokeColor = PdfContentStreamProcessor.getColor(((PdfContentStreamProcessor)processor).gs().colorSpaceStroke, (List<PdfObject>)operands);
        }
    }

    private static class SetGrayFill
    implements ContentOperator {
        private SetGrayFill() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            ((PdfContentStreamProcessor)processor).gs().fillColor = PdfContentStreamProcessor.getColor(1, (List<PdfObject>)operands);
        }
    }

    private static class SetGrayStroke
    implements ContentOperator {
        private SetGrayStroke() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            ((PdfContentStreamProcessor)processor).gs().strokeColor = PdfContentStreamProcessor.getColor(1, (List<PdfObject>)operands);
        }
    }

    private static class SetRGBFill
    implements ContentOperator {
        private SetRGBFill() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            ((PdfContentStreamProcessor)processor).gs().fillColor = PdfContentStreamProcessor.getColor(3, (List<PdfObject>)operands);
        }
    }

    private static class SetRGBStroke
    implements ContentOperator {
        private SetRGBStroke() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            ((PdfContentStreamProcessor)processor).gs().strokeColor = PdfContentStreamProcessor.getColor(3, (List<PdfObject>)operands);
        }
    }

    private static class SetTextCharacterSpacing
    implements ContentOperator {
        private SetTextCharacterSpacing() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfNumber charSpace = (PdfNumber)operands.get(0);
            ((PdfContentStreamProcessor)processor).gs().characterSpacing = charSpace.floatValue();
        }
    }

    private static class SetTextFont
    implements ContentOperator {
        private Map<String, CMapAwareDocumentFont> map = new HashMap<String, CMapAwareDocumentFont>(16);

        private SetTextFont() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfName fontResourceName = (PdfName)operands.get(0);
            float size = ((PdfNumber)operands.get(1)).floatValue();
            String key = fontResourceName.toString();
            CMapAwareDocumentFont font = this.map.get(key);
            if (font == null) {
                PdfDictionary fontsDictionary = processor.resources.getAsDict(PdfName.FONT);
                PdfObject fontObject = fontsDictionary.get(fontResourceName);
                if (fontObject instanceof PdfDictionary) {
                    font = processor.getFont((PdfDictionary)fontObject);
                    this.map.put(key, font);
                } else {
                    font = processor.getFont((PRIndirectReference)fontObject);
                }
            }
            ((PdfContentStreamProcessor)processor).gs().font = font;
            ((PdfContentStreamProcessor)processor).gs().fontSize = size;
        }
    }

    private static class SetTextHorizontalScaling
    implements ContentOperator {
        private SetTextHorizontalScaling() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfNumber scale = (PdfNumber)operands.get(0);
            ((PdfContentStreamProcessor)processor).gs().horizontalScaling = scale.floatValue() / 100.0f;
        }
    }

    private static class SetTextLeading
    implements ContentOperator {
        private SetTextLeading() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfNumber leading = (PdfNumber)operands.get(0);
            ((PdfContentStreamProcessor)processor).gs().leading = leading.floatValue();
        }
    }

    private static class SetTextRenderMode
    implements ContentOperator {
        private SetTextRenderMode() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfNumber render = (PdfNumber)operands.get(0);
            ((PdfContentStreamProcessor)processor).gs().renderMode = render.intValue();
        }
    }

    private static class SetTextRise
    implements ContentOperator {
        private SetTextRise() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfNumber rise = (PdfNumber)operands.get(0);
            ((PdfContentStreamProcessor)processor).gs().rise = rise.floatValue();
        }
    }

    private static class SetTextWordSpacing
    implements ContentOperator {
        private SetTextWordSpacing() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfNumber wordSpace = (PdfNumber)operands.get(0);
            ((PdfContentStreamProcessor)processor).gs().wordSpacing = wordSpace.floatValue();
        }
    }

    private static class ShowText
    implements ContentOperator {
        private ShowText() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfString string = (PdfString)operands.get(0);
            processor.displayPdfString(string);
        }
    }

    private static class ShowTextArray
    implements ContentOperator {
        private ShowTextArray() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfArray array = (PdfArray)operands.get(0);
            float tj = 0.0f;
            ListIterator<PdfObject> i = array.listIterator();
            while (i.hasNext()) {
                PdfObject entryObj = (PdfObject)i.next();
                if (entryObj instanceof PdfString) {
                    processor.displayPdfString((PdfString)entryObj);
                    tj = 0.0f;
                    continue;
                }
                tj = ((PdfNumber)entryObj).floatValue();
                processor.applyTextAdjust(tj);
            }
        }
    }

    private static class TextMoveNextLine
    implements ContentOperator {
        private final TextMoveStartNextLine moveStartNextLine;

        public TextMoveNextLine(TextMoveStartNextLine moveStartNextLine) {
            this.moveStartNextLine = moveStartNextLine;
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            ArrayList<PdfObject> tdoperands = new ArrayList<PdfObject>(2);
            tdoperands.add(0, new PdfNumber(0));
            tdoperands.add(1, new PdfNumber(-((PdfContentStreamProcessor)processor).gs().leading));
            this.moveStartNextLine.invoke(processor, null, tdoperands);
        }
    }

    private static class TextMoveStartNextLine
    implements ContentOperator {
        private TextMoveStartNextLine() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            float tx = ((PdfNumber)operands.get(0)).floatValue();
            float ty = ((PdfNumber)operands.get(1)).floatValue();
            Matrix translationMatrix = new Matrix(tx, ty);
            processor.textMatrix = translationMatrix.multiply(processor.textLineMatrix);
            processor.textLineMatrix = processor.textMatrix;
        }
    }

    private static class TextMoveStartNextLineWithLeading
    implements ContentOperator {
        private final TextMoveStartNextLine moveStartNextLine;
        private final SetTextLeading setTextLeading;

        public TextMoveStartNextLineWithLeading(TextMoveStartNextLine moveStartNextLine, SetTextLeading setTextLeading) {
            this.moveStartNextLine = moveStartNextLine;
            this.setTextLeading = setTextLeading;
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            float ty = ((PdfNumber)operands.get(1)).floatValue();
            ArrayList<PdfObject> tlOperands = new ArrayList<PdfObject>(1);
            tlOperands.add(0, new PdfNumber(-ty));
            this.setTextLeading.invoke(processor, null, tlOperands);
            this.moveStartNextLine.invoke(processor, null, operands);
        }
    }

    private static class TextSetTextMatrix
    implements ContentOperator {
        private TextSetTextMatrix() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            float a = ((PdfNumber)operands.get(0)).floatValue();
            float b = ((PdfNumber)operands.get(1)).floatValue();
            float c = ((PdfNumber)operands.get(2)).floatValue();
            float d = ((PdfNumber)operands.get(3)).floatValue();
            float e = ((PdfNumber)operands.get(4)).floatValue();
            float f = ((PdfNumber)operands.get(5)).floatValue();
            processor.textLineMatrix = new Matrix(a, b, c, d, e, f);
            processor.textMatrix = processor.textLineMatrix;
        }
    }
}

