/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf.parser;

import com.KGitextpdf.text.pdf.parser.ImageRenderInfo;
import com.KGitextpdf.text.pdf.parser.LineSegment;
import com.KGitextpdf.text.pdf.parser.Matrix;
import com.KGitextpdf.text.pdf.parser.TextExtractionStrategy;
import com.KGitextpdf.text.pdf.parser.TextRenderInfo;
import com.KGitextpdf.text.pdf.parser.Vector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LocationTextExtractionStrategy
implements TextExtractionStrategy {
    static boolean DUMP_STATE = false;
    private final List<TextChunk> locationalResult = new ArrayList<TextChunk>();

    @Override
    public void beginTextBlock() {
    }

    @Override
    public void endTextBlock() {
    }

    private boolean startsWithSpace(String str) {
        if (str.length() == 0) {
            return false;
        }
        return str.charAt(0) == ' ';
    }

    private boolean endsWithSpace(String str) {
        if (str.length() == 0) {
            return false;
        }
        return str.charAt(str.length() - 1) == ' ';
    }

    private List<TextChunk> filterTextChunks(List<TextChunk> textChunks, TextChunkFilter filter) {
        if (filter == null) {
            return textChunks;
        }
        ArrayList<TextChunk> filtered = new ArrayList<TextChunk>();
        for (TextChunk textChunk : textChunks) {
            if (!filter.accept(textChunk)) continue;
            filtered.add(textChunk);
        }
        return filtered;
    }

    protected boolean isChunkAtWordBoundary(TextChunk chunk, TextChunk previousChunk) {
        float dist = chunk.distanceFromEndOf(previousChunk);
        return dist < -chunk.getCharSpaceWidth() || dist > chunk.getCharSpaceWidth() / 2.0f;
    }

    public String getResultantText(TextChunkFilter chunkFilter) {
        if (DUMP_STATE) {
            this.dumpState();
        }
        List<TextChunk> filteredTextChunks = this.filterTextChunks(this.locationalResult, chunkFilter);
        Collections.sort(filteredTextChunks);
        StringBuffer sb = new StringBuffer();
        TextChunk lastChunk = null;
        for (TextChunk chunk : filteredTextChunks) {
            if (lastChunk == null) {
                sb.append(chunk.text);
            } else if (chunk.sameLine(lastChunk)) {
                if (this.isChunkAtWordBoundary(chunk, lastChunk) && !this.startsWithSpace(chunk.text) && !this.endsWithSpace(lastChunk.text)) {
                    sb.append(' ');
                }
                sb.append(chunk.text);
            } else {
                sb.append('\n');
                sb.append(chunk.text);
            }
            lastChunk = chunk;
        }
        return sb.toString();
    }

    @Override
    public String getResultantText() {
        return this.getResultantText(null);
    }

    private void dumpState() {
        for (TextChunk location : this.locationalResult) {
            location.printDiagnostics();
            System.out.println();
        }
    }

    @Override
    public void renderText(TextRenderInfo renderInfo) {
        LineSegment segment = renderInfo.getBaseline();
        if (renderInfo.getRise() != 0.0f) {
            Matrix riseOffsetTransform = new Matrix(0.0f, -renderInfo.getRise());
            segment = segment.transformBy(riseOffsetTransform);
        }
        TextChunk location = new TextChunk(renderInfo.getText(), segment.getStartPoint(), segment.getEndPoint(), renderInfo.getSingleSpaceWidth());
        this.locationalResult.add(location);
    }

    @Override
    public void renderImage(ImageRenderInfo renderInfo) {
    }

    public static class TextChunk
    implements Comparable<TextChunk> {
        private final String text;
        private final Vector startLocation;
        private final Vector endLocation;
        private final Vector orientationVector;
        private final int orientationMagnitude;
        private final int distPerpendicular;
        private final float distParallelStart;
        private final float distParallelEnd;
        private final float charSpaceWidth;

        public TextChunk(String string, Vector startLocation, Vector endLocation, float charSpaceWidth) {
            this.text = string;
            this.startLocation = startLocation;
            this.endLocation = endLocation;
            this.charSpaceWidth = charSpaceWidth;
            Vector oVector = endLocation.subtract(startLocation);
            if (oVector.length() == 0.0f) {
                oVector = new Vector(1.0f, 0.0f, 0.0f);
            }
            this.orientationVector = oVector.normalize();
            this.orientationMagnitude = (int)(Math.atan2(this.orientationVector.get(1), this.orientationVector.get(0)) * 1000.0);
            Vector origin = new Vector(0.0f, 0.0f, 1.0f);
            this.distPerpendicular = (int)startLocation.subtract(origin).cross(this.orientationVector).get(2);
            this.distParallelStart = this.orientationVector.dot(startLocation);
            this.distParallelEnd = this.orientationVector.dot(endLocation);
        }

        public Vector getStartLocation() {
            return this.startLocation;
        }

        public Vector getEndLocation() {
            return this.endLocation;
        }

        public String getText() {
            return this.text;
        }

        public float getCharSpaceWidth() {
            return this.charSpaceWidth;
        }

        private void printDiagnostics() {
            System.out.println("Text (@" + this.startLocation + " -> " + this.endLocation + "): " + this.text);
            System.out.println("orientationMagnitude: " + this.orientationMagnitude);
            System.out.println("distPerpendicular: " + this.distPerpendicular);
            System.out.println("distParallel: " + this.distParallelStart);
        }

        public boolean sameLine(TextChunk as) {
            if (this.orientationMagnitude != as.orientationMagnitude) {
                return false;
            }
            return this.distPerpendicular == as.distPerpendicular;
        }

        public float distanceFromEndOf(TextChunk other) {
            float distance = this.distParallelStart - other.distParallelEnd;
            return distance;
        }

        @Override
        public int compareTo(TextChunk rhs) {
            if (this == rhs) {
                return 0;
            }
            int rslt = TextChunk.compareInts(this.orientationMagnitude, rhs.orientationMagnitude);
            if (rslt != 0) {
                return rslt;
            }
            rslt = TextChunk.compareInts(this.distPerpendicular, rhs.distPerpendicular);
            if (rslt != 0) {
                return rslt;
            }
            return Float.compare(this.distParallelStart, rhs.distParallelStart);
        }

        private static int compareInts(int int1, int int2) {
            return int1 == int2 ? 0 : (int1 < int2 ? -1 : 1);
        }
    }

    public static interface TextChunkFilter {
        public boolean accept(TextChunk var1);
    }
}

